/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Quota
implements ApiMessage {
    private final Double limit;
    private final String metric;
    private final String owner;
    private final Double usage;
    private static final Quota DEFAULT_INSTANCE = new Quota();

    private Quota() {
        this.limit = null;
        this.metric = null;
        this.owner = null;
        this.usage = null;
    }

    private Quota(Double limit, String metric, String owner, Double usage) {
        this.limit = limit;
        this.metric = metric;
        this.owner = owner;
        this.usage = usage;
    }

    public Object getFieldValue(String fieldName) {
        if ("limit".equals(fieldName)) {
            return this.limit;
        }
        if ("metric".equals(fieldName)) {
            return this.metric;
        }
        if ("owner".equals(fieldName)) {
            return this.owner;
        }
        if ("usage".equals(fieldName)) {
            return this.usage;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Double getLimit() {
        return this.limit;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getOwner() {
        return this.owner;
    }

    public Double getUsage() {
        return this.usage;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Quota prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Quota getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Quota{limit=" + this.limit + ", metric=" + this.metric + ", owner=" + this.owner + ", usage=" + this.usage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Quota) {
            Quota that = (Quota)o;
            return Objects.equals(this.limit, that.getLimit()) && Objects.equals(this.metric, that.getMetric()) && Objects.equals(this.owner, that.getOwner()) && Objects.equals(this.usage, that.getUsage());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.metric, this.owner, this.usage);
    }

    public static class Builder {
        private Double limit;
        private String metric;
        private String owner;
        private Double usage;

        Builder() {
        }

        public Builder mergeFrom(Quota other) {
            if (other == Quota.getDefaultInstance()) {
                return this;
            }
            if (other.getLimit() != null) {
                this.limit = other.limit;
            }
            if (other.getMetric() != null) {
                this.metric = other.metric;
            }
            if (other.getOwner() != null) {
                this.owner = other.owner;
            }
            if (other.getUsage() != null) {
                this.usage = other.usage;
            }
            return this;
        }

        Builder(Quota source) {
            this.limit = source.limit;
            this.metric = source.metric;
            this.owner = source.owner;
            this.usage = source.usage;
        }

        public Double getLimit() {
            return this.limit;
        }

        public Builder setLimit(Double limit) {
            this.limit = limit;
            return this;
        }

        public String getMetric() {
            return this.metric;
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        public String getOwner() {
            return this.owner;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Double getUsage() {
            return this.usage;
        }

        public Builder setUsage(Double usage) {
            this.usage = usage;
            return this;
        }

        public Quota build() {
            return new Quota(this.limit, this.metric, this.owner, this.usage);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setLimit(this.limit);
            newBuilder.setMetric(this.metric);
            newBuilder.setOwner(this.owner);
            newBuilder.setUsage(this.usage);
            return newBuilder;
        }
    }
}

