/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneNetworkEndpointGroupName
implements ResourceName {
    private final String networkEndpointGroup;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneNetworkEndpointGroupName(Builder builder) {
        this.networkEndpointGroup = (String)Preconditions.checkNotNull((Object)builder.getNetworkEndpointGroup());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneNetworkEndpointGroupName of(String networkEndpointGroup, String project, String zone) {
        return ProjectZoneNetworkEndpointGroupName.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setProject(project).setZone(zone).build();
    }

    public static String format(String networkEndpointGroup, String project, String zone) {
        return ProjectZoneNetworkEndpointGroupName.of(networkEndpointGroup, project, zone).toString();
    }

    public String getNetworkEndpointGroup() {
        return this.networkEndpointGroup;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneNetworkEndpointGroupName projectZoneNetworkEndpointGroupName = this;
            synchronized (projectZoneNetworkEndpointGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"networkEndpointGroup", (Object)this.networkEndpointGroup);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneNetworkEndpointGroupName> newFactory() {
        return new ResourceNameFactory<ProjectZoneNetworkEndpointGroupName>(){

            public ProjectZoneNetworkEndpointGroupName parse(String formattedString) {
                return ProjectZoneNetworkEndpointGroupName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneNetworkEndpointGroupName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneNetworkEndpointGroupName.parse: formattedString not in valid format");
        return ProjectZoneNetworkEndpointGroupName.of((String)matchMap.get("networkEndpointGroup"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"networkEndpointGroup", this.networkEndpointGroup, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneNetworkEndpointGroupName) {
            ProjectZoneNetworkEndpointGroupName that = (ProjectZoneNetworkEndpointGroupName)o;
            return Objects.equals(this.networkEndpointGroup, that.getNetworkEndpointGroup()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.networkEndpointGroup, this.project, this.zone);
    }

    public static class Builder {
        private String networkEndpointGroup;
        private String project;
        private String zone;

        public String getNetworkEndpointGroup() {
            return this.networkEndpointGroup;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setNetworkEndpointGroup(String networkEndpointGroup) {
            this.networkEndpointGroup = networkEndpointGroup;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneNetworkEndpointGroupName projectZoneNetworkEndpointGroupName) {
            this.networkEndpointGroup = projectZoneNetworkEndpointGroupName.networkEndpointGroup;
            this.project = projectZoneNetworkEndpointGroupName.project;
            this.zone = projectZoneNetworkEndpointGroupName.zone;
        }

        public ProjectZoneNetworkEndpointGroupName build() {
            return new ProjectZoneNetworkEndpointGroupName(this);
        }
    }
}

