/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneDiskTypeName
implements ResourceName {
    private final String diskType;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/diskTypes/{diskType}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneDiskTypeName(Builder builder) {
        this.diskType = (String)Preconditions.checkNotNull((Object)builder.getDiskType());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneDiskTypeName of(String diskType, String project, String zone) {
        return ProjectZoneDiskTypeName.newBuilder().setDiskType(diskType).setProject(project).setZone(zone).build();
    }

    public static String format(String diskType, String project, String zone) {
        return ProjectZoneDiskTypeName.of(diskType, project, zone).toString();
    }

    public String getDiskType() {
        return this.diskType;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneDiskTypeName projectZoneDiskTypeName = this;
            synchronized (projectZoneDiskTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"diskType", (Object)this.diskType);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneDiskTypeName> newFactory() {
        return new ResourceNameFactory<ProjectZoneDiskTypeName>(){

            public ProjectZoneDiskTypeName parse(String formattedString) {
                return ProjectZoneDiskTypeName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneDiskTypeName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneDiskTypeName.parse: formattedString not in valid format");
        return ProjectZoneDiskTypeName.of((String)matchMap.get("diskType"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"diskType", this.diskType, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneDiskTypeName) {
            ProjectZoneDiskTypeName that = (ProjectZoneDiskTypeName)o;
            return Objects.equals(this.diskType, that.getDiskType()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.diskType, this.project, this.zone);
    }

    public static class Builder {
        private String diskType;
        private String project;
        private String zone;

        public String getDiskType() {
            return this.diskType;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setDiskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneDiskTypeName projectZoneDiskTypeName) {
            this.diskType = projectZoneDiskTypeName.diskType;
            this.project = projectZoneDiskTypeName.project;
            this.zone = projectZoneDiskTypeName.zone;
        }

        public ProjectZoneDiskTypeName build() {
            return new ProjectZoneDiskTypeName(this);
        }
    }
}

