/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneAcceleratorTypeName
implements ResourceName {
    private final String acceleratorType;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/acceleratorTypes/{acceleratorType}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneAcceleratorTypeName(Builder builder) {
        this.acceleratorType = (String)Preconditions.checkNotNull((Object)builder.getAcceleratorType());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneAcceleratorTypeName of(String acceleratorType, String project, String zone) {
        return ProjectZoneAcceleratorTypeName.newBuilder().setAcceleratorType(acceleratorType).setProject(project).setZone(zone).build();
    }

    public static String format(String acceleratorType, String project, String zone) {
        return ProjectZoneAcceleratorTypeName.of(acceleratorType, project, zone).toString();
    }

    public String getAcceleratorType() {
        return this.acceleratorType;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneAcceleratorTypeName projectZoneAcceleratorTypeName = this;
            synchronized (projectZoneAcceleratorTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"acceleratorType", (Object)this.acceleratorType);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneAcceleratorTypeName> newFactory() {
        return new ResourceNameFactory<ProjectZoneAcceleratorTypeName>(){

            public ProjectZoneAcceleratorTypeName parse(String formattedString) {
                return ProjectZoneAcceleratorTypeName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneAcceleratorTypeName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneAcceleratorTypeName.parse: formattedString not in valid format");
        return ProjectZoneAcceleratorTypeName.of((String)matchMap.get("acceleratorType"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"acceleratorType", this.acceleratorType, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneAcceleratorTypeName) {
            ProjectZoneAcceleratorTypeName that = (ProjectZoneAcceleratorTypeName)o;
            return Objects.equals(this.acceleratorType, that.getAcceleratorType()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.acceleratorType, this.project, this.zone);
    }

    public static class Builder {
        private String acceleratorType;
        private String project;
        private String zone;

        public String getAcceleratorType() {
            return this.acceleratorType;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneAcceleratorTypeName projectZoneAcceleratorTypeName) {
            this.acceleratorType = projectZoneAcceleratorTypeName.acceleratorType;
            this.project = projectZoneAcceleratorTypeName.project;
            this.zone = projectZoneAcceleratorTypeName.zone;
        }

        public ProjectZoneAcceleratorTypeName build() {
            return new ProjectZoneAcceleratorTypeName(this);
        }
    }
}

