/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectTargetHttpProxyName
implements ResourceName {
    private final String project;
    private final String targetHttpProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/targetHttpProxies/{targetHttpProxy}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectTargetHttpProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetHttpProxy());
    }

    public static ProjectTargetHttpProxyName of(String project, String targetHttpProxy) {
        return ProjectTargetHttpProxyName.newBuilder().setProject(project).setTargetHttpProxy(targetHttpProxy).build();
    }

    public static String format(String project, String targetHttpProxy) {
        return ProjectTargetHttpProxyName.of(project, targetHttpProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetHttpProxy() {
        return this.targetHttpProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectTargetHttpProxyName projectTargetHttpProxyName = this;
            synchronized (projectTargetHttpProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetHttpProxy", (Object)this.targetHttpProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectTargetHttpProxyName> newFactory() {
        return new ResourceNameFactory<ProjectTargetHttpProxyName>(){

            public ProjectTargetHttpProxyName parse(String formattedString) {
                return ProjectTargetHttpProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectTargetHttpProxyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectTargetHttpProxyName.parse: formattedString not in valid format");
        return ProjectTargetHttpProxyName.of((String)matchMap.get("project"), (String)matchMap.get("targetHttpProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetHttpProxy", this.targetHttpProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectTargetHttpProxyName) {
            ProjectTargetHttpProxyName that = (ProjectTargetHttpProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetHttpProxy, that.getTargetHttpProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetHttpProxy);
    }

    public static class Builder {
        private String project;
        private String targetHttpProxy;

        public String getProject() {
            return this.project;
        }

        public String getTargetHttpProxy() {
            return this.targetHttpProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetHttpProxy(String targetHttpProxy) {
            this.targetHttpProxy = targetHttpProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectTargetHttpProxyName projectTargetHttpProxyName) {
            this.project = projectTargetHttpProxyName.project;
            this.targetHttpProxy = projectTargetHttpProxyName.targetHttpProxy;
        }

        public ProjectTargetHttpProxyName build() {
            return new ProjectTargetHttpProxyName(this);
        }
    }
}

