/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalBackendServiceName
implements ResourceName {
    private final String backendService;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/backendServices/{backendService}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalBackendServiceName(Builder builder) {
        this.backendService = (String)Preconditions.checkNotNull((Object)builder.getBackendService());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalBackendServiceName of(String backendService, String project) {
        return ProjectGlobalBackendServiceName.newBuilder().setBackendService(backendService).setProject(project).build();
    }

    public static String format(String backendService, String project) {
        return ProjectGlobalBackendServiceName.of(backendService, project).toString();
    }

    public String getBackendService() {
        return this.backendService;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalBackendServiceName projectGlobalBackendServiceName = this;
            synchronized (projectGlobalBackendServiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"backendService", (Object)this.backendService);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalBackendServiceName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalBackendServiceName>(){

            public ProjectGlobalBackendServiceName parse(String formattedString) {
                return ProjectGlobalBackendServiceName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalBackendServiceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalBackendServiceName.parse: formattedString not in valid format");
        return ProjectGlobalBackendServiceName.of((String)matchMap.get("backendService"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"backendService", this.backendService, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalBackendServiceName) {
            ProjectGlobalBackendServiceName that = (ProjectGlobalBackendServiceName)o;
            return Objects.equals(this.backendService, that.getBackendService()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendService, this.project);
    }

    public static class Builder {
        private String backendService;
        private String project;

        public String getBackendService() {
            return this.backendService;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setBackendService(String backendService) {
            this.backendService = backendService;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalBackendServiceName projectGlobalBackendServiceName) {
            this.backendService = projectGlobalBackendServiceName.backendService;
            this.project = projectGlobalBackendServiceName.project;
        }

        public ProjectGlobalBackendServiceName build() {
            return new ProjectGlobalBackendServiceName(this);
        }
    }
}

