/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTypesHttpRequest;
import com.google.cloud.compute.v1.GetNodeTypeHttpRequest;
import com.google.cloud.compute.v1.ListNodeTypesHttpRequest;
import com.google.cloud.compute.v1.NodeType;
import com.google.cloud.compute.v1.NodeTypeAggregatedList;
import com.google.cloud.compute.v1.NodeTypeList;
import com.google.cloud.compute.v1.NodeTypeSettings;
import com.google.cloud.compute.v1.NodeTypesScopedList;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneNodeTypeName;
import com.google.cloud.compute.v1.stub.NodeTypeStub;
import com.google.cloud.compute.v1.stub.NodeTypeStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NodeTypeClient
implements BackgroundResource {
    private final NodeTypeSettings settings;
    private final NodeTypeStub stub;

    public static final NodeTypeClient create() throws IOException {
        return NodeTypeClient.create(NodeTypeSettings.newBuilder().build());
    }

    public static final NodeTypeClient create(NodeTypeSettings settings) throws IOException {
        return new NodeTypeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NodeTypeClient create(NodeTypeStub stub) {
        return new NodeTypeClient(stub);
    }

    protected NodeTypeClient(NodeTypeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeTypeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NodeTypeClient(NodeTypeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeTypeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTypeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListNodeTypesPagedResponse aggregatedListNodeTypes(ProjectName project) {
        AggregatedListNodeTypesHttpRequest request = AggregatedListNodeTypesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListNodeTypes(request);
    }

    @BetaApi
    public final AggregatedListNodeTypesPagedResponse aggregatedListNodeTypes(String project) {
        AggregatedListNodeTypesHttpRequest request = AggregatedListNodeTypesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListNodeTypes(request);
    }

    @BetaApi
    public final AggregatedListNodeTypesPagedResponse aggregatedListNodeTypes(AggregatedListNodeTypesHttpRequest request) {
        return (AggregatedListNodeTypesPagedResponse)((Object)this.aggregatedListNodeTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeTypesHttpRequest, AggregatedListNodeTypesPagedResponse> aggregatedListNodeTypesPagedCallable() {
        return this.stub.aggregatedListNodeTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList> aggregatedListNodeTypesCallable() {
        return this.stub.aggregatedListNodeTypesCallable();
    }

    @BetaApi
    public final NodeType getNodeType(ProjectZoneNodeTypeName nodeType) {
        GetNodeTypeHttpRequest request = GetNodeTypeHttpRequest.newBuilder().setNodeType(nodeType == null ? null : nodeType.toString()).build();
        return this.getNodeType(request);
    }

    @BetaApi
    public final NodeType getNodeType(String nodeType) {
        GetNodeTypeHttpRequest request = GetNodeTypeHttpRequest.newBuilder().setNodeType(nodeType).build();
        return this.getNodeType(request);
    }

    @BetaApi
    public final NodeType getNodeType(GetNodeTypeHttpRequest request) {
        return (NodeType)this.getNodeTypeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetNodeTypeHttpRequest, NodeType> getNodeTypeCallable() {
        return this.stub.getNodeTypeCallable();
    }

    @BetaApi
    public final ListNodeTypesPagedResponse listNodeTypes(ProjectZoneName zone) {
        ListNodeTypesHttpRequest request = ListNodeTypesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listNodeTypes(request);
    }

    @BetaApi
    public final ListNodeTypesPagedResponse listNodeTypes(String zone) {
        ListNodeTypesHttpRequest request = ListNodeTypesHttpRequest.newBuilder().setZone(zone).build();
        return this.listNodeTypes(request);
    }

    @BetaApi
    public final ListNodeTypesPagedResponse listNodeTypes(ListNodeTypesHttpRequest request) {
        return (ListNodeTypesPagedResponse)((Object)this.listNodeTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNodeTypesHttpRequest, ListNodeTypesPagedResponse> listNodeTypesPagedCallable() {
        return this.stub.listNodeTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNodeTypesHttpRequest, NodeTypeList> listNodeTypesCallable() {
        return this.stub.listNodeTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNodeTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTypesHttpRequest, NodeTypeList, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        private ListNodeTypesFixedSizeCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodeTypesFixedSizeCollection createEmptyCollection() {
            return new ListNodeTypesFixedSizeCollection(null, 0);
        }

        protected ListNodeTypesFixedSizeCollection createCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            return new ListNodeTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodeTypesPage
    extends AbstractPage<ListNodeTypesHttpRequest, NodeTypeList, NodeType, ListNodeTypesPage> {
        private ListNodeTypesPage(PageContext<ListNodeTypesHttpRequest, NodeTypeList, NodeType> context, NodeTypeList response) {
            super(context, (Object)response);
        }

        private static ListNodeTypesPage createEmptyPage() {
            return new ListNodeTypesPage(null, null);
        }

        protected ListNodeTypesPage createPage(PageContext<ListNodeTypesHttpRequest, NodeTypeList, NodeType> context, NodeTypeList response) {
            return new ListNodeTypesPage(context, response);
        }

        public ApiFuture<ListNodeTypesPage> createPageAsync(PageContext<ListNodeTypesHttpRequest, NodeTypeList, NodeType> context, ApiFuture<NodeTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodeTypesPagedResponse
    extends AbstractPagedListResponse<ListNodeTypesHttpRequest, NodeTypeList, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        public static ApiFuture<ListNodeTypesPagedResponse> createAsync(PageContext<ListNodeTypesHttpRequest, NodeTypeList, NodeType> context, ApiFuture<NodeTypeList> futureResponse) {
            ApiFuture<ListNodeTypesPage> futurePage = ListNodeTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNodeTypesPage, ListNodeTypesPagedResponse>(){

                public ListNodeTypesPagedResponse apply(ListNodeTypesPage input) {
                    return new ListNodeTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNodeTypesPagedResponse(ListNodeTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodeTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListNodeTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList, AggregatedListNodeTypesPage, AggregatedListNodeTypesFixedSizeCollection> {
        private AggregatedListNodeTypesFixedSizeCollection(List<AggregatedListNodeTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListNodeTypesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListNodeTypesFixedSizeCollection(null, 0);
        }

        protected AggregatedListNodeTypesFixedSizeCollection createCollection(List<AggregatedListNodeTypesPage> pages, int collectionSize) {
            return new AggregatedListNodeTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListNodeTypesPage
    extends AbstractPage<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList, AggregatedListNodeTypesPage> {
        private AggregatedListNodeTypesPage(PageContext<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList> context, NodeTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListNodeTypesPage createEmptyPage() {
            return new AggregatedListNodeTypesPage(null, null);
        }

        protected AggregatedListNodeTypesPage createPage(PageContext<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList> context, NodeTypeAggregatedList response) {
            return new AggregatedListNodeTypesPage(context, response);
        }

        public ApiFuture<AggregatedListNodeTypesPage> createPageAsync(PageContext<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList> context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListNodeTypesPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList, AggregatedListNodeTypesPage, AggregatedListNodeTypesFixedSizeCollection> {
        public static ApiFuture<AggregatedListNodeTypesPagedResponse> createAsync(PageContext<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList> context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListNodeTypesPage> futurePage = AggregatedListNodeTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListNodeTypesPage, AggregatedListNodeTypesPagedResponse>(){

                public AggregatedListNodeTypesPagedResponse apply(AggregatedListNodeTypesPage input) {
                    return new AggregatedListNodeTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListNodeTypesPagedResponse(AggregatedListNodeTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListNodeTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

