/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectAttachmentPartnerMetadata
implements ApiMessage {
    private final String interconnectName;
    private final String partnerName;
    private final String portalUrl;
    private static final InterconnectAttachmentPartnerMetadata DEFAULT_INSTANCE = new InterconnectAttachmentPartnerMetadata();

    private InterconnectAttachmentPartnerMetadata() {
        this.interconnectName = null;
        this.partnerName = null;
        this.portalUrl = null;
    }

    private InterconnectAttachmentPartnerMetadata(String interconnectName, String partnerName, String portalUrl) {
        this.interconnectName = interconnectName;
        this.partnerName = partnerName;
        this.portalUrl = portalUrl;
    }

    public Object getFieldValue(String fieldName) {
        if ("interconnectName".equals(fieldName)) {
            return this.interconnectName;
        }
        if ("partnerName".equals(fieldName)) {
            return this.partnerName;
        }
        if ("portalUrl".equals(fieldName)) {
            return this.portalUrl;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInterconnectName() {
        return this.interconnectName;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectAttachmentPartnerMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectAttachmentPartnerMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectAttachmentPartnerMetadata{interconnectName=" + this.interconnectName + ", partnerName=" + this.partnerName + ", portalUrl=" + this.portalUrl + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectAttachmentPartnerMetadata) {
            InterconnectAttachmentPartnerMetadata that = (InterconnectAttachmentPartnerMetadata)o;
            return Objects.equals(this.interconnectName, that.getInterconnectName()) && Objects.equals(this.partnerName, that.getPartnerName()) && Objects.equals(this.portalUrl, that.getPortalUrl());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.interconnectName, this.partnerName, this.portalUrl);
    }

    public static class Builder {
        private String interconnectName;
        private String partnerName;
        private String portalUrl;

        Builder() {
        }

        public Builder mergeFrom(InterconnectAttachmentPartnerMetadata other) {
            if (other == InterconnectAttachmentPartnerMetadata.getDefaultInstance()) {
                return this;
            }
            if (other.getInterconnectName() != null) {
                this.interconnectName = other.interconnectName;
            }
            if (other.getPartnerName() != null) {
                this.partnerName = other.partnerName;
            }
            if (other.getPortalUrl() != null) {
                this.portalUrl = other.portalUrl;
            }
            return this;
        }

        Builder(InterconnectAttachmentPartnerMetadata source) {
            this.interconnectName = source.interconnectName;
            this.partnerName = source.partnerName;
            this.portalUrl = source.portalUrl;
        }

        public String getInterconnectName() {
            return this.interconnectName;
        }

        public Builder setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public String getPartnerName() {
            return this.partnerName;
        }

        public Builder setPartnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public String getPortalUrl() {
            return this.portalUrl;
        }

        public Builder setPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public InterconnectAttachmentPartnerMetadata build() {
            return new InterconnectAttachmentPartnerMetadata(this.interconnectName, this.partnerName, this.portalUrl);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInterconnectName(this.interconnectName);
            newBuilder.setPartnerName(this.partnerName);
            newBuilder.setPortalUrl(this.portalUrl);
            return newBuilder;
        }
    }
}

