/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceReference
implements ApiMessage {
    private final String instance;
    private static final InstanceReference DEFAULT_INSTANCE = new InstanceReference();

    private InstanceReference() {
        this.instance = null;
    }

    private InstanceReference(String instance) {
        this.instance = instance;
    }

    public Object getFieldValue(String fieldName) {
        if ("instance".equals(fieldName)) {
            return this.instance;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceReference prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceReference getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceReference{instance=" + this.instance + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceReference) {
            InstanceReference that = (InstanceReference)o;
            return Objects.equals(this.instance, that.getInstance());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instance);
    }

    public static class Builder {
        private String instance;

        Builder() {
        }

        public Builder mergeFrom(InstanceReference other) {
            if (other == InstanceReference.getDefaultInstance()) {
                return this;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            return this;
        }

        Builder(InstanceReference source) {
            this.instance = source.instance;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public InstanceReference build() {
            return new InstanceReference(this.instance);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstance(this.instance);
            return newBuilder;
        }
    }
}

