/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceMoveRequest
implements ApiMessage {
    private final String destinationZone;
    private final String targetInstance;
    private static final InstanceMoveRequest DEFAULT_INSTANCE = new InstanceMoveRequest();

    private InstanceMoveRequest() {
        this.destinationZone = null;
        this.targetInstance = null;
    }

    private InstanceMoveRequest(String destinationZone, String targetInstance) {
        this.destinationZone = destinationZone;
        this.targetInstance = targetInstance;
    }

    public Object getFieldValue(String fieldName) {
        if ("destinationZone".equals(fieldName)) {
            return this.destinationZone;
        }
        if ("targetInstance".equals(fieldName)) {
            return this.targetInstance;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDestinationZone() {
        return this.destinationZone;
    }

    public String getTargetInstance() {
        return this.targetInstance;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceMoveRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceMoveRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceMoveRequest{destinationZone=" + this.destinationZone + ", targetInstance=" + this.targetInstance + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceMoveRequest) {
            InstanceMoveRequest that = (InstanceMoveRequest)o;
            return Objects.equals(this.destinationZone, that.getDestinationZone()) && Objects.equals(this.targetInstance, that.getTargetInstance());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.destinationZone, this.targetInstance);
    }

    public static class Builder {
        private String destinationZone;
        private String targetInstance;

        Builder() {
        }

        public Builder mergeFrom(InstanceMoveRequest other) {
            if (other == InstanceMoveRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getDestinationZone() != null) {
                this.destinationZone = other.destinationZone;
            }
            if (other.getTargetInstance() != null) {
                this.targetInstance = other.targetInstance;
            }
            return this;
        }

        Builder(InstanceMoveRequest source) {
            this.destinationZone = source.destinationZone;
            this.targetInstance = source.targetInstance;
        }

        public String getDestinationZone() {
            return this.destinationZone;
        }

        public Builder setDestinationZone(String destinationZone) {
            this.destinationZone = destinationZone;
            return this;
        }

        public String getTargetInstance() {
            return this.targetInstance;
        }

        public Builder setTargetInstance(String targetInstance) {
            this.targetInstance = targetInstance;
            return this;
        }

        public InstanceMoveRequest build() {
            return new InstanceMoveRequest(this.destinationZone, this.targetInstance);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDestinationZone(this.destinationZone);
            newBuilder.setTargetInstance(this.targetInstance);
            return newBuilder;
        }
    }
}

