/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupsScopedList
implements ApiMessage {
    private final List<InstanceGroup> instanceGroups;
    private final Warning warning;
    private static final InstanceGroupsScopedList DEFAULT_INSTANCE = new InstanceGroupsScopedList();

    private InstanceGroupsScopedList() {
        this.instanceGroups = null;
        this.warning = null;
    }

    private InstanceGroupsScopedList(List<InstanceGroup> instanceGroups, Warning warning) {
        this.instanceGroups = instanceGroups;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("instanceGroups".equals(fieldName)) {
            return this.instanceGroups;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InstanceGroup> getInstanceGroupsList() {
        return this.instanceGroups;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupsScopedList{instanceGroups=" + this.instanceGroups + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupsScopedList) {
            InstanceGroupsScopedList that = (InstanceGroupsScopedList)o;
            return Objects.equals(this.instanceGroups, that.getInstanceGroupsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroups, this.warning);
    }

    public static class Builder {
        private List<InstanceGroup> instanceGroups;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupsScopedList other) {
            if (other == InstanceGroupsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getInstanceGroupsList() != null) {
                this.instanceGroups = other.instanceGroups;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(InstanceGroupsScopedList source) {
            this.instanceGroups = source.instanceGroups;
            this.warning = source.warning;
        }

        public List<InstanceGroup> getInstanceGroupsList() {
            return this.instanceGroups;
        }

        public Builder addAllInstanceGroups(List<InstanceGroup> instanceGroups) {
            if (this.instanceGroups == null) {
                this.instanceGroups = new LinkedList<InstanceGroup>();
            }
            this.instanceGroups.addAll(instanceGroups);
            return this;
        }

        public Builder addInstanceGroups(InstanceGroup instanceGroups) {
            if (this.instanceGroups == null) {
                this.instanceGroups = new LinkedList<InstanceGroup>();
            }
            this.instanceGroups.add(instanceGroups);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public InstanceGroupsScopedList build() {
            return new InstanceGroupsScopedList(this.instanceGroups, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstanceGroups(this.instanceGroups);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

