/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.TargetInstance;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InsertTargetInstanceHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final TargetInstance targetInstanceResource;
    private final String userIp;
    private final String zone;
    private static final InsertTargetInstanceHttpRequest DEFAULT_INSTANCE = new InsertTargetInstanceHttpRequest();

    private InsertTargetInstanceHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.targetInstanceResource = null;
        this.userIp = null;
        this.zone = null;
    }

    private InsertTargetInstanceHttpRequest(String access_token, String callback, String fields, String key, String prettyPrint, String quotaUser, String requestId, TargetInstance targetInstanceResource, String userIp, String zone) {
        this.access_token = access_token;
        this.callback = callback;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.targetInstanceResource = targetInstanceResource;
        this.userIp = userIp;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("access_token".equals(fieldName)) {
            return this.access_token;
        }
        if ("callback".equals(fieldName)) {
            return this.callback;
        }
        if ("fields".equals(fieldName)) {
            return this.fields;
        }
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("prettyPrint".equals(fieldName)) {
            return this.prettyPrint;
        }
        if ("quotaUser".equals(fieldName)) {
            return this.quotaUser;
        }
        if ("requestId".equals(fieldName)) {
            return this.requestId;
        }
        if ("targetInstanceResource".equals(fieldName)) {
            return this.targetInstanceResource;
        }
        if ("userIp".equals(fieldName)) {
            return this.userIp;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public TargetInstance getApiMessageRequestBody() {
        return this.targetInstanceResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public TargetInstance getTargetInstanceResource() {
        return this.targetInstanceResource;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsertTargetInstanceHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InsertTargetInstanceHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InsertTargetInstanceHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", targetInstanceResource=" + this.targetInstanceResource + ", userIp=" + this.userIp + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsertTargetInstanceHttpRequest) {
            InsertTargetInstanceHttpRequest that = (InsertTargetInstanceHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.targetInstanceResource, that.getTargetInstanceResource()) && Objects.equals(this.userIp, that.getUserIp()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.targetInstanceResource, this.userIp, this.zone);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private TargetInstance targetInstanceResource;
        private String userIp;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(InsertTargetInstanceHttpRequest other) {
            if (other == InsertTargetInstanceHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getTargetInstanceResource() != null) {
                this.targetInstanceResource = other.targetInstanceResource;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(InsertTargetInstanceHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.targetInstanceResource = source.targetInstanceResource;
            this.userIp = source.userIp;
            this.zone = source.zone;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public TargetInstance getTargetInstanceResource() {
            return this.targetInstanceResource;
        }

        public Builder setTargetInstanceResource(TargetInstance targetInstanceResource) {
            this.targetInstanceResource = targetInstanceResource;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public InsertTargetInstanceHttpRequest build() {
            String missing = "";
            if (this.zone == null) {
                missing = missing + " zone";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new InsertTargetInstanceHttpRequest(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.targetInstanceResource, this.userIp, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setTargetInstanceResource(this.targetInstanceResource);
            newBuilder.setUserIp(this.userIp);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

