/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import com.google.cloud.compute.v1.DeprecationStatus;
import com.google.cloud.compute.v1.GuestOsFeature;
import com.google.cloud.compute.v1.RawDisk;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Image
implements ApiMessage {
    private final String archiveSizeBytes;
    private final String creationTimestamp;
    private final DeprecationStatus deprecated;
    private final String description;
    private final String diskSizeGb;
    private final String family;
    private final List<GuestOsFeature> guestOsFeatures;
    private final String id;
    private final CustomerEncryptionKey imageEncryptionKey;
    private final String kind;
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private final List<String> licenseCodes;
    private final List<String> licenses;
    private final String name;
    private final RawDisk rawDisk;
    private final String selfLink;
    private final String sourceDisk;
    private final CustomerEncryptionKey sourceDiskEncryptionKey;
    private final String sourceDiskId;
    private final String sourceImage;
    private final CustomerEncryptionKey sourceImageEncryptionKey;
    private final String sourceImageId;
    private final String sourceSnapshot;
    private final CustomerEncryptionKey sourceSnapshotEncryptionKey;
    private final String sourceSnapshotId;
    private final String sourceType;
    private final String status;
    private static final Image DEFAULT_INSTANCE = new Image();

    private Image() {
        this.archiveSizeBytes = null;
        this.creationTimestamp = null;
        this.deprecated = null;
        this.description = null;
        this.diskSizeGb = null;
        this.family = null;
        this.guestOsFeatures = null;
        this.id = null;
        this.imageEncryptionKey = null;
        this.kind = null;
        this.labelFingerprint = null;
        this.labels = null;
        this.licenseCodes = null;
        this.licenses = null;
        this.name = null;
        this.rawDisk = null;
        this.selfLink = null;
        this.sourceDisk = null;
        this.sourceDiskEncryptionKey = null;
        this.sourceDiskId = null;
        this.sourceImage = null;
        this.sourceImageEncryptionKey = null;
        this.sourceImageId = null;
        this.sourceSnapshot = null;
        this.sourceSnapshotEncryptionKey = null;
        this.sourceSnapshotId = null;
        this.sourceType = null;
        this.status = null;
    }

    private Image(String archiveSizeBytes, String creationTimestamp, DeprecationStatus deprecated, String description, String diskSizeGb, String family, List<GuestOsFeature> guestOsFeatures, String id, CustomerEncryptionKey imageEncryptionKey, String kind, String labelFingerprint, Map<String, String> labels, List<String> licenseCodes, List<String> licenses, String name, RawDisk rawDisk, String selfLink, String sourceDisk, CustomerEncryptionKey sourceDiskEncryptionKey, String sourceDiskId, String sourceImage, CustomerEncryptionKey sourceImageEncryptionKey, String sourceImageId, String sourceSnapshot, CustomerEncryptionKey sourceSnapshotEncryptionKey, String sourceSnapshotId, String sourceType, String status) {
        this.archiveSizeBytes = archiveSizeBytes;
        this.creationTimestamp = creationTimestamp;
        this.deprecated = deprecated;
        this.description = description;
        this.diskSizeGb = diskSizeGb;
        this.family = family;
        this.guestOsFeatures = guestOsFeatures;
        this.id = id;
        this.imageEncryptionKey = imageEncryptionKey;
        this.kind = kind;
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
        this.licenseCodes = licenseCodes;
        this.licenses = licenses;
        this.name = name;
        this.rawDisk = rawDisk;
        this.selfLink = selfLink;
        this.sourceDisk = sourceDisk;
        this.sourceDiskEncryptionKey = sourceDiskEncryptionKey;
        this.sourceDiskId = sourceDiskId;
        this.sourceImage = sourceImage;
        this.sourceImageEncryptionKey = sourceImageEncryptionKey;
        this.sourceImageId = sourceImageId;
        this.sourceSnapshot = sourceSnapshot;
        this.sourceSnapshotEncryptionKey = sourceSnapshotEncryptionKey;
        this.sourceSnapshotId = sourceSnapshotId;
        this.sourceType = sourceType;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("archiveSizeBytes".equals(fieldName)) {
            return this.archiveSizeBytes;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("deprecated".equals(fieldName)) {
            return this.deprecated;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("diskSizeGb".equals(fieldName)) {
            return this.diskSizeGb;
        }
        if ("family".equals(fieldName)) {
            return this.family;
        }
        if ("guestOsFeatures".equals(fieldName)) {
            return this.guestOsFeatures;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("imageEncryptionKey".equals(fieldName)) {
            return this.imageEncryptionKey;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("licenseCodes".equals(fieldName)) {
            return this.licenseCodes;
        }
        if ("licenses".equals(fieldName)) {
            return this.licenses;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("rawDisk".equals(fieldName)) {
            return this.rawDisk;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("sourceDisk".equals(fieldName)) {
            return this.sourceDisk;
        }
        if ("sourceDiskEncryptionKey".equals(fieldName)) {
            return this.sourceDiskEncryptionKey;
        }
        if ("sourceDiskId".equals(fieldName)) {
            return this.sourceDiskId;
        }
        if ("sourceImage".equals(fieldName)) {
            return this.sourceImage;
        }
        if ("sourceImageEncryptionKey".equals(fieldName)) {
            return this.sourceImageEncryptionKey;
        }
        if ("sourceImageId".equals(fieldName)) {
            return this.sourceImageId;
        }
        if ("sourceSnapshot".equals(fieldName)) {
            return this.sourceSnapshot;
        }
        if ("sourceSnapshotEncryptionKey".equals(fieldName)) {
            return this.sourceSnapshotEncryptionKey;
        }
        if ("sourceSnapshotId".equals(fieldName)) {
            return this.sourceSnapshotId;
        }
        if ("sourceType".equals(fieldName)) {
            return this.sourceType;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getArchiveSizeBytes() {
        return this.archiveSizeBytes;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public String getFamily() {
        return this.family;
    }

    public List<GuestOsFeature> getGuestOsFeaturesList() {
        return this.guestOsFeatures;
    }

    public String getId() {
        return this.id;
    }

    public CustomerEncryptionKey getImageEncryptionKey() {
        return this.imageEncryptionKey;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public List<String> getLicenseCodesList() {
        return this.licenseCodes;
    }

    public List<String> getLicensesList() {
        return this.licenses;
    }

    public String getName() {
        return this.name;
    }

    public RawDisk getRawDisk() {
        return this.rawDisk;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getSourceDisk() {
        return this.sourceDisk;
    }

    public CustomerEncryptionKey getSourceDiskEncryptionKey() {
        return this.sourceDiskEncryptionKey;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public CustomerEncryptionKey getSourceImageEncryptionKey() {
        return this.sourceImageEncryptionKey;
    }

    public String getSourceImageId() {
        return this.sourceImageId;
    }

    public String getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    public CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
        return this.sourceSnapshotEncryptionKey;
    }

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Image prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Image getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Image{archiveSizeBytes=" + this.archiveSizeBytes + ", creationTimestamp=" + this.creationTimestamp + ", deprecated=" + this.deprecated + ", description=" + this.description + ", diskSizeGb=" + this.diskSizeGb + ", family=" + this.family + ", guestOsFeatures=" + this.guestOsFeatures + ", id=" + this.id + ", imageEncryptionKey=" + this.imageEncryptionKey + ", kind=" + this.kind + ", labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + ", licenseCodes=" + this.licenseCodes + ", licenses=" + this.licenses + ", name=" + this.name + ", rawDisk=" + this.rawDisk + ", selfLink=" + this.selfLink + ", sourceDisk=" + this.sourceDisk + ", sourceDiskEncryptionKey=" + this.sourceDiskEncryptionKey + ", sourceDiskId=" + this.sourceDiskId + ", sourceImage=" + this.sourceImage + ", sourceImageEncryptionKey=" + this.sourceImageEncryptionKey + ", sourceImageId=" + this.sourceImageId + ", sourceSnapshot=" + this.sourceSnapshot + ", sourceSnapshotEncryptionKey=" + this.sourceSnapshotEncryptionKey + ", sourceSnapshotId=" + this.sourceSnapshotId + ", sourceType=" + this.sourceType + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Image) {
            Image that = (Image)o;
            return Objects.equals(this.archiveSizeBytes, that.getArchiveSizeBytes()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.diskSizeGb, that.getDiskSizeGb()) && Objects.equals(this.family, that.getFamily()) && Objects.equals(this.guestOsFeatures, that.getGuestOsFeaturesList()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.imageEncryptionKey, that.getImageEncryptionKey()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.licenseCodes, that.getLicenseCodesList()) && Objects.equals(this.licenses, that.getLicensesList()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.rawDisk, that.getRawDisk()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.sourceDisk, that.getSourceDisk()) && Objects.equals(this.sourceDiskEncryptionKey, that.getSourceDiskEncryptionKey()) && Objects.equals(this.sourceDiskId, that.getSourceDiskId()) && Objects.equals(this.sourceImage, that.getSourceImage()) && Objects.equals(this.sourceImageEncryptionKey, that.getSourceImageEncryptionKey()) && Objects.equals(this.sourceImageId, that.getSourceImageId()) && Objects.equals(this.sourceSnapshot, that.getSourceSnapshot()) && Objects.equals(this.sourceSnapshotEncryptionKey, that.getSourceSnapshotEncryptionKey()) && Objects.equals(this.sourceSnapshotId, that.getSourceSnapshotId()) && Objects.equals(this.sourceType, that.getSourceType()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.archiveSizeBytes, this.creationTimestamp, this.deprecated, this.description, this.diskSizeGb, this.family, this.guestOsFeatures, this.id, this.imageEncryptionKey, this.kind, this.labelFingerprint, this.labels, this.licenseCodes, this.licenses, this.name, this.rawDisk, this.selfLink, this.sourceDisk, this.sourceDiskEncryptionKey, this.sourceDiskId, this.sourceImage, this.sourceImageEncryptionKey, this.sourceImageId, this.sourceSnapshot, this.sourceSnapshotEncryptionKey, this.sourceSnapshotId, this.sourceType, this.status);
    }

    public static class Builder {
        private String archiveSizeBytes;
        private String creationTimestamp;
        private DeprecationStatus deprecated;
        private String description;
        private String diskSizeGb;
        private String family;
        private List<GuestOsFeature> guestOsFeatures;
        private String id;
        private CustomerEncryptionKey imageEncryptionKey;
        private String kind;
        private String labelFingerprint;
        private Map<String, String> labels;
        private List<String> licenseCodes;
        private List<String> licenses;
        private String name;
        private RawDisk rawDisk;
        private String selfLink;
        private String sourceDisk;
        private CustomerEncryptionKey sourceDiskEncryptionKey;
        private String sourceDiskId;
        private String sourceImage;
        private CustomerEncryptionKey sourceImageEncryptionKey;
        private String sourceImageId;
        private String sourceSnapshot;
        private CustomerEncryptionKey sourceSnapshotEncryptionKey;
        private String sourceSnapshotId;
        private String sourceType;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(Image other) {
            if (other == Image.getDefaultInstance()) {
                return this;
            }
            if (other.getArchiveSizeBytes() != null) {
                this.archiveSizeBytes = other.archiveSizeBytes;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDiskSizeGb() != null) {
                this.diskSizeGb = other.diskSizeGb;
            }
            if (other.getFamily() != null) {
                this.family = other.family;
            }
            if (other.getGuestOsFeaturesList() != null) {
                this.guestOsFeatures = other.guestOsFeatures;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getImageEncryptionKey() != null) {
                this.imageEncryptionKey = other.imageEncryptionKey;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getLicenseCodesList() != null) {
                this.licenseCodes = other.licenseCodes;
            }
            if (other.getLicensesList() != null) {
                this.licenses = other.licenses;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRawDisk() != null) {
                this.rawDisk = other.rawDisk;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSourceDisk() != null) {
                this.sourceDisk = other.sourceDisk;
            }
            if (other.getSourceDiskEncryptionKey() != null) {
                this.sourceDiskEncryptionKey = other.sourceDiskEncryptionKey;
            }
            if (other.getSourceDiskId() != null) {
                this.sourceDiskId = other.sourceDiskId;
            }
            if (other.getSourceImage() != null) {
                this.sourceImage = other.sourceImage;
            }
            if (other.getSourceImageEncryptionKey() != null) {
                this.sourceImageEncryptionKey = other.sourceImageEncryptionKey;
            }
            if (other.getSourceImageId() != null) {
                this.sourceImageId = other.sourceImageId;
            }
            if (other.getSourceSnapshot() != null) {
                this.sourceSnapshot = other.sourceSnapshot;
            }
            if (other.getSourceSnapshotEncryptionKey() != null) {
                this.sourceSnapshotEncryptionKey = other.sourceSnapshotEncryptionKey;
            }
            if (other.getSourceSnapshotId() != null) {
                this.sourceSnapshotId = other.sourceSnapshotId;
            }
            if (other.getSourceType() != null) {
                this.sourceType = other.sourceType;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(Image source) {
            this.archiveSizeBytes = source.archiveSizeBytes;
            this.creationTimestamp = source.creationTimestamp;
            this.deprecated = source.deprecated;
            this.description = source.description;
            this.diskSizeGb = source.diskSizeGb;
            this.family = source.family;
            this.guestOsFeatures = source.guestOsFeatures;
            this.id = source.id;
            this.imageEncryptionKey = source.imageEncryptionKey;
            this.kind = source.kind;
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
            this.licenseCodes = source.licenseCodes;
            this.licenses = source.licenses;
            this.name = source.name;
            this.rawDisk = source.rawDisk;
            this.selfLink = source.selfLink;
            this.sourceDisk = source.sourceDisk;
            this.sourceDiskEncryptionKey = source.sourceDiskEncryptionKey;
            this.sourceDiskId = source.sourceDiskId;
            this.sourceImage = source.sourceImage;
            this.sourceImageEncryptionKey = source.sourceImageEncryptionKey;
            this.sourceImageId = source.sourceImageId;
            this.sourceSnapshot = source.sourceSnapshot;
            this.sourceSnapshotEncryptionKey = source.sourceSnapshotEncryptionKey;
            this.sourceSnapshotId = source.sourceSnapshotId;
            this.sourceType = source.sourceType;
            this.status = source.status;
        }

        public String getArchiveSizeBytes() {
            return this.archiveSizeBytes;
        }

        public Builder setArchiveSizeBytes(String archiveSizeBytes) {
            this.archiveSizeBytes = archiveSizeBytes;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public DeprecationStatus getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(DeprecationStatus deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public Builder setDiskSizeGb(String diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public String getFamily() {
            return this.family;
        }

        public Builder setFamily(String family) {
            this.family = family;
            return this;
        }

        public List<GuestOsFeature> getGuestOsFeaturesList() {
            return this.guestOsFeatures;
        }

        public Builder addAllGuestOsFeatures(List<GuestOsFeature> guestOsFeatures) {
            if (this.guestOsFeatures == null) {
                this.guestOsFeatures = new LinkedList<GuestOsFeature>();
            }
            this.guestOsFeatures.addAll(guestOsFeatures);
            return this;
        }

        public Builder addGuestOsFeatures(GuestOsFeature guestOsFeatures) {
            if (this.guestOsFeatures == null) {
                this.guestOsFeatures = new LinkedList<GuestOsFeature>();
            }
            this.guestOsFeatures.add(guestOsFeatures);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public CustomerEncryptionKey getImageEncryptionKey() {
            return this.imageEncryptionKey;
        }

        public Builder setImageEncryptionKey(CustomerEncryptionKey imageEncryptionKey) {
            this.imageEncryptionKey = imageEncryptionKey;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public List<String> getLicenseCodesList() {
            return this.licenseCodes;
        }

        public Builder addAllLicenseCodes(List<String> licenseCodes) {
            if (this.licenseCodes == null) {
                this.licenseCodes = new LinkedList<String>();
            }
            this.licenseCodes.addAll(licenseCodes);
            return this;
        }

        public Builder addLicenseCodes(String licenseCodes) {
            if (this.licenseCodes == null) {
                this.licenseCodes = new LinkedList<String>();
            }
            this.licenseCodes.add(licenseCodes);
            return this;
        }

        public List<String> getLicensesList() {
            return this.licenses;
        }

        public Builder addAllLicenses(List<String> licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.addAll(licenses);
            return this;
        }

        public Builder addLicenses(String licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.add(licenses);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public RawDisk getRawDisk() {
            return this.rawDisk;
        }

        public Builder setRawDisk(RawDisk rawDisk) {
            this.rawDisk = rawDisk;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getSourceDisk() {
            return this.sourceDisk;
        }

        public Builder setSourceDisk(String sourceDisk) {
            this.sourceDisk = sourceDisk;
            return this;
        }

        public CustomerEncryptionKey getSourceDiskEncryptionKey() {
            return this.sourceDiskEncryptionKey;
        }

        public Builder setSourceDiskEncryptionKey(CustomerEncryptionKey sourceDiskEncryptionKey) {
            this.sourceDiskEncryptionKey = sourceDiskEncryptionKey;
            return this;
        }

        public String getSourceDiskId() {
            return this.sourceDiskId;
        }

        public Builder setSourceDiskId(String sourceDiskId) {
            this.sourceDiskId = sourceDiskId;
            return this;
        }

        public String getSourceImage() {
            return this.sourceImage;
        }

        public Builder setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public CustomerEncryptionKey getSourceImageEncryptionKey() {
            return this.sourceImageEncryptionKey;
        }

        public Builder setSourceImageEncryptionKey(CustomerEncryptionKey sourceImageEncryptionKey) {
            this.sourceImageEncryptionKey = sourceImageEncryptionKey;
            return this;
        }

        public String getSourceImageId() {
            return this.sourceImageId;
        }

        public Builder setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public String getSourceSnapshot() {
            return this.sourceSnapshot;
        }

        public Builder setSourceSnapshot(String sourceSnapshot) {
            this.sourceSnapshot = sourceSnapshot;
            return this;
        }

        public CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
            return this.sourceSnapshotEncryptionKey;
        }

        public Builder setSourceSnapshotEncryptionKey(CustomerEncryptionKey sourceSnapshotEncryptionKey) {
            this.sourceSnapshotEncryptionKey = sourceSnapshotEncryptionKey;
            return this;
        }

        public String getSourceSnapshotId() {
            return this.sourceSnapshotId;
        }

        public Builder setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public Builder setSourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Image build() {
            return new Image(this.archiveSizeBytes, this.creationTimestamp, this.deprecated, this.description, this.diskSizeGb, this.family, this.guestOsFeatures, this.id, this.imageEncryptionKey, this.kind, this.labelFingerprint, this.labels, this.licenseCodes, this.licenses, this.name, this.rawDisk, this.selfLink, this.sourceDisk, this.sourceDiskEncryptionKey, this.sourceDiskId, this.sourceImage, this.sourceImageEncryptionKey, this.sourceImageId, this.sourceSnapshot, this.sourceSnapshotEncryptionKey, this.sourceSnapshotId, this.sourceType, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setArchiveSizeBytes(this.archiveSizeBytes);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setDescription(this.description);
            newBuilder.setDiskSizeGb(this.diskSizeGb);
            newBuilder.setFamily(this.family);
            newBuilder.addAllGuestOsFeatures(this.guestOsFeatures);
            newBuilder.setId(this.id);
            newBuilder.setImageEncryptionKey(this.imageEncryptionKey);
            newBuilder.setKind(this.kind);
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            newBuilder.addAllLicenseCodes(this.licenseCodes);
            newBuilder.addAllLicenses(this.licenses);
            newBuilder.setName(this.name);
            newBuilder.setRawDisk(this.rawDisk);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSourceDisk(this.sourceDisk);
            newBuilder.setSourceDiskEncryptionKey(this.sourceDiskEncryptionKey);
            newBuilder.setSourceDiskId(this.sourceDiskId);
            newBuilder.setSourceImage(this.sourceImage);
            newBuilder.setSourceImageEncryptionKey(this.sourceImageEncryptionKey);
            newBuilder.setSourceImageId(this.sourceImageId);
            newBuilder.setSourceSnapshot(this.sourceSnapshot);
            newBuilder.setSourceSnapshotEncryptionKey(this.sourceSnapshotEncryptionKey);
            newBuilder.setSourceSnapshotId(this.sourceSnapshotId);
            newBuilder.setSourceType(this.sourceType);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

