/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ForwardingRulesScopedList
implements ApiMessage {
    private final List<ForwardingRule> forwardingRules;
    private final Warning warning;
    private static final ForwardingRulesScopedList DEFAULT_INSTANCE = new ForwardingRulesScopedList();

    private ForwardingRulesScopedList() {
        this.forwardingRules = null;
        this.warning = null;
    }

    private ForwardingRulesScopedList(List<ForwardingRule> forwardingRules, Warning warning) {
        this.forwardingRules = forwardingRules;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("forwardingRules".equals(fieldName)) {
            return this.forwardingRules;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<ForwardingRule> getForwardingRulesList() {
        return this.forwardingRules;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ForwardingRulesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ForwardingRulesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ForwardingRulesScopedList{forwardingRules=" + this.forwardingRules + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ForwardingRulesScopedList) {
            ForwardingRulesScopedList that = (ForwardingRulesScopedList)o;
            return Objects.equals(this.forwardingRules, that.getForwardingRulesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.forwardingRules, this.warning);
    }

    public static class Builder {
        private List<ForwardingRule> forwardingRules;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(ForwardingRulesScopedList other) {
            if (other == ForwardingRulesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getForwardingRulesList() != null) {
                this.forwardingRules = other.forwardingRules;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(ForwardingRulesScopedList source) {
            this.forwardingRules = source.forwardingRules;
            this.warning = source.warning;
        }

        public List<ForwardingRule> getForwardingRulesList() {
            return this.forwardingRules;
        }

        public Builder addAllForwardingRules(List<ForwardingRule> forwardingRules) {
            if (this.forwardingRules == null) {
                this.forwardingRules = new LinkedList<ForwardingRule>();
            }
            this.forwardingRules.addAll(forwardingRules);
            return this;
        }

        public Builder addForwardingRules(ForwardingRule forwardingRules) {
            if (this.forwardingRules == null) {
                this.forwardingRules = new LinkedList<ForwardingRule>();
            }
            this.forwardingRules.add(forwardingRules);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public ForwardingRulesScopedList build() {
            return new ForwardingRulesScopedList(this.forwardingRules, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllForwardingRules(this.forwardingRules);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

