/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServiceIAP
implements ApiMessage {
    private final Boolean enabled;
    private final String oauth2ClientId;
    private final String oauth2ClientSecret;
    private final String oauth2ClientSecretSha256;
    private static final BackendServiceIAP DEFAULT_INSTANCE = new BackendServiceIAP();

    private BackendServiceIAP() {
        this.enabled = null;
        this.oauth2ClientId = null;
        this.oauth2ClientSecret = null;
        this.oauth2ClientSecretSha256 = null;
    }

    private BackendServiceIAP(Boolean enabled, String oauth2ClientId, String oauth2ClientSecret, String oauth2ClientSecretSha256) {
        this.enabled = enabled;
        this.oauth2ClientId = oauth2ClientId;
        this.oauth2ClientSecret = oauth2ClientSecret;
        this.oauth2ClientSecretSha256 = oauth2ClientSecretSha256;
    }

    public Object getFieldValue(String fieldName) {
        if ("enabled".equals(fieldName)) {
            return this.enabled;
        }
        if ("oauth2ClientId".equals(fieldName)) {
            return this.oauth2ClientId;
        }
        if ("oauth2ClientSecret".equals(fieldName)) {
            return this.oauth2ClientSecret;
        }
        if ("oauth2ClientSecretSha256".equals(fieldName)) {
            return this.oauth2ClientSecretSha256;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getOauth2ClientId() {
        return this.oauth2ClientId;
    }

    public String getOauth2ClientSecret() {
        return this.oauth2ClientSecret;
    }

    public String getOauth2ClientSecretSha256() {
        return this.oauth2ClientSecretSha256;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServiceIAP prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServiceIAP getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServiceIAP{enabled=" + this.enabled + ", oauth2ClientId=" + this.oauth2ClientId + ", oauth2ClientSecret=" + this.oauth2ClientSecret + ", oauth2ClientSecretSha256=" + this.oauth2ClientSecretSha256 + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServiceIAP) {
            BackendServiceIAP that = (BackendServiceIAP)o;
            return Objects.equals(this.enabled, that.getEnabled()) && Objects.equals(this.oauth2ClientId, that.getOauth2ClientId()) && Objects.equals(this.oauth2ClientSecret, that.getOauth2ClientSecret()) && Objects.equals(this.oauth2ClientSecretSha256, that.getOauth2ClientSecretSha256());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.oauth2ClientId, this.oauth2ClientSecret, this.oauth2ClientSecretSha256);
    }

    public static class Builder {
        private Boolean enabled;
        private String oauth2ClientId;
        private String oauth2ClientSecret;
        private String oauth2ClientSecretSha256;

        Builder() {
        }

        public Builder mergeFrom(BackendServiceIAP other) {
            if (other == BackendServiceIAP.getDefaultInstance()) {
                return this;
            }
            if (other.getEnabled() != null) {
                this.enabled = other.enabled;
            }
            if (other.getOauth2ClientId() != null) {
                this.oauth2ClientId = other.oauth2ClientId;
            }
            if (other.getOauth2ClientSecret() != null) {
                this.oauth2ClientSecret = other.oauth2ClientSecret;
            }
            if (other.getOauth2ClientSecretSha256() != null) {
                this.oauth2ClientSecretSha256 = other.oauth2ClientSecretSha256;
            }
            return this;
        }

        Builder(BackendServiceIAP source) {
            this.enabled = source.enabled;
            this.oauth2ClientId = source.oauth2ClientId;
            this.oauth2ClientSecret = source.oauth2ClientSecret;
            this.oauth2ClientSecretSha256 = source.oauth2ClientSecretSha256;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Builder setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public String getOauth2ClientId() {
            return this.oauth2ClientId;
        }

        public Builder setOauth2ClientId(String oauth2ClientId) {
            this.oauth2ClientId = oauth2ClientId;
            return this;
        }

        public String getOauth2ClientSecret() {
            return this.oauth2ClientSecret;
        }

        public Builder setOauth2ClientSecret(String oauth2ClientSecret) {
            this.oauth2ClientSecret = oauth2ClientSecret;
            return this;
        }

        public String getOauth2ClientSecretSha256() {
            return this.oauth2ClientSecretSha256;
        }

        public Builder setOauth2ClientSecretSha256(String oauth2ClientSecretSha256) {
            this.oauth2ClientSecretSha256 = oauth2ClientSecretSha256;
            return this;
        }

        public BackendServiceIAP build() {
            return new BackendServiceIAP(this.enabled, this.oauth2ClientId, this.oauth2ClientSecret, this.oauth2ClientSecretSha256);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEnabled(this.enabled);
            newBuilder.setOauth2ClientId(this.oauth2ClientId);
            newBuilder.setOauth2ClientSecret(this.oauth2ClientSecret);
            newBuilder.setOauth2ClientSecretSha256(this.oauth2ClientSecretSha256);
            return newBuilder;
        }
    }
}

