/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2beta.CaseName;
import com.google.cloud.support.v2beta.Comment;
import com.google.cloud.support.v2beta.CommentName;
import com.google.cloud.support.v2beta.CommentServiceSettings;
import com.google.cloud.support.v2beta.CreateCommentRequest;
import com.google.cloud.support.v2beta.GetCommentRequest;
import com.google.cloud.support.v2beta.ListCommentsRequest;
import com.google.cloud.support.v2beta.ListCommentsResponse;
import com.google.cloud.support.v2beta.stub.CommentServiceStub;
import com.google.cloud.support.v2beta.stub.CommentServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CommentServiceClient
implements BackgroundResource {
    private final CommentServiceSettings settings;
    private final CommentServiceStub stub;

    public static final CommentServiceClient create() throws IOException {
        return CommentServiceClient.create(CommentServiceSettings.newBuilder().build());
    }

    public static final CommentServiceClient create(CommentServiceSettings settings) throws IOException {
        return new CommentServiceClient(settings);
    }

    public static final CommentServiceClient create(CommentServiceStub stub) {
        return new CommentServiceClient(stub);
    }

    protected CommentServiceClient(CommentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CommentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CommentServiceClient(CommentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CommentServiceSettings getSettings() {
        return this.settings;
    }

    public CommentServiceStub getStub() {
        return this.stub;
    }

    public final ListCommentsPagedResponse listComments(CaseName parent) {
        ListCommentsRequest request = ListCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listComments(request);
    }

    public final ListCommentsPagedResponse listComments(String parent) {
        ListCommentsRequest request = ListCommentsRequest.newBuilder().setParent(parent).build();
        return this.listComments(request);
    }

    public final ListCommentsPagedResponse listComments(ListCommentsRequest request) {
        return (ListCommentsPagedResponse)((Object)this.listCommentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCommentsRequest, ListCommentsPagedResponse> listCommentsPagedCallable() {
        return this.stub.listCommentsPagedCallable();
    }

    public final UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable() {
        return this.stub.listCommentsCallable();
    }

    public final Comment createComment(CaseName parent, Comment comment) {
        CreateCommentRequest request = CreateCommentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setComment(comment).build();
        return this.createComment(request);
    }

    public final Comment createComment(String parent, Comment comment) {
        CreateCommentRequest request = CreateCommentRequest.newBuilder().setParent(parent).setComment(comment).build();
        return this.createComment(request);
    }

    public final Comment createComment(CreateCommentRequest request) {
        return (Comment)this.createCommentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCommentRequest, Comment> createCommentCallable() {
        return this.stub.createCommentCallable();
    }

    public final Comment getComment(CommentName name) {
        GetCommentRequest request = GetCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getComment(request);
    }

    public final Comment getComment(String name) {
        GetCommentRequest request = GetCommentRequest.newBuilder().setName(name).build();
        return this.getComment(request);
    }

    public final Comment getComment(GetCommentRequest request) {
        return (Comment)this.getCommentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCommentRequest, Comment> getCommentCallable() {
        return this.stub.getCommentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCommentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage, ListCommentsFixedSizeCollection> {
        private ListCommentsFixedSizeCollection(List<ListCommentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCommentsFixedSizeCollection createEmptyCollection() {
            return new ListCommentsFixedSizeCollection(null, 0);
        }

        protected ListCommentsFixedSizeCollection createCollection(List<ListCommentsPage> pages, int collectionSize) {
            return new ListCommentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCommentsPage
    extends AbstractPage<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage> {
        private ListCommentsPage(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ListCommentsResponse response) {
            super(context, (Object)response);
        }

        private static ListCommentsPage createEmptyPage() {
            return new ListCommentsPage(null, null);
        }

        protected ListCommentsPage createPage(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ListCommentsResponse response) {
            return new ListCommentsPage(context, response);
        }

        public ApiFuture<ListCommentsPage> createPageAsync(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ApiFuture<ListCommentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCommentsPagedResponse
    extends AbstractPagedListResponse<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage, ListCommentsFixedSizeCollection> {
        public static ApiFuture<ListCommentsPagedResponse> createAsync(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ApiFuture<ListCommentsResponse> futureResponse) {
            ApiFuture<ListCommentsPage> futurePage = ListCommentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCommentsPagedResponse((ListCommentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCommentsPagedResponse(ListCommentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCommentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

