/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Attachment;
import com.google.cloud.support.v2.CaseAttachmentServiceClient;
import com.google.cloud.support.v2.ListAttachmentsRequest;
import com.google.cloud.support.v2.ListAttachmentsResponse;
import com.google.cloud.support.v2.stub.CaseAttachmentServiceStub;
import com.google.cloud.support.v2.stub.GrpcCaseAttachmentServiceStub;
import com.google.cloud.support.v2.stub.HttpJsonCaseAttachmentServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CaseAttachmentServiceStubSettings
extends StubSettings<CaseAttachmentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings;
    private static final PagedListDescriptor<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> LIST_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAttachmentsRequest, ListAttachmentsResponse, Attachment>(){

        public String emptyToken() {
            return "";
        }

        public ListAttachmentsRequest injectToken(ListAttachmentsRequest payload, String token) {
            return ListAttachmentsRequest.newBuilder((ListAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListAttachmentsRequest injectPageSize(ListAttachmentsRequest payload, int pageSize) {
            return ListAttachmentsRequest.newBuilder((ListAttachmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAttachmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAttachmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Attachment> extractResources(ListAttachmentsResponse payload) {
            return payload.getAttachmentsList();
        }
    };
    private static final PagedListResponseFactory<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> LIST_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse>(){

        public ApiFuture<CaseAttachmentServiceClient.ListAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAttachmentsRequest, ListAttachmentsResponse> callable, ListAttachmentsRequest request, ApiCallContext context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CaseAttachmentServiceClient.ListAttachmentsPagedResponse.createAsync((PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings() {
        return this.listAttachmentsSettings;
    }

    public CaseAttachmentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCaseAttachmentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCaseAttachmentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudsupport";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudsupport.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsupport.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CaseAttachmentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseAttachmentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseAttachmentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CaseAttachmentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CaseAttachmentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAttachmentsSettings = settingsBuilder.listAttachmentsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CaseAttachmentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ATTACHMENTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAttachmentsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CaseAttachmentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAttachmentsSettings = settings.listAttachmentsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAttachmentsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CaseAttachmentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CaseAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseAttachmentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CaseAttachmentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CaseAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseAttachmentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings() {
            return this.listAttachmentsSettings;
        }

        public CaseAttachmentServiceStubSettings build() throws IOException {
            return new CaseAttachmentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

