/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Case;
import com.google.cloud.support.v2.CaseClassification;
import com.google.cloud.support.v2.CaseServiceClient;
import com.google.cloud.support.v2.CloseCaseRequest;
import com.google.cloud.support.v2.CreateCaseRequest;
import com.google.cloud.support.v2.EscalateCaseRequest;
import com.google.cloud.support.v2.GetCaseRequest;
import com.google.cloud.support.v2.ListCasesRequest;
import com.google.cloud.support.v2.ListCasesResponse;
import com.google.cloud.support.v2.SearchCaseClassificationsRequest;
import com.google.cloud.support.v2.SearchCaseClassificationsResponse;
import com.google.cloud.support.v2.SearchCasesRequest;
import com.google.cloud.support.v2.SearchCasesResponse;
import com.google.cloud.support.v2.UpdateCaseRequest;
import com.google.cloud.support.v2.stub.CaseServiceStub;
import com.google.cloud.support.v2.stub.GrpcCaseServiceStub;
import com.google.cloud.support.v2.stub.HttpJsonCaseServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CaseServiceStubSettings
extends StubSettings<CaseServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetCaseRequest, Case> getCaseSettings;
    private final PagedCallSettings<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse> listCasesSettings;
    private final PagedCallSettings<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse> searchCasesSettings;
    private final UnaryCallSettings<CreateCaseRequest, Case> createCaseSettings;
    private final UnaryCallSettings<UpdateCaseRequest, Case> updateCaseSettings;
    private final UnaryCallSettings<EscalateCaseRequest, Case> escalateCaseSettings;
    private final UnaryCallSettings<CloseCaseRequest, Case> closeCaseSettings;
    private final PagedCallSettings<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsSettings;
    private static final PagedListDescriptor<ListCasesRequest, ListCasesResponse, Case> LIST_CASES_PAGE_STR_DESC = new PagedListDescriptor<ListCasesRequest, ListCasesResponse, Case>(){

        public String emptyToken() {
            return "";
        }

        public ListCasesRequest injectToken(ListCasesRequest payload, String token) {
            return ListCasesRequest.newBuilder((ListCasesRequest)payload).setPageToken(token).build();
        }

        public ListCasesRequest injectPageSize(ListCasesRequest payload, int pageSize) {
            return ListCasesRequest.newBuilder((ListCasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Case> extractResources(ListCasesResponse payload) {
            return payload.getCasesList() == null ? ImmutableList.of() : payload.getCasesList();
        }
    };
    private static final PagedListDescriptor<SearchCasesRequest, SearchCasesResponse, Case> SEARCH_CASES_PAGE_STR_DESC = new PagedListDescriptor<SearchCasesRequest, SearchCasesResponse, Case>(){

        public String emptyToken() {
            return "";
        }

        public SearchCasesRequest injectToken(SearchCasesRequest payload, String token) {
            return SearchCasesRequest.newBuilder((SearchCasesRequest)payload).setPageToken(token).build();
        }

        public SearchCasesRequest injectPageSize(SearchCasesRequest payload, int pageSize) {
            return SearchCasesRequest.newBuilder((SearchCasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchCasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchCasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Case> extractResources(SearchCasesResponse payload) {
            return payload.getCasesList() == null ? ImmutableList.of() : payload.getCasesList();
        }
    };
    private static final PagedListDescriptor<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification> SEARCH_CASE_CLASSIFICATIONS_PAGE_STR_DESC = new PagedListDescriptor<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification>(){

        public String emptyToken() {
            return "";
        }

        public SearchCaseClassificationsRequest injectToken(SearchCaseClassificationsRequest payload, String token) {
            return SearchCaseClassificationsRequest.newBuilder((SearchCaseClassificationsRequest)payload).setPageToken(token).build();
        }

        public SearchCaseClassificationsRequest injectPageSize(SearchCaseClassificationsRequest payload, int pageSize) {
            return SearchCaseClassificationsRequest.newBuilder((SearchCaseClassificationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchCaseClassificationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchCaseClassificationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CaseClassification> extractResources(SearchCaseClassificationsResponse payload) {
            return payload.getCaseClassificationsList() == null ? ImmutableList.of() : payload.getCaseClassificationsList();
        }
    };
    private static final PagedListResponseFactory<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse> LIST_CASES_PAGE_STR_FACT = new PagedListResponseFactory<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse>(){

        public ApiFuture<CaseServiceClient.ListCasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCasesRequest, ListCasesResponse> callable, ListCasesRequest request, ApiCallContext context, ApiFuture<ListCasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CaseServiceClient.ListCasesPagedResponse.createAsync((PageContext<ListCasesRequest, ListCasesResponse, Case>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse> SEARCH_CASES_PAGE_STR_FACT = new PagedListResponseFactory<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse>(){

        public ApiFuture<CaseServiceClient.SearchCasesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchCasesRequest, SearchCasesResponse> callable, SearchCasesRequest request, ApiCallContext context, ApiFuture<SearchCasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_CASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CaseServiceClient.SearchCasesPagedResponse.createAsync((PageContext<SearchCasesRequest, SearchCasesResponse, Case>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse> SEARCH_CASE_CLASSIFICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse>(){

        public ApiFuture<CaseServiceClient.SearchCaseClassificationsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> callable, SearchCaseClassificationsRequest request, ApiCallContext context, ApiFuture<SearchCaseClassificationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_CASE_CLASSIFICATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CaseServiceClient.SearchCaseClassificationsPagedResponse.createAsync((PageContext<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCaseRequest, Case> getCaseSettings() {
        return this.getCaseSettings;
    }

    public PagedCallSettings<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse> listCasesSettings() {
        return this.listCasesSettings;
    }

    public PagedCallSettings<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse> searchCasesSettings() {
        return this.searchCasesSettings;
    }

    public UnaryCallSettings<CreateCaseRequest, Case> createCaseSettings() {
        return this.createCaseSettings;
    }

    public UnaryCallSettings<UpdateCaseRequest, Case> updateCaseSettings() {
        return this.updateCaseSettings;
    }

    public UnaryCallSettings<EscalateCaseRequest, Case> escalateCaseSettings() {
        return this.escalateCaseSettings;
    }

    public UnaryCallSettings<CloseCaseRequest, Case> closeCaseSettings() {
        return this.closeCaseSettings;
    }

    public PagedCallSettings<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsSettings() {
        return this.searchCaseClassificationsSettings;
    }

    public CaseServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCaseServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCaseServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return CaseServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudsupport";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudsupport.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsupport.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CaseServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CaseServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CaseServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCaseSettings = settingsBuilder.getCaseSettings().build();
        this.listCasesSettings = settingsBuilder.listCasesSettings().build();
        this.searchCasesSettings = settingsBuilder.searchCasesSettings().build();
        this.createCaseSettings = settingsBuilder.createCaseSettings().build();
        this.updateCaseSettings = settingsBuilder.updateCaseSettings().build();
        this.escalateCaseSettings = settingsBuilder.escalateCaseSettings().build();
        this.closeCaseSettings = settingsBuilder.closeCaseSettings().build();
        this.searchCaseClassificationsSettings = settingsBuilder.searchCaseClassificationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CaseServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCaseRequest, Case> getCaseSettings;
        private final PagedCallSettings.Builder<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse> listCasesSettings;
        private final PagedCallSettings.Builder<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse> searchCasesSettings;
        private final UnaryCallSettings.Builder<CreateCaseRequest, Case> createCaseSettings;
        private final UnaryCallSettings.Builder<UpdateCaseRequest, Case> updateCaseSettings;
        private final UnaryCallSettings.Builder<EscalateCaseRequest, Case> escalateCaseSettings;
        private final UnaryCallSettings.Builder<CloseCaseRequest, Case> closeCaseSettings;
        private final PagedCallSettings.Builder<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CASES_PAGE_STR_FACT);
            this.searchCasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_CASES_PAGE_STR_FACT);
            this.createCaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.escalateCaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.closeCaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchCaseClassificationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_CASE_CLASSIFICATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCaseSettings, this.listCasesSettings, this.searchCasesSettings, this.createCaseSettings, this.updateCaseSettings, this.escalateCaseSettings, this.closeCaseSettings, this.searchCaseClassificationsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CaseServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCaseSettings = settings.getCaseSettings.toBuilder();
            this.listCasesSettings = settings.listCasesSettings.toBuilder();
            this.searchCasesSettings = settings.searchCasesSettings.toBuilder();
            this.createCaseSettings = settings.createCaseSettings.toBuilder();
            this.updateCaseSettings = settings.updateCaseSettings.toBuilder();
            this.escalateCaseSettings = settings.escalateCaseSettings.toBuilder();
            this.closeCaseSettings = settings.closeCaseSettings.toBuilder();
            this.searchCaseClassificationsSettings = settings.searchCaseClassificationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCaseSettings, this.listCasesSettings, this.searchCasesSettings, this.createCaseSettings, this.updateCaseSettings, this.escalateCaseSettings, this.closeCaseSettings, this.searchCaseClassificationsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CaseServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CaseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CaseServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CaseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchCasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateCaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.escalateCaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.closeCaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.searchCaseClassificationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCaseRequest, Case> getCaseSettings() {
            return this.getCaseSettings;
        }

        public PagedCallSettings.Builder<ListCasesRequest, ListCasesResponse, CaseServiceClient.ListCasesPagedResponse> listCasesSettings() {
            return this.listCasesSettings;
        }

        public PagedCallSettings.Builder<SearchCasesRequest, SearchCasesResponse, CaseServiceClient.SearchCasesPagedResponse> searchCasesSettings() {
            return this.searchCasesSettings;
        }

        public UnaryCallSettings.Builder<CreateCaseRequest, Case> createCaseSettings() {
            return this.createCaseSettings;
        }

        public UnaryCallSettings.Builder<UpdateCaseRequest, Case> updateCaseSettings() {
            return this.updateCaseSettings;
        }

        public UnaryCallSettings.Builder<EscalateCaseRequest, Case> escalateCaseSettings() {
            return this.escalateCaseSettings;
        }

        public UnaryCallSettings.Builder<CloseCaseRequest, Case> closeCaseSettings() {
            return this.closeCaseSettings;
        }

        public PagedCallSettings.Builder<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsSettings() {
            return this.searchCaseClassificationsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return CaseServiceStubSettings.getDefaultEndpoint();
        }

        public CaseServiceStubSettings build() throws IOException {
            return new CaseServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

