/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControl;
import com.google.cloud.cloudsecuritycompliance.v1.ConfigClient;
import com.google.cloud.cloudsecuritycompliance.v1.CreateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.Framework;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksResponse;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStubSettings;
import com.google.cloud.cloudsecuritycompliance.v1.stub.GrpcConfigCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConfigStub
extends ConfigStub {
    private static final MethodDescriptor<ListFrameworksRequest, ListFrameworksResponse> listFrameworksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/ListFrameworks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFrameworksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFrameworksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFrameworkRequest, Framework> getFrameworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/GetFramework").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFrameworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Framework.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateFrameworkRequest, Framework> createFrameworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/CreateFramework").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFrameworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Framework.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFrameworkRequest, Framework> updateFrameworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/UpdateFramework").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFrameworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Framework.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFrameworkRequest, Empty> deleteFrameworkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/DeleteFramework").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFrameworkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/ListCloudControls").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCloudControlsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCloudControlsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetCloudControlRequest, CloudControl> getCloudControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/GetCloudControl").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCloudControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CloudControl.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateCloudControlRequest, CloudControl> createCloudControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/CreateCloudControl").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCloudControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CloudControl.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateCloudControlRequest, CloudControl> updateCloudControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/UpdateCloudControl").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCloudControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CloudControl.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteCloudControlRequest, Empty> deleteCloudControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/DeleteCloudControl").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteCloudControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> listFrameworksCallable;
    private final UnaryCallable<ListFrameworksRequest, ConfigClient.ListFrameworksPagedResponse> listFrameworksPagedCallable;
    private final UnaryCallable<GetFrameworkRequest, Framework> getFrameworkCallable;
    private final UnaryCallable<CreateFrameworkRequest, Framework> createFrameworkCallable;
    private final UnaryCallable<UpdateFrameworkRequest, Framework> updateFrameworkCallable;
    private final UnaryCallable<DeleteFrameworkRequest, Empty> deleteFrameworkCallable;
    private final UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsCallable;
    private final UnaryCallable<ListCloudControlsRequest, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsPagedCallable;
    private final UnaryCallable<GetCloudControlRequest, CloudControl> getCloudControlCallable;
    private final UnaryCallable<CreateCloudControlRequest, CloudControl> createCloudControlCallable;
    private final UnaryCallable<UpdateCloudControlRequest, CloudControl> updateCloudControlCallable;
    private final UnaryCallable<DeleteCloudControlRequest, Empty> deleteCloudControlCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConfigStub create(ConfigStubSettings settings) throws IOException {
        return new GrpcConfigStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConfigStub create(ClientContext clientContext) throws IOException {
        return new GrpcConfigStub(ConfigStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConfigStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConfigStub(ConfigStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConfigStub(ConfigStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConfigCallableFactory());
    }

    protected GrpcConfigStub(ConfigStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listFrameworksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFrameworksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getFrameworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFrameworkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createFrameworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFrameworkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFrameworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFrameworkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("framework.name", String.valueOf(request.getFramework().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFrameworkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFrameworkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listCloudControlsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCloudControlsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCloudControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCloudControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createCloudControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCloudControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCloudControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCloudControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cloud_control.name", String.valueOf(request.getCloudControl().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteCloudControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteCloudControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listFrameworksCallable = callableFactory.createUnaryCallable(listFrameworksTransportSettings, settings.listFrameworksSettings(), clientContext);
        this.listFrameworksPagedCallable = callableFactory.createPagedCallable(listFrameworksTransportSettings, settings.listFrameworksSettings(), clientContext);
        this.getFrameworkCallable = callableFactory.createUnaryCallable(getFrameworkTransportSettings, settings.getFrameworkSettings(), clientContext);
        this.createFrameworkCallable = callableFactory.createUnaryCallable(createFrameworkTransportSettings, settings.createFrameworkSettings(), clientContext);
        this.updateFrameworkCallable = callableFactory.createUnaryCallable(updateFrameworkTransportSettings, settings.updateFrameworkSettings(), clientContext);
        this.deleteFrameworkCallable = callableFactory.createUnaryCallable(deleteFrameworkTransportSettings, settings.deleteFrameworkSettings(), clientContext);
        this.listCloudControlsCallable = callableFactory.createUnaryCallable(listCloudControlsTransportSettings, settings.listCloudControlsSettings(), clientContext);
        this.listCloudControlsPagedCallable = callableFactory.createPagedCallable(listCloudControlsTransportSettings, settings.listCloudControlsSettings(), clientContext);
        this.getCloudControlCallable = callableFactory.createUnaryCallable(getCloudControlTransportSettings, settings.getCloudControlSettings(), clientContext);
        this.createCloudControlCallable = callableFactory.createUnaryCallable(createCloudControlTransportSettings, settings.createCloudControlSettings(), clientContext);
        this.updateCloudControlCallable = callableFactory.createUnaryCallable(updateCloudControlTransportSettings, settings.updateCloudControlSettings(), clientContext);
        this.deleteCloudControlCallable = callableFactory.createUnaryCallable(deleteCloudControlTransportSettings, settings.deleteCloudControlSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> listFrameworksCallable() {
        return this.listFrameworksCallable;
    }

    @Override
    public UnaryCallable<ListFrameworksRequest, ConfigClient.ListFrameworksPagedResponse> listFrameworksPagedCallable() {
        return this.listFrameworksPagedCallable;
    }

    @Override
    public UnaryCallable<GetFrameworkRequest, Framework> getFrameworkCallable() {
        return this.getFrameworkCallable;
    }

    @Override
    public UnaryCallable<CreateFrameworkRequest, Framework> createFrameworkCallable() {
        return this.createFrameworkCallable;
    }

    @Override
    public UnaryCallable<UpdateFrameworkRequest, Framework> updateFrameworkCallable() {
        return this.updateFrameworkCallable;
    }

    @Override
    public UnaryCallable<DeleteFrameworkRequest, Empty> deleteFrameworkCallable() {
        return this.deleteFrameworkCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsCallable() {
        return this.listCloudControlsCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlsRequest, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsPagedCallable() {
        return this.listCloudControlsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudControlRequest, CloudControl> getCloudControlCallable() {
        return this.getCloudControlCallable;
    }

    @Override
    public UnaryCallable<CreateCloudControlRequest, CloudControl> createCloudControlCallable() {
        return this.createCloudControlCallable;
    }

    @Override
    public UnaryCallable<UpdateCloudControlRequest, CloudControl> updateCloudControlCallable() {
        return this.updateCloudControlCallable;
    }

    @Override
    public UnaryCallable<DeleteCloudControlRequest, Empty> deleteCloudControlCallable() {
        return this.deleteCloudControlCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

