/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControl;
import com.google.cloud.cloudsecuritycompliance.v1.ConfigClient;
import com.google.cloud.cloudsecuritycompliance.v1.CreateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.Framework;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksResponse;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.GrpcConfigStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.HttpJsonConfigStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ConfigStubSettings
extends StubSettings<ConfigStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse> listFrameworksSettings;
    private final UnaryCallSettings<GetFrameworkRequest, Framework> getFrameworkSettings;
    private final UnaryCallSettings<CreateFrameworkRequest, Framework> createFrameworkSettings;
    private final UnaryCallSettings<UpdateFrameworkRequest, Framework> updateFrameworkSettings;
    private final UnaryCallSettings<DeleteFrameworkRequest, Empty> deleteFrameworkSettings;
    private final PagedCallSettings<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsSettings;
    private final UnaryCallSettings<GetCloudControlRequest, CloudControl> getCloudControlSettings;
    private final UnaryCallSettings<CreateCloudControlRequest, CloudControl> createCloudControlSettings;
    private final UnaryCallSettings<UpdateCloudControlRequest, CloudControl> updateCloudControlSettings;
    private final UnaryCallSettings<DeleteCloudControlRequest, Empty> deleteCloudControlSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListFrameworksRequest, ListFrameworksResponse, Framework> LIST_FRAMEWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListFrameworksRequest, ListFrameworksResponse, Framework>(){

        public String emptyToken() {
            return "";
        }

        public ListFrameworksRequest injectToken(ListFrameworksRequest payload, String token) {
            return ListFrameworksRequest.newBuilder((ListFrameworksRequest)payload).setPageToken(token).build();
        }

        public ListFrameworksRequest injectPageSize(ListFrameworksRequest payload, int pageSize) {
            return ListFrameworksRequest.newBuilder((ListFrameworksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFrameworksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFrameworksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Framework> extractResources(ListFrameworksResponse payload) {
            return payload.getFrameworksList();
        }
    };
    private static final PagedListDescriptor<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl> LIST_CLOUD_CONTROLS_PAGE_STR_DESC = new PagedListDescriptor<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl>(){

        public String emptyToken() {
            return "";
        }

        public ListCloudControlsRequest injectToken(ListCloudControlsRequest payload, String token) {
            return ListCloudControlsRequest.newBuilder((ListCloudControlsRequest)payload).setPageToken(token).build();
        }

        public ListCloudControlsRequest injectPageSize(ListCloudControlsRequest payload, int pageSize) {
            return ListCloudControlsRequest.newBuilder((ListCloudControlsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCloudControlsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCloudControlsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudControl> extractResources(ListCloudControlsResponse payload) {
            return payload.getCloudControlsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse> LIST_FRAMEWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse>(){

        public ApiFuture<ConfigClient.ListFrameworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> callable, ListFrameworksRequest request, ApiCallContext context, ApiFuture<ListFrameworksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FRAMEWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListFrameworksPagedResponse.createAsync((PageContext<ListFrameworksRequest, ListFrameworksResponse, Framework>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse> LIST_CLOUD_CONTROLS_PAGE_STR_FACT = new PagedListResponseFactory<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse>(){

        public ApiFuture<ConfigClient.ListCloudControlsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> callable, ListCloudControlsRequest request, ApiCallContext context, ApiFuture<ListCloudControlsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLOUD_CONTROLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListCloudControlsPagedResponse.createAsync((PageContext<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConfigClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse> listFrameworksSettings() {
        return this.listFrameworksSettings;
    }

    public UnaryCallSettings<GetFrameworkRequest, Framework> getFrameworkSettings() {
        return this.getFrameworkSettings;
    }

    public UnaryCallSettings<CreateFrameworkRequest, Framework> createFrameworkSettings() {
        return this.createFrameworkSettings;
    }

    public UnaryCallSettings<UpdateFrameworkRequest, Framework> updateFrameworkSettings() {
        return this.updateFrameworkSettings;
    }

    public UnaryCallSettings<DeleteFrameworkRequest, Empty> deleteFrameworkSettings() {
        return this.deleteFrameworkSettings;
    }

    public PagedCallSettings<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsSettings() {
        return this.listCloudControlsSettings;
    }

    public UnaryCallSettings<GetCloudControlRequest, CloudControl> getCloudControlSettings() {
        return this.getCloudControlSettings;
    }

    public UnaryCallSettings<CreateCloudControlRequest, CloudControl> createCloudControlSettings() {
        return this.createCloudControlSettings;
    }

    public UnaryCallSettings<UpdateCloudControlRequest, CloudControl> updateCloudControlSettings() {
        return this.updateCloudControlSettings;
    }

    public UnaryCallSettings<DeleteCloudControlRequest, Empty> deleteCloudControlSettings() {
        return this.deleteCloudControlSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConfigStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConfigStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConfigStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudsecuritycompliance";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudsecuritycompliance.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsecuritycompliance.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConfigStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConfigStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConfigStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listFrameworksSettings = settingsBuilder.listFrameworksSettings().build();
        this.getFrameworkSettings = settingsBuilder.getFrameworkSettings().build();
        this.createFrameworkSettings = settingsBuilder.createFrameworkSettings().build();
        this.updateFrameworkSettings = settingsBuilder.updateFrameworkSettings().build();
        this.deleteFrameworkSettings = settingsBuilder.deleteFrameworkSettings().build();
        this.listCloudControlsSettings = settingsBuilder.listCloudControlsSettings().build();
        this.getCloudControlSettings = settingsBuilder.getCloudControlSettings().build();
        this.createCloudControlSettings = settingsBuilder.createCloudControlSettings().build();
        this.updateCloudControlSettings = settingsBuilder.updateCloudControlSettings().build();
        this.deleteCloudControlSettings = settingsBuilder.deleteCloudControlSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConfigStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse> listFrameworksSettings;
        private final UnaryCallSettings.Builder<GetFrameworkRequest, Framework> getFrameworkSettings;
        private final UnaryCallSettings.Builder<CreateFrameworkRequest, Framework> createFrameworkSettings;
        private final UnaryCallSettings.Builder<UpdateFrameworkRequest, Framework> updateFrameworkSettings;
        private final UnaryCallSettings.Builder<DeleteFrameworkRequest, Empty> deleteFrameworkSettings;
        private final PagedCallSettings.Builder<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsSettings;
        private final UnaryCallSettings.Builder<GetCloudControlRequest, CloudControl> getCloudControlSettings;
        private final UnaryCallSettings.Builder<CreateCloudControlRequest, CloudControl> createCloudControlSettings;
        private final UnaryCallSettings.Builder<UpdateCloudControlRequest, CloudControl> updateCloudControlSettings;
        private final UnaryCallSettings.Builder<DeleteCloudControlRequest, Empty> deleteCloudControlSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listFrameworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FRAMEWORKS_PAGE_STR_FACT);
            this.getFrameworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFrameworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFrameworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFrameworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCloudControlsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLOUD_CONTROLS_PAGE_STR_FACT);
            this.getCloudControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCloudControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCloudControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCloudControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFrameworksSettings, this.getFrameworkSettings, this.createFrameworkSettings, this.updateFrameworkSettings, this.deleteFrameworkSettings, this.listCloudControlsSettings, this.getCloudControlSettings, this.createCloudControlSettings, this.updateCloudControlSettings, this.deleteCloudControlSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(ConfigStubSettings settings) {
            super((StubSettings)settings);
            this.listFrameworksSettings = settings.listFrameworksSettings.toBuilder();
            this.getFrameworkSettings = settings.getFrameworkSettings.toBuilder();
            this.createFrameworkSettings = settings.createFrameworkSettings.toBuilder();
            this.updateFrameworkSettings = settings.updateFrameworkSettings.toBuilder();
            this.deleteFrameworkSettings = settings.deleteFrameworkSettings.toBuilder();
            this.listCloudControlsSettings = settings.listCloudControlsSettings.toBuilder();
            this.getCloudControlSettings = settings.getCloudControlSettings.toBuilder();
            this.createCloudControlSettings = settings.createCloudControlSettings.toBuilder();
            this.updateCloudControlSettings = settings.updateCloudControlSettings.toBuilder();
            this.deleteCloudControlSettings = settings.deleteCloudControlSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listFrameworksSettings, this.getFrameworkSettings, this.createFrameworkSettings, this.updateFrameworkSettings, this.deleteFrameworkSettings, this.listCloudControlsSettings, this.getCloudControlSettings, this.createCloudControlSettings, this.updateCloudControlSettings, this.deleteCloudControlSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConfigStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConfigStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConfigStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConfigStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConfigStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConfigStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listFrameworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFrameworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createFrameworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateFrameworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteFrameworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listCloudControlsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCloudControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCloudControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateCloudControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteCloudControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListFrameworksRequest, ListFrameworksResponse, ConfigClient.ListFrameworksPagedResponse> listFrameworksSettings() {
            return this.listFrameworksSettings;
        }

        public UnaryCallSettings.Builder<GetFrameworkRequest, Framework> getFrameworkSettings() {
            return this.getFrameworkSettings;
        }

        public UnaryCallSettings.Builder<CreateFrameworkRequest, Framework> createFrameworkSettings() {
            return this.createFrameworkSettings;
        }

        public UnaryCallSettings.Builder<UpdateFrameworkRequest, Framework> updateFrameworkSettings() {
            return this.updateFrameworkSettings;
        }

        public UnaryCallSettings.Builder<DeleteFrameworkRequest, Empty> deleteFrameworkSettings() {
            return this.deleteFrameworkSettings;
        }

        public PagedCallSettings.Builder<ListCloudControlsRequest, ListCloudControlsResponse, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsSettings() {
            return this.listCloudControlsSettings;
        }

        public UnaryCallSettings.Builder<GetCloudControlRequest, CloudControl> getCloudControlSettings() {
            return this.getCloudControlSettings;
        }

        public UnaryCallSettings.Builder<CreateCloudControlRequest, CloudControl> createCloudControlSettings() {
            return this.createCloudControlSettings;
        }

        public UnaryCallSettings.Builder<UpdateCloudControlRequest, CloudControl> updateCloudControlSettings() {
            return this.updateCloudControlSettings;
        }

        public UnaryCallSettings.Builder<DeleteCloudControlRequest, Empty> deleteCloudControlSettings() {
            return this.deleteCloudControlSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ConfigStubSettings build() throws IOException {
            return new ConfigStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

