/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.AggregateFrameworkComplianceReportRequest;
import com.google.cloud.cloudsecuritycompliance.v1.AggregateFrameworkComplianceReportResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ControlComplianceSummary;
import com.google.cloud.cloudsecuritycompliance.v1.FetchFrameworkComplianceReportRequest;
import com.google.cloud.cloudsecuritycompliance.v1.FindingSummary;
import com.google.cloud.cloudsecuritycompliance.v1.FolderLocationName;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkComplianceReport;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkComplianceReportName;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkComplianceSummary;
import com.google.cloud.cloudsecuritycompliance.v1.ListControlComplianceSummariesRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListControlComplianceSummariesResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFindingSummariesRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFindingSummariesResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkComplianceSummariesRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkComplianceSummariesResponse;
import com.google.cloud.cloudsecuritycompliance.v1.LocationName;
import com.google.cloud.cloudsecuritycompliance.v1.MonitoringSettings;
import com.google.cloud.cloudsecuritycompliance.v1.OrganizationLocationName;
import com.google.cloud.cloudsecuritycompliance.v1.stub.MonitoringStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.MonitoringStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MonitoringClient
implements BackgroundResource {
    private final MonitoringSettings settings;
    private final MonitoringStub stub;

    public static final MonitoringClient create() throws IOException {
        return MonitoringClient.create(MonitoringSettings.newBuilder().build());
    }

    public static final MonitoringClient create(MonitoringSettings settings) throws IOException {
        return new MonitoringClient(settings);
    }

    public static final MonitoringClient create(MonitoringStub stub) {
        return new MonitoringClient(stub);
    }

    protected MonitoringClient(MonitoringSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MonitoringStubSettings)settings.getStubSettings()).createStub();
    }

    protected MonitoringClient(MonitoringStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MonitoringSettings getSettings() {
        return this.settings;
    }

    public MonitoringStub getStub() {
        return this.stub;
    }

    public final ListFrameworkComplianceSummariesPagedResponse listFrameworkComplianceSummaries(FolderLocationName parent) {
        ListFrameworkComplianceSummariesRequest request = ListFrameworkComplianceSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkComplianceSummaries(request);
    }

    public final ListFrameworkComplianceSummariesPagedResponse listFrameworkComplianceSummaries(LocationName parent) {
        ListFrameworkComplianceSummariesRequest request = ListFrameworkComplianceSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkComplianceSummaries(request);
    }

    public final ListFrameworkComplianceSummariesPagedResponse listFrameworkComplianceSummaries(OrganizationLocationName parent) {
        ListFrameworkComplianceSummariesRequest request = ListFrameworkComplianceSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkComplianceSummaries(request);
    }

    public final ListFrameworkComplianceSummariesPagedResponse listFrameworkComplianceSummaries(String parent) {
        ListFrameworkComplianceSummariesRequest request = ListFrameworkComplianceSummariesRequest.newBuilder().setParent(parent).build();
        return this.listFrameworkComplianceSummaries(request);
    }

    public final ListFrameworkComplianceSummariesPagedResponse listFrameworkComplianceSummaries(ListFrameworkComplianceSummariesRequest request) {
        return (ListFrameworkComplianceSummariesPagedResponse)((Object)this.listFrameworkComplianceSummariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesPagedResponse> listFrameworkComplianceSummariesPagedCallable() {
        return this.stub.listFrameworkComplianceSummariesPagedCallable();
    }

    public final UnaryCallable<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse> listFrameworkComplianceSummariesCallable() {
        return this.stub.listFrameworkComplianceSummariesCallable();
    }

    public final ListFindingSummariesPagedResponse listFindingSummaries(FolderLocationName parent) {
        ListFindingSummariesRequest request = ListFindingSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFindingSummaries(request);
    }

    public final ListFindingSummariesPagedResponse listFindingSummaries(LocationName parent) {
        ListFindingSummariesRequest request = ListFindingSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFindingSummaries(request);
    }

    public final ListFindingSummariesPagedResponse listFindingSummaries(OrganizationLocationName parent) {
        ListFindingSummariesRequest request = ListFindingSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFindingSummaries(request);
    }

    public final ListFindingSummariesPagedResponse listFindingSummaries(String parent) {
        ListFindingSummariesRequest request = ListFindingSummariesRequest.newBuilder().setParent(parent).build();
        return this.listFindingSummaries(request);
    }

    public final ListFindingSummariesPagedResponse listFindingSummaries(ListFindingSummariesRequest request) {
        return (ListFindingSummariesPagedResponse)((Object)this.listFindingSummariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFindingSummariesRequest, ListFindingSummariesPagedResponse> listFindingSummariesPagedCallable() {
        return this.stub.listFindingSummariesPagedCallable();
    }

    public final UnaryCallable<ListFindingSummariesRequest, ListFindingSummariesResponse> listFindingSummariesCallable() {
        return this.stub.listFindingSummariesCallable();
    }

    public final FrameworkComplianceReport fetchFrameworkComplianceReport(FrameworkComplianceReportName name) {
        FetchFrameworkComplianceReportRequest request = FetchFrameworkComplianceReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchFrameworkComplianceReport(request);
    }

    public final FrameworkComplianceReport fetchFrameworkComplianceReport(String name) {
        FetchFrameworkComplianceReportRequest request = FetchFrameworkComplianceReportRequest.newBuilder().setName(name).build();
        return this.fetchFrameworkComplianceReport(request);
    }

    public final FrameworkComplianceReport fetchFrameworkComplianceReport(FetchFrameworkComplianceReportRequest request) {
        return (FrameworkComplianceReport)this.fetchFrameworkComplianceReportCallable().call((Object)request);
    }

    public final UnaryCallable<FetchFrameworkComplianceReportRequest, FrameworkComplianceReport> fetchFrameworkComplianceReportCallable() {
        return this.stub.fetchFrameworkComplianceReportCallable();
    }

    public final ListControlComplianceSummariesPagedResponse listControlComplianceSummaries(FrameworkComplianceReportName parent) {
        ListControlComplianceSummariesRequest request = ListControlComplianceSummariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listControlComplianceSummaries(request);
    }

    public final ListControlComplianceSummariesPagedResponse listControlComplianceSummaries(String parent) {
        ListControlComplianceSummariesRequest request = ListControlComplianceSummariesRequest.newBuilder().setParent(parent).build();
        return this.listControlComplianceSummaries(request);
    }

    public final ListControlComplianceSummariesPagedResponse listControlComplianceSummaries(ListControlComplianceSummariesRequest request) {
        return (ListControlComplianceSummariesPagedResponse)((Object)this.listControlComplianceSummariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListControlComplianceSummariesRequest, ListControlComplianceSummariesPagedResponse> listControlComplianceSummariesPagedCallable() {
        return this.stub.listControlComplianceSummariesPagedCallable();
    }

    public final UnaryCallable<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse> listControlComplianceSummariesCallable() {
        return this.stub.listControlComplianceSummariesCallable();
    }

    public final AggregateFrameworkComplianceReportResponse aggregateFrameworkComplianceReport(FrameworkComplianceReportName name) {
        AggregateFrameworkComplianceReportRequest request = AggregateFrameworkComplianceReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.aggregateFrameworkComplianceReport(request);
    }

    public final AggregateFrameworkComplianceReportResponse aggregateFrameworkComplianceReport(String name) {
        AggregateFrameworkComplianceReportRequest request = AggregateFrameworkComplianceReportRequest.newBuilder().setName(name).build();
        return this.aggregateFrameworkComplianceReport(request);
    }

    public final AggregateFrameworkComplianceReportResponse aggregateFrameworkComplianceReport(AggregateFrameworkComplianceReportRequest request) {
        return (AggregateFrameworkComplianceReportResponse)this.aggregateFrameworkComplianceReportCallable().call((Object)request);
    }

    public final UnaryCallable<AggregateFrameworkComplianceReportRequest, AggregateFrameworkComplianceReportResponse> aggregateFrameworkComplianceReportCallable() {
        return this.stub.aggregateFrameworkComplianceReportCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListControlComplianceSummariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary, ListControlComplianceSummariesPage, ListControlComplianceSummariesFixedSizeCollection> {
        private ListControlComplianceSummariesFixedSizeCollection(List<ListControlComplianceSummariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListControlComplianceSummariesFixedSizeCollection createEmptyCollection() {
            return new ListControlComplianceSummariesFixedSizeCollection(null, 0);
        }

        protected ListControlComplianceSummariesFixedSizeCollection createCollection(List<ListControlComplianceSummariesPage> pages, int collectionSize) {
            return new ListControlComplianceSummariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListControlComplianceSummariesPage
    extends AbstractPage<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary, ListControlComplianceSummariesPage> {
        private ListControlComplianceSummariesPage(PageContext<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary> context, ListControlComplianceSummariesResponse response) {
            super(context, (Object)response);
        }

        private static ListControlComplianceSummariesPage createEmptyPage() {
            return new ListControlComplianceSummariesPage(null, null);
        }

        protected ListControlComplianceSummariesPage createPage(PageContext<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary> context, ListControlComplianceSummariesResponse response) {
            return new ListControlComplianceSummariesPage(context, response);
        }

        public ApiFuture<ListControlComplianceSummariesPage> createPageAsync(PageContext<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary> context, ApiFuture<ListControlComplianceSummariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListControlComplianceSummariesPagedResponse
    extends AbstractPagedListResponse<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary, ListControlComplianceSummariesPage, ListControlComplianceSummariesFixedSizeCollection> {
        public static ApiFuture<ListControlComplianceSummariesPagedResponse> createAsync(PageContext<ListControlComplianceSummariesRequest, ListControlComplianceSummariesResponse, ControlComplianceSummary> context, ApiFuture<ListControlComplianceSummariesResponse> futureResponse) {
            ApiFuture<ListControlComplianceSummariesPage> futurePage = ListControlComplianceSummariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListControlComplianceSummariesPagedResponse((ListControlComplianceSummariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListControlComplianceSummariesPagedResponse(ListControlComplianceSummariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListControlComplianceSummariesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFindingSummariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary, ListFindingSummariesPage, ListFindingSummariesFixedSizeCollection> {
        private ListFindingSummariesFixedSizeCollection(List<ListFindingSummariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFindingSummariesFixedSizeCollection createEmptyCollection() {
            return new ListFindingSummariesFixedSizeCollection(null, 0);
        }

        protected ListFindingSummariesFixedSizeCollection createCollection(List<ListFindingSummariesPage> pages, int collectionSize) {
            return new ListFindingSummariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFindingSummariesPage
    extends AbstractPage<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary, ListFindingSummariesPage> {
        private ListFindingSummariesPage(PageContext<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary> context, ListFindingSummariesResponse response) {
            super(context, (Object)response);
        }

        private static ListFindingSummariesPage createEmptyPage() {
            return new ListFindingSummariesPage(null, null);
        }

        protected ListFindingSummariesPage createPage(PageContext<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary> context, ListFindingSummariesResponse response) {
            return new ListFindingSummariesPage(context, response);
        }

        public ApiFuture<ListFindingSummariesPage> createPageAsync(PageContext<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary> context, ApiFuture<ListFindingSummariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFindingSummariesPagedResponse
    extends AbstractPagedListResponse<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary, ListFindingSummariesPage, ListFindingSummariesFixedSizeCollection> {
        public static ApiFuture<ListFindingSummariesPagedResponse> createAsync(PageContext<ListFindingSummariesRequest, ListFindingSummariesResponse, FindingSummary> context, ApiFuture<ListFindingSummariesResponse> futureResponse) {
            ApiFuture<ListFindingSummariesPage> futurePage = ListFindingSummariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFindingSummariesPagedResponse((ListFindingSummariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFindingSummariesPagedResponse(ListFindingSummariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFindingSummariesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFrameworkComplianceSummariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary, ListFrameworkComplianceSummariesPage, ListFrameworkComplianceSummariesFixedSizeCollection> {
        private ListFrameworkComplianceSummariesFixedSizeCollection(List<ListFrameworkComplianceSummariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFrameworkComplianceSummariesFixedSizeCollection createEmptyCollection() {
            return new ListFrameworkComplianceSummariesFixedSizeCollection(null, 0);
        }

        protected ListFrameworkComplianceSummariesFixedSizeCollection createCollection(List<ListFrameworkComplianceSummariesPage> pages, int collectionSize) {
            return new ListFrameworkComplianceSummariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFrameworkComplianceSummariesPage
    extends AbstractPage<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary, ListFrameworkComplianceSummariesPage> {
        private ListFrameworkComplianceSummariesPage(PageContext<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary> context, ListFrameworkComplianceSummariesResponse response) {
            super(context, (Object)response);
        }

        private static ListFrameworkComplianceSummariesPage createEmptyPage() {
            return new ListFrameworkComplianceSummariesPage(null, null);
        }

        protected ListFrameworkComplianceSummariesPage createPage(PageContext<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary> context, ListFrameworkComplianceSummariesResponse response) {
            return new ListFrameworkComplianceSummariesPage(context, response);
        }

        public ApiFuture<ListFrameworkComplianceSummariesPage> createPageAsync(PageContext<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary> context, ApiFuture<ListFrameworkComplianceSummariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFrameworkComplianceSummariesPagedResponse
    extends AbstractPagedListResponse<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary, ListFrameworkComplianceSummariesPage, ListFrameworkComplianceSummariesFixedSizeCollection> {
        public static ApiFuture<ListFrameworkComplianceSummariesPagedResponse> createAsync(PageContext<ListFrameworkComplianceSummariesRequest, ListFrameworkComplianceSummariesResponse, FrameworkComplianceSummary> context, ApiFuture<ListFrameworkComplianceSummariesResponse> futureResponse) {
            ApiFuture<ListFrameworkComplianceSummariesPage> futurePage = ListFrameworkComplianceSummariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFrameworkComplianceSummariesPagedResponse((ListFrameworkComplianceSummariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFrameworkComplianceSummariesPagedResponse(ListFrameworkComplianceSummariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFrameworkComplianceSummariesFixedSizeCollection.createEmptyCollection());
        }
    }
}

