/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerMonitoringClient;
import com.google.cloud.cloudcontrolspartner.v1.GetViolationRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListViolationsRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListViolationsResponse;
import com.google.cloud.cloudcontrolspartner.v1.Violation;
import com.google.cloud.cloudcontrolspartner.v1.stub.CloudControlsPartnerMonitoringStub;
import com.google.cloud.cloudcontrolspartner.v1.stub.GrpcCloudControlsPartnerMonitoringStub;
import com.google.cloud.cloudcontrolspartner.v1.stub.HttpJsonCloudControlsPartnerMonitoringStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudControlsPartnerMonitoringStubSettings
extends StubSettings<CloudControlsPartnerMonitoringStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> listViolationsSettings;
    private final UnaryCallSettings<GetViolationRequest, Violation> getViolationSettings;
    private static final PagedListDescriptor<ListViolationsRequest, ListViolationsResponse, Violation> LIST_VIOLATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListViolationsRequest, ListViolationsResponse, Violation>(){

        public String emptyToken() {
            return "";
        }

        public ListViolationsRequest injectToken(ListViolationsRequest payload, String token) {
            return ListViolationsRequest.newBuilder((ListViolationsRequest)payload).setPageToken(token).build();
        }

        public ListViolationsRequest injectPageSize(ListViolationsRequest payload, int pageSize) {
            return ListViolationsRequest.newBuilder((ListViolationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListViolationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListViolationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Violation> extractResources(ListViolationsResponse payload) {
            return payload.getViolationsList() == null ? ImmutableList.of() : payload.getViolationsList();
        }
    };
    private static final PagedListResponseFactory<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> LIST_VIOLATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse>(){

        public ApiFuture<CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListViolationsRequest, ListViolationsResponse> callable, ListViolationsRequest request, ApiCallContext context, ApiFuture<ListViolationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VIOLATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse.createAsync((PageContext<ListViolationsRequest, ListViolationsResponse, Violation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> listViolationsSettings() {
        return this.listViolationsSettings;
    }

    public UnaryCallSettings<GetViolationRequest, Violation> getViolationSettings() {
        return this.getViolationSettings;
    }

    public CloudControlsPartnerMonitoringStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudControlsPartnerMonitoringStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudControlsPartnerMonitoringStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudcontrolspartner";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudcontrolspartner.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudcontrolspartner.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudControlsPartnerMonitoringStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudControlsPartnerMonitoringStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudControlsPartnerMonitoringStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudControlsPartnerMonitoringStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudControlsPartnerMonitoringStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listViolationsSettings = settingsBuilder.listViolationsSettings().build();
        this.getViolationSettings = settingsBuilder.getViolationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudControlsPartnerMonitoringStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> listViolationsSettings;
        private final UnaryCallSettings.Builder<GetViolationRequest, Violation> getViolationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listViolationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VIOLATIONS_PAGE_STR_FACT);
            this.getViolationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listViolationsSettings, this.getViolationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudControlsPartnerMonitoringStubSettings settings) {
            super((StubSettings)settings);
            this.listViolationsSettings = settings.listViolationsSettings.toBuilder();
            this.getViolationSettings = settings.getViolationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listViolationsSettings, this.getViolationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudControlsPartnerMonitoringStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudControlsPartnerMonitoringStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudControlsPartnerMonitoringStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudControlsPartnerMonitoringStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudControlsPartnerMonitoringStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudControlsPartnerMonitoringStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudControlsPartnerMonitoringStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudControlsPartnerMonitoringStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listViolationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getViolationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListViolationsRequest, ListViolationsResponse, CloudControlsPartnerMonitoringClient.ListViolationsPagedResponse> listViolationsSettings() {
            return this.listViolationsSettings;
        }

        public UnaryCallSettings.Builder<GetViolationRequest, Violation> getViolationSettings() {
            return this.getViolationSettings;
        }

        public CloudControlsPartnerMonitoringStubSettings build() throws IOException {
            return new CloudControlsPartnerMonitoringStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

