/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.CancelOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementServiceSettings;
import com.google.cloud.commerce.consumer.procurement.v1.GetOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.ModifyOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.Order;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConsumerProcurementServiceClient
implements BackgroundResource {
    private final ConsumerProcurementServiceSettings settings;
    private final ConsumerProcurementServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConsumerProcurementServiceClient create() throws IOException {
        return ConsumerProcurementServiceClient.create(ConsumerProcurementServiceSettings.newBuilder().build());
    }

    public static final ConsumerProcurementServiceClient create(ConsumerProcurementServiceSettings settings) throws IOException {
        return new ConsumerProcurementServiceClient(settings);
    }

    public static final ConsumerProcurementServiceClient create(ConsumerProcurementServiceStub stub) {
        return new ConsumerProcurementServiceClient(stub);
    }

    protected ConsumerProcurementServiceClient(ConsumerProcurementServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConsumerProcurementServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConsumerProcurementServiceClient(ConsumerProcurementServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConsumerProcurementServiceSettings getSettings() {
        return this.settings;
    }

    public ConsumerProcurementServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Order, PlaceOrderMetadata> placeOrderAsync(PlaceOrderRequest request) {
        return this.placeOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationCallable() {
        return this.stub.placeOrderOperationCallable();
    }

    public final UnaryCallable<PlaceOrderRequest, Operation> placeOrderCallable() {
        return this.stub.placeOrderCallable();
    }

    public final Order getOrder(String name) {
        GetOrderRequest request = GetOrderRequest.newBuilder().setName(name).build();
        return this.getOrder(request);
    }

    public final Order getOrder(GetOrderRequest request) {
        return (Order)this.getOrderCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrderRequest, Order> getOrderCallable() {
        return this.stub.getOrderCallable();
    }

    public final ListOrdersPagedResponse listOrders(String parent) {
        ListOrdersRequest request = ListOrdersRequest.newBuilder().setParent(parent).build();
        return this.listOrders(request);
    }

    public final ListOrdersPagedResponse listOrders(ListOrdersRequest request) {
        return (ListOrdersPagedResponse)((Object)this.listOrdersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersPagedResponse> listOrdersPagedCallable() {
        return this.stub.listOrdersPagedCallable();
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable() {
        return this.stub.listOrdersCallable();
    }

    public final OperationFuture<Order, ModifyOrderMetadata> modifyOrderAsync(ModifyOrderRequest request) {
        return this.modifyOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ModifyOrderRequest, Order, ModifyOrderMetadata> modifyOrderOperationCallable() {
        return this.stub.modifyOrderOperationCallable();
    }

    public final UnaryCallable<ModifyOrderRequest, Operation> modifyOrderCallable() {
        return this.stub.modifyOrderCallable();
    }

    public final OperationFuture<Order, CancelOrderMetadata> cancelOrderAsync(CancelOrderRequest request) {
        return this.cancelOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelOrderRequest, Order, CancelOrderMetadata> cancelOrderOperationCallable() {
        return this.stub.cancelOrderOperationCallable();
    }

    public final UnaryCallable<CancelOrderRequest, Operation> cancelOrderCallable() {
        return this.stub.cancelOrderCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListOrdersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        private ListOrdersFixedSizeCollection(List<ListOrdersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrdersFixedSizeCollection createEmptyCollection() {
            return new ListOrdersFixedSizeCollection(null, 0);
        }

        protected ListOrdersFixedSizeCollection createCollection(List<ListOrdersPage> pages, int collectionSize) {
            return new ListOrdersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrdersPage
    extends AbstractPage<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage> {
        private ListOrdersPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            super(context, (Object)response);
        }

        private static ListOrdersPage createEmptyPage() {
            return new ListOrdersPage(null, null);
        }

        protected ListOrdersPage createPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            return new ListOrdersPage(context, response);
        }

        public ApiFuture<ListOrdersPage> createPageAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrdersPagedResponse
    extends AbstractPagedListResponse<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        public static ApiFuture<ListOrdersPagedResponse> createAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            ApiFuture<ListOrdersPage> futurePage = ListOrdersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrdersPagedResponse((ListOrdersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrdersPagedResponse(ListOrdersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrdersFixedSizeCollection.createEmptyCollection());
        }
    }
}

