/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.AssignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.AssignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.GetLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.LicenseManagementServiceSettings;
import com.google.cloud.commerce.consumer.procurement.v1.LicensePool;
import com.google.cloud.commerce.consumer.procurement.v1.LicensedUser;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.LicenseManagementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.LicenseManagementServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LicenseManagementServiceClient
implements BackgroundResource {
    private final LicenseManagementServiceSettings settings;
    private final LicenseManagementServiceStub stub;

    public static final LicenseManagementServiceClient create() throws IOException {
        return LicenseManagementServiceClient.create(LicenseManagementServiceSettings.newBuilder().build());
    }

    public static final LicenseManagementServiceClient create(LicenseManagementServiceSettings settings) throws IOException {
        return new LicenseManagementServiceClient(settings);
    }

    public static final LicenseManagementServiceClient create(LicenseManagementServiceStub stub) {
        return new LicenseManagementServiceClient(stub);
    }

    protected LicenseManagementServiceClient(LicenseManagementServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicenseManagementServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LicenseManagementServiceClient(LicenseManagementServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LicenseManagementServiceSettings getSettings() {
        return this.settings;
    }

    public LicenseManagementServiceStub getStub() {
        return this.stub;
    }

    public final LicensePool getLicensePool(String name) {
        GetLicensePoolRequest request = GetLicensePoolRequest.newBuilder().setName(name).build();
        return this.getLicensePool(request);
    }

    public final LicensePool getLicensePool(GetLicensePoolRequest request) {
        return (LicensePool)this.getLicensePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetLicensePoolRequest, LicensePool> getLicensePoolCallable() {
        return this.stub.getLicensePoolCallable();
    }

    public final LicensePool updateLicensePool(LicensePool licensePool, FieldMask updateMask) {
        UpdateLicensePoolRequest request = UpdateLicensePoolRequest.newBuilder().setLicensePool(licensePool).setUpdateMask(updateMask).build();
        return this.updateLicensePool(request);
    }

    public final LicensePool updateLicensePool(UpdateLicensePoolRequest request) {
        return (LicensePool)this.updateLicensePoolCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateLicensePoolRequest, LicensePool> updateLicensePoolCallable() {
        return this.stub.updateLicensePoolCallable();
    }

    public final AssignResponse assign(String parent, List<String> usernames) {
        AssignRequest request = AssignRequest.newBuilder().setParent(parent).addAllUsernames(usernames).build();
        return this.assign(request);
    }

    public final AssignResponse assign(AssignRequest request) {
        return (AssignResponse)this.assignCallable().call((Object)request);
    }

    public final UnaryCallable<AssignRequest, AssignResponse> assignCallable() {
        return this.stub.assignCallable();
    }

    public final UnassignResponse unassign(String parent, List<String> usernames) {
        UnassignRequest request = UnassignRequest.newBuilder().setParent(parent).addAllUsernames(usernames).build();
        return this.unassign(request);
    }

    public final UnassignResponse unassign(UnassignRequest request) {
        return (UnassignResponse)this.unassignCallable().call((Object)request);
    }

    public final UnaryCallable<UnassignRequest, UnassignResponse> unassignCallable() {
        return this.stub.unassignCallable();
    }

    public final EnumerateLicensedUsersPagedResponse enumerateLicensedUsers(String parent) {
        EnumerateLicensedUsersRequest request = EnumerateLicensedUsersRequest.newBuilder().setParent(parent).build();
        return this.enumerateLicensedUsers(request);
    }

    public final EnumerateLicensedUsersPagedResponse enumerateLicensedUsers(EnumerateLicensedUsersRequest request) {
        return (EnumerateLicensedUsersPagedResponse)((Object)this.enumerateLicensedUsersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<EnumerateLicensedUsersRequest, EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersPagedCallable() {
        return this.stub.enumerateLicensedUsersPagedCallable();
    }

    public final UnaryCallable<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse> enumerateLicensedUsersCallable() {
        return this.stub.enumerateLicensedUsersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class EnumerateLicensedUsersFixedSizeCollection
    extends AbstractFixedSizeCollection<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser, EnumerateLicensedUsersPage, EnumerateLicensedUsersFixedSizeCollection> {
        private EnumerateLicensedUsersFixedSizeCollection(List<EnumerateLicensedUsersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static EnumerateLicensedUsersFixedSizeCollection createEmptyCollection() {
            return new EnumerateLicensedUsersFixedSizeCollection(null, 0);
        }

        protected EnumerateLicensedUsersFixedSizeCollection createCollection(List<EnumerateLicensedUsersPage> pages, int collectionSize) {
            return new EnumerateLicensedUsersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class EnumerateLicensedUsersPage
    extends AbstractPage<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser, EnumerateLicensedUsersPage> {
        private EnumerateLicensedUsersPage(PageContext<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser> context, EnumerateLicensedUsersResponse response) {
            super(context, (Object)response);
        }

        private static EnumerateLicensedUsersPage createEmptyPage() {
            return new EnumerateLicensedUsersPage(null, null);
        }

        protected EnumerateLicensedUsersPage createPage(PageContext<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser> context, EnumerateLicensedUsersResponse response) {
            return new EnumerateLicensedUsersPage(context, response);
        }

        public ApiFuture<EnumerateLicensedUsersPage> createPageAsync(PageContext<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser> context, ApiFuture<EnumerateLicensedUsersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class EnumerateLicensedUsersPagedResponse
    extends AbstractPagedListResponse<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser, EnumerateLicensedUsersPage, EnumerateLicensedUsersFixedSizeCollection> {
        public static ApiFuture<EnumerateLicensedUsersPagedResponse> createAsync(PageContext<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser> context, ApiFuture<EnumerateLicensedUsersResponse> futureResponse) {
            ApiFuture<EnumerateLicensedUsersPage> futurePage = EnumerateLicensedUsersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new EnumerateLicensedUsersPagedResponse((EnumerateLicensedUsersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private EnumerateLicensedUsersPagedResponse(EnumerateLicensedUsersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)EnumerateLicensedUsersFixedSizeCollection.createEmptyCollection());
        }
    }
}

