/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.CreateDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.DataAccessControlServiceSettings;
import com.google.cloud.chronicle.v1.DataAccessLabel;
import com.google.cloud.chronicle.v1.DataAccessLabelName;
import com.google.cloud.chronicle.v1.DataAccessScope;
import com.google.cloud.chronicle.v1.DataAccessScopeName;
import com.google.cloud.chronicle.v1.DeleteDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.DeleteDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.GetDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.GetDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.InstanceName;
import com.google.cloud.chronicle.v1.ListDataAccessLabelsRequest;
import com.google.cloud.chronicle.v1.ListDataAccessLabelsResponse;
import com.google.cloud.chronicle.v1.ListDataAccessScopesRequest;
import com.google.cloud.chronicle.v1.ListDataAccessScopesResponse;
import com.google.cloud.chronicle.v1.UpdateDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.UpdateDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.stub.DataAccessControlServiceStub;
import com.google.cloud.chronicle.v1.stub.DataAccessControlServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataAccessControlServiceClient
implements BackgroundResource {
    private final DataAccessControlServiceSettings settings;
    private final DataAccessControlServiceStub stub;

    public static final DataAccessControlServiceClient create() throws IOException {
        return DataAccessControlServiceClient.create(DataAccessControlServiceSettings.newBuilder().build());
    }

    public static final DataAccessControlServiceClient create(DataAccessControlServiceSettings settings) throws IOException {
        return new DataAccessControlServiceClient(settings);
    }

    public static final DataAccessControlServiceClient create(DataAccessControlServiceStub stub) {
        return new DataAccessControlServiceClient(stub);
    }

    protected DataAccessControlServiceClient(DataAccessControlServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataAccessControlServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataAccessControlServiceClient(DataAccessControlServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataAccessControlServiceSettings getSettings() {
        return this.settings;
    }

    public DataAccessControlServiceStub getStub() {
        return this.stub;
    }

    public final DataAccessLabel createDataAccessLabel(InstanceName parent, DataAccessLabel dataAccessLabel, String dataAccessLabelId) {
        CreateDataAccessLabelRequest request = CreateDataAccessLabelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataAccessLabel(dataAccessLabel).setDataAccessLabelId(dataAccessLabelId).build();
        return this.createDataAccessLabel(request);
    }

    public final DataAccessLabel createDataAccessLabel(String parent, DataAccessLabel dataAccessLabel, String dataAccessLabelId) {
        CreateDataAccessLabelRequest request = CreateDataAccessLabelRequest.newBuilder().setParent(parent).setDataAccessLabel(dataAccessLabel).setDataAccessLabelId(dataAccessLabelId).build();
        return this.createDataAccessLabel(request);
    }

    public final DataAccessLabel createDataAccessLabel(CreateDataAccessLabelRequest request) {
        return (DataAccessLabel)this.createDataAccessLabelCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataAccessLabelRequest, DataAccessLabel> createDataAccessLabelCallable() {
        return this.stub.createDataAccessLabelCallable();
    }

    public final DataAccessLabel getDataAccessLabel(DataAccessLabelName name) {
        GetDataAccessLabelRequest request = GetDataAccessLabelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataAccessLabel(request);
    }

    public final DataAccessLabel getDataAccessLabel(String name) {
        GetDataAccessLabelRequest request = GetDataAccessLabelRequest.newBuilder().setName(name).build();
        return this.getDataAccessLabel(request);
    }

    public final DataAccessLabel getDataAccessLabel(GetDataAccessLabelRequest request) {
        return (DataAccessLabel)this.getDataAccessLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataAccessLabelRequest, DataAccessLabel> getDataAccessLabelCallable() {
        return this.stub.getDataAccessLabelCallable();
    }

    public final ListDataAccessLabelsPagedResponse listDataAccessLabels(InstanceName parent) {
        ListDataAccessLabelsRequest request = ListDataAccessLabelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataAccessLabels(request);
    }

    public final ListDataAccessLabelsPagedResponse listDataAccessLabels(String parent) {
        ListDataAccessLabelsRequest request = ListDataAccessLabelsRequest.newBuilder().setParent(parent).build();
        return this.listDataAccessLabels(request);
    }

    public final ListDataAccessLabelsPagedResponse listDataAccessLabels(ListDataAccessLabelsRequest request) {
        return (ListDataAccessLabelsPagedResponse)((Object)this.listDataAccessLabelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataAccessLabelsRequest, ListDataAccessLabelsPagedResponse> listDataAccessLabelsPagedCallable() {
        return this.stub.listDataAccessLabelsPagedCallable();
    }

    public final UnaryCallable<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse> listDataAccessLabelsCallable() {
        return this.stub.listDataAccessLabelsCallable();
    }

    public final DataAccessLabel updateDataAccessLabel(DataAccessLabel dataAccessLabel, FieldMask updateMask) {
        UpdateDataAccessLabelRequest request = UpdateDataAccessLabelRequest.newBuilder().setDataAccessLabel(dataAccessLabel).setUpdateMask(updateMask).build();
        return this.updateDataAccessLabel(request);
    }

    public final DataAccessLabel updateDataAccessLabel(UpdateDataAccessLabelRequest request) {
        return (DataAccessLabel)this.updateDataAccessLabelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataAccessLabelRequest, DataAccessLabel> updateDataAccessLabelCallable() {
        return this.stub.updateDataAccessLabelCallable();
    }

    public final void deleteDataAccessLabel(DataAccessLabelName name) {
        DeleteDataAccessLabelRequest request = DeleteDataAccessLabelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataAccessLabel(request);
    }

    public final void deleteDataAccessLabel(String name) {
        DeleteDataAccessLabelRequest request = DeleteDataAccessLabelRequest.newBuilder().setName(name).build();
        this.deleteDataAccessLabel(request);
    }

    public final void deleteDataAccessLabel(DeleteDataAccessLabelRequest request) {
        this.deleteDataAccessLabelCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataAccessLabelRequest, Empty> deleteDataAccessLabelCallable() {
        return this.stub.deleteDataAccessLabelCallable();
    }

    public final DataAccessScope createDataAccessScope(InstanceName parent, DataAccessScope dataAccessScope, String dataAccessScopeId) {
        CreateDataAccessScopeRequest request = CreateDataAccessScopeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataAccessScope(dataAccessScope).setDataAccessScopeId(dataAccessScopeId).build();
        return this.createDataAccessScope(request);
    }

    public final DataAccessScope createDataAccessScope(String parent, DataAccessScope dataAccessScope, String dataAccessScopeId) {
        CreateDataAccessScopeRequest request = CreateDataAccessScopeRequest.newBuilder().setParent(parent).setDataAccessScope(dataAccessScope).setDataAccessScopeId(dataAccessScopeId).build();
        return this.createDataAccessScope(request);
    }

    public final DataAccessScope createDataAccessScope(CreateDataAccessScopeRequest request) {
        return (DataAccessScope)this.createDataAccessScopeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataAccessScopeRequest, DataAccessScope> createDataAccessScopeCallable() {
        return this.stub.createDataAccessScopeCallable();
    }

    public final DataAccessScope getDataAccessScope(DataAccessScopeName name) {
        GetDataAccessScopeRequest request = GetDataAccessScopeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataAccessScope(request);
    }

    public final DataAccessScope getDataAccessScope(String name) {
        GetDataAccessScopeRequest request = GetDataAccessScopeRequest.newBuilder().setName(name).build();
        return this.getDataAccessScope(request);
    }

    public final DataAccessScope getDataAccessScope(GetDataAccessScopeRequest request) {
        return (DataAccessScope)this.getDataAccessScopeCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataAccessScopeRequest, DataAccessScope> getDataAccessScopeCallable() {
        return this.stub.getDataAccessScopeCallable();
    }

    public final ListDataAccessScopesPagedResponse listDataAccessScopes(InstanceName parent) {
        ListDataAccessScopesRequest request = ListDataAccessScopesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataAccessScopes(request);
    }

    public final ListDataAccessScopesPagedResponse listDataAccessScopes(String parent) {
        ListDataAccessScopesRequest request = ListDataAccessScopesRequest.newBuilder().setParent(parent).build();
        return this.listDataAccessScopes(request);
    }

    public final ListDataAccessScopesPagedResponse listDataAccessScopes(ListDataAccessScopesRequest request) {
        return (ListDataAccessScopesPagedResponse)((Object)this.listDataAccessScopesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataAccessScopesRequest, ListDataAccessScopesPagedResponse> listDataAccessScopesPagedCallable() {
        return this.stub.listDataAccessScopesPagedCallable();
    }

    public final UnaryCallable<ListDataAccessScopesRequest, ListDataAccessScopesResponse> listDataAccessScopesCallable() {
        return this.stub.listDataAccessScopesCallable();
    }

    public final DataAccessScope updateDataAccessScope(DataAccessScope dataAccessScope, FieldMask updateMask) {
        UpdateDataAccessScopeRequest request = UpdateDataAccessScopeRequest.newBuilder().setDataAccessScope(dataAccessScope).setUpdateMask(updateMask).build();
        return this.updateDataAccessScope(request);
    }

    public final DataAccessScope updateDataAccessScope(UpdateDataAccessScopeRequest request) {
        return (DataAccessScope)this.updateDataAccessScopeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataAccessScopeRequest, DataAccessScope> updateDataAccessScopeCallable() {
        return this.stub.updateDataAccessScopeCallable();
    }

    public final void deleteDataAccessScope(DataAccessScopeName name) {
        DeleteDataAccessScopeRequest request = DeleteDataAccessScopeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataAccessScope(request);
    }

    public final void deleteDataAccessScope(String name) {
        DeleteDataAccessScopeRequest request = DeleteDataAccessScopeRequest.newBuilder().setName(name).build();
        this.deleteDataAccessScope(request);
    }

    public final void deleteDataAccessScope(DeleteDataAccessScopeRequest request) {
        this.deleteDataAccessScopeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataAccessScopeRequest, Empty> deleteDataAccessScopeCallable() {
        return this.stub.deleteDataAccessScopeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDataAccessScopesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope, ListDataAccessScopesPage, ListDataAccessScopesFixedSizeCollection> {
        private ListDataAccessScopesFixedSizeCollection(List<ListDataAccessScopesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataAccessScopesFixedSizeCollection createEmptyCollection() {
            return new ListDataAccessScopesFixedSizeCollection(null, 0);
        }

        protected ListDataAccessScopesFixedSizeCollection createCollection(List<ListDataAccessScopesPage> pages, int collectionSize) {
            return new ListDataAccessScopesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataAccessScopesPage
    extends AbstractPage<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope, ListDataAccessScopesPage> {
        private ListDataAccessScopesPage(PageContext<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope> context, ListDataAccessScopesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataAccessScopesPage createEmptyPage() {
            return new ListDataAccessScopesPage(null, null);
        }

        protected ListDataAccessScopesPage createPage(PageContext<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope> context, ListDataAccessScopesResponse response) {
            return new ListDataAccessScopesPage(context, response);
        }

        public ApiFuture<ListDataAccessScopesPage> createPageAsync(PageContext<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope> context, ApiFuture<ListDataAccessScopesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataAccessScopesPagedResponse
    extends AbstractPagedListResponse<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope, ListDataAccessScopesPage, ListDataAccessScopesFixedSizeCollection> {
        public static ApiFuture<ListDataAccessScopesPagedResponse> createAsync(PageContext<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope> context, ApiFuture<ListDataAccessScopesResponse> futureResponse) {
            ApiFuture<ListDataAccessScopesPage> futurePage = ListDataAccessScopesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataAccessScopesPagedResponse((ListDataAccessScopesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataAccessScopesPagedResponse(ListDataAccessScopesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataAccessScopesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataAccessLabelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel, ListDataAccessLabelsPage, ListDataAccessLabelsFixedSizeCollection> {
        private ListDataAccessLabelsFixedSizeCollection(List<ListDataAccessLabelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataAccessLabelsFixedSizeCollection createEmptyCollection() {
            return new ListDataAccessLabelsFixedSizeCollection(null, 0);
        }

        protected ListDataAccessLabelsFixedSizeCollection createCollection(List<ListDataAccessLabelsPage> pages, int collectionSize) {
            return new ListDataAccessLabelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataAccessLabelsPage
    extends AbstractPage<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel, ListDataAccessLabelsPage> {
        private ListDataAccessLabelsPage(PageContext<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel> context, ListDataAccessLabelsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataAccessLabelsPage createEmptyPage() {
            return new ListDataAccessLabelsPage(null, null);
        }

        protected ListDataAccessLabelsPage createPage(PageContext<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel> context, ListDataAccessLabelsResponse response) {
            return new ListDataAccessLabelsPage(context, response);
        }

        public ApiFuture<ListDataAccessLabelsPage> createPageAsync(PageContext<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel> context, ApiFuture<ListDataAccessLabelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataAccessLabelsPagedResponse
    extends AbstractPagedListResponse<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel, ListDataAccessLabelsPage, ListDataAccessLabelsFixedSizeCollection> {
        public static ApiFuture<ListDataAccessLabelsPagedResponse> createAsync(PageContext<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel> context, ApiFuture<ListDataAccessLabelsResponse> futureResponse) {
            ApiFuture<ListDataAccessLabelsPage> futurePage = ListDataAccessLabelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataAccessLabelsPagedResponse((ListDataAccessLabelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataAccessLabelsPagedResponse(ListDataAccessLabelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataAccessLabelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

