/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateWatchlistRequest;
import com.google.cloud.chronicle.v1.DeleteWatchlistRequest;
import com.google.cloud.chronicle.v1.EntityServiceClient;
import com.google.cloud.chronicle.v1.GetWatchlistRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsResponse;
import com.google.cloud.chronicle.v1.UpdateWatchlistRequest;
import com.google.cloud.chronicle.v1.Watchlist;
import com.google.cloud.chronicle.v1.stub.EntityServiceStub;
import com.google.cloud.chronicle.v1.stub.EntityServiceStubSettings;
import com.google.cloud.chronicle.v1.stub.GrpcEntityServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcEntityServiceStub
extends EntityServiceStub {
    private static final MethodDescriptor<GetWatchlistRequest, Watchlist> getWatchlistMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.EntityService/GetWatchlist").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWatchlistRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Watchlist.getDefaultInstance())).build();
    private static final MethodDescriptor<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.EntityService/ListWatchlists").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWatchlistsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWatchlistsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateWatchlistRequest, Watchlist> createWatchlistMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.EntityService/CreateWatchlist").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWatchlistRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Watchlist.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWatchlistRequest, Watchlist> updateWatchlistMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.EntityService/UpdateWatchlist").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWatchlistRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Watchlist.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWatchlistRequest, Empty> deleteWatchlistMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.EntityService/DeleteWatchlist").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWatchlistRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<GetWatchlistRequest, Watchlist> getWatchlistCallable;
    private final UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsCallable;
    private final UnaryCallable<ListWatchlistsRequest, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsPagedCallable;
    private final UnaryCallable<CreateWatchlistRequest, Watchlist> createWatchlistCallable;
    private final UnaryCallable<UpdateWatchlistRequest, Watchlist> updateWatchlistCallable;
    private final UnaryCallable<DeleteWatchlistRequest, Empty> deleteWatchlistCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEntityServiceStub create(EntityServiceStubSettings settings) throws IOException {
        return new GrpcEntityServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEntityServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEntityServiceStub(EntityServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEntityServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEntityServiceStub(EntityServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEntityServiceStub(EntityServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEntityServiceCallableFactory());
    }

    protected GrpcEntityServiceStub(EntityServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getWatchlistTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWatchlistMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listWatchlistsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWatchlistsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createWatchlistTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWatchlistMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateWatchlistTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWatchlistMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("watchlist.name", String.valueOf(request.getWatchlist().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteWatchlistTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWatchlistMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getWatchlistCallable = callableFactory.createUnaryCallable(getWatchlistTransportSettings, settings.getWatchlistSettings(), clientContext);
        this.listWatchlistsCallable = callableFactory.createUnaryCallable(listWatchlistsTransportSettings, settings.listWatchlistsSettings(), clientContext);
        this.listWatchlistsPagedCallable = callableFactory.createPagedCallable(listWatchlistsTransportSettings, settings.listWatchlistsSettings(), clientContext);
        this.createWatchlistCallable = callableFactory.createUnaryCallable(createWatchlistTransportSettings, settings.createWatchlistSettings(), clientContext);
        this.updateWatchlistCallable = callableFactory.createUnaryCallable(updateWatchlistTransportSettings, settings.updateWatchlistSettings(), clientContext);
        this.deleteWatchlistCallable = callableFactory.createUnaryCallable(deleteWatchlistTransportSettings, settings.deleteWatchlistSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetWatchlistRequest, Watchlist> getWatchlistCallable() {
        return this.getWatchlistCallable;
    }

    @Override
    public UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsCallable() {
        return this.listWatchlistsCallable;
    }

    @Override
    public UnaryCallable<ListWatchlistsRequest, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsPagedCallable() {
        return this.listWatchlistsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateWatchlistRequest, Watchlist> createWatchlistCallable() {
        return this.createWatchlistCallable;
    }

    @Override
    public UnaryCallable<UpdateWatchlistRequest, Watchlist> updateWatchlistCallable() {
        return this.updateWatchlistCallable;
    }

    @Override
    public UnaryCallable<DeleteWatchlistRequest, Empty> deleteWatchlistCallable() {
        return this.deleteWatchlistCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

