/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateRetrohuntRequest;
import com.google.cloud.chronicle.v1.CreateRuleRequest;
import com.google.cloud.chronicle.v1.DeleteRuleRequest;
import com.google.cloud.chronicle.v1.GetRetrohuntRequest;
import com.google.cloud.chronicle.v1.GetRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.GetRuleRequest;
import com.google.cloud.chronicle.v1.InstanceName;
import com.google.cloud.chronicle.v1.ListRetrohuntsRequest;
import com.google.cloud.chronicle.v1.ListRetrohuntsResponse;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsRequest;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsResponse;
import com.google.cloud.chronicle.v1.ListRuleRevisionsRequest;
import com.google.cloud.chronicle.v1.ListRuleRevisionsResponse;
import com.google.cloud.chronicle.v1.ListRulesRequest;
import com.google.cloud.chronicle.v1.ListRulesResponse;
import com.google.cloud.chronicle.v1.Retrohunt;
import com.google.cloud.chronicle.v1.RetrohuntMetadata;
import com.google.cloud.chronicle.v1.RetrohuntName;
import com.google.cloud.chronicle.v1.Rule;
import com.google.cloud.chronicle.v1.RuleDeployment;
import com.google.cloud.chronicle.v1.RuleDeploymentName;
import com.google.cloud.chronicle.v1.RuleName;
import com.google.cloud.chronicle.v1.RuleServiceSettings;
import com.google.cloud.chronicle.v1.UpdateRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.UpdateRuleRequest;
import com.google.cloud.chronicle.v1.stub.RuleServiceStub;
import com.google.cloud.chronicle.v1.stub.RuleServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RuleServiceClient
implements BackgroundResource {
    private final RuleServiceSettings settings;
    private final RuleServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final RuleServiceClient create() throws IOException {
        return RuleServiceClient.create(RuleServiceSettings.newBuilder().build());
    }

    public static final RuleServiceClient create(RuleServiceSettings settings) throws IOException {
        return new RuleServiceClient(settings);
    }

    public static final RuleServiceClient create(RuleServiceStub stub) {
        return new RuleServiceClient(stub);
    }

    protected RuleServiceClient(RuleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RuleServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected RuleServiceClient(RuleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final RuleServiceSettings getSettings() {
        return this.settings;
    }

    public RuleServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Rule createRule(InstanceName parent, Rule rule) {
        CreateRuleRequest request = CreateRuleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRule(rule).build();
        return this.createRule(request);
    }

    public final Rule createRule(String parent, Rule rule) {
        CreateRuleRequest request = CreateRuleRequest.newBuilder().setParent(parent).setRule(rule).build();
        return this.createRule(request);
    }

    public final Rule createRule(CreateRuleRequest request) {
        return (Rule)this.createRuleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRuleRequest, Rule> createRuleCallable() {
        return this.stub.createRuleCallable();
    }

    public final Rule getRule(RuleName name) {
        GetRuleRequest request = GetRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRule(request);
    }

    public final Rule getRule(String name) {
        GetRuleRequest request = GetRuleRequest.newBuilder().setName(name).build();
        return this.getRule(request);
    }

    public final Rule getRule(GetRuleRequest request) {
        return (Rule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleRequest, Rule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final ListRulesPagedResponse listRules(InstanceName parent) {
        ListRulesRequest request = ListRulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRules(request);
    }

    public final ListRulesPagedResponse listRules(String parent) {
        ListRulesRequest request = ListRulesRequest.newBuilder().setParent(parent).build();
        return this.listRules(request);
    }

    public final ListRulesPagedResponse listRules(ListRulesRequest request) {
        return (ListRulesPagedResponse)((Object)this.listRulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRulesRequest, ListRulesPagedResponse> listRulesPagedCallable() {
        return this.stub.listRulesPagedCallable();
    }

    public final UnaryCallable<ListRulesRequest, ListRulesResponse> listRulesCallable() {
        return this.stub.listRulesCallable();
    }

    public final Rule updateRule(Rule rule, FieldMask updateMask) {
        UpdateRuleRequest request = UpdateRuleRequest.newBuilder().setRule(rule).setUpdateMask(updateMask).build();
        return this.updateRule(request);
    }

    public final Rule updateRule(UpdateRuleRequest request) {
        return (Rule)this.updateRuleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRuleRequest, Rule> updateRuleCallable() {
        return this.stub.updateRuleCallable();
    }

    public final void deleteRule(RuleName name) {
        DeleteRuleRequest request = DeleteRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRule(request);
    }

    public final void deleteRule(String name) {
        DeleteRuleRequest request = DeleteRuleRequest.newBuilder().setName(name).build();
        this.deleteRule(request);
    }

    public final void deleteRule(DeleteRuleRequest request) {
        this.deleteRuleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRuleRequest, Empty> deleteRuleCallable() {
        return this.stub.deleteRuleCallable();
    }

    public final ListRuleRevisionsPagedResponse listRuleRevisions(RuleName name) {
        ListRuleRevisionsRequest request = ListRuleRevisionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listRuleRevisions(request);
    }

    public final ListRuleRevisionsPagedResponse listRuleRevisions(String name) {
        ListRuleRevisionsRequest request = ListRuleRevisionsRequest.newBuilder().setName(name).build();
        return this.listRuleRevisions(request);
    }

    public final ListRuleRevisionsPagedResponse listRuleRevisions(ListRuleRevisionsRequest request) {
        return (ListRuleRevisionsPagedResponse)((Object)this.listRuleRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuleRevisionsRequest, ListRuleRevisionsPagedResponse> listRuleRevisionsPagedCallable() {
        return this.stub.listRuleRevisionsPagedCallable();
    }

    public final UnaryCallable<ListRuleRevisionsRequest, ListRuleRevisionsResponse> listRuleRevisionsCallable() {
        return this.stub.listRuleRevisionsCallable();
    }

    public final OperationFuture<Retrohunt, RetrohuntMetadata> createRetrohuntAsync(RuleName parent, Retrohunt retrohunt) {
        CreateRetrohuntRequest request = CreateRetrohuntRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRetrohunt(retrohunt).build();
        return this.createRetrohuntAsync(request);
    }

    public final OperationFuture<Retrohunt, RetrohuntMetadata> createRetrohuntAsync(String parent, Retrohunt retrohunt) {
        CreateRetrohuntRequest request = CreateRetrohuntRequest.newBuilder().setParent(parent).setRetrohunt(retrohunt).build();
        return this.createRetrohuntAsync(request);
    }

    public final OperationFuture<Retrohunt, RetrohuntMetadata> createRetrohuntAsync(CreateRetrohuntRequest request) {
        return this.createRetrohuntOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationCallable() {
        return this.stub.createRetrohuntOperationCallable();
    }

    public final UnaryCallable<CreateRetrohuntRequest, Operation> createRetrohuntCallable() {
        return this.stub.createRetrohuntCallable();
    }

    public final Retrohunt getRetrohunt(RetrohuntName name) {
        GetRetrohuntRequest request = GetRetrohuntRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRetrohunt(request);
    }

    public final Retrohunt getRetrohunt(String name) {
        GetRetrohuntRequest request = GetRetrohuntRequest.newBuilder().setName(name).build();
        return this.getRetrohunt(request);
    }

    public final Retrohunt getRetrohunt(GetRetrohuntRequest request) {
        return (Retrohunt)this.getRetrohuntCallable().call((Object)request);
    }

    public final UnaryCallable<GetRetrohuntRequest, Retrohunt> getRetrohuntCallable() {
        return this.stub.getRetrohuntCallable();
    }

    public final ListRetrohuntsPagedResponse listRetrohunts(RuleName parent) {
        ListRetrohuntsRequest request = ListRetrohuntsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRetrohunts(request);
    }

    public final ListRetrohuntsPagedResponse listRetrohunts(String parent) {
        ListRetrohuntsRequest request = ListRetrohuntsRequest.newBuilder().setParent(parent).build();
        return this.listRetrohunts(request);
    }

    public final ListRetrohuntsPagedResponse listRetrohunts(ListRetrohuntsRequest request) {
        return (ListRetrohuntsPagedResponse)((Object)this.listRetrohuntsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRetrohuntsRequest, ListRetrohuntsPagedResponse> listRetrohuntsPagedCallable() {
        return this.stub.listRetrohuntsPagedCallable();
    }

    public final UnaryCallable<ListRetrohuntsRequest, ListRetrohuntsResponse> listRetrohuntsCallable() {
        return this.stub.listRetrohuntsCallable();
    }

    public final RuleDeployment getRuleDeployment(RuleDeploymentName name) {
        GetRuleDeploymentRequest request = GetRuleDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRuleDeployment(request);
    }

    public final RuleDeployment getRuleDeployment(String name) {
        GetRuleDeploymentRequest request = GetRuleDeploymentRequest.newBuilder().setName(name).build();
        return this.getRuleDeployment(request);
    }

    public final RuleDeployment getRuleDeployment(GetRuleDeploymentRequest request) {
        return (RuleDeployment)this.getRuleDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentCallable() {
        return this.stub.getRuleDeploymentCallable();
    }

    public final ListRuleDeploymentsPagedResponse listRuleDeployments(RuleName parent) {
        ListRuleDeploymentsRequest request = ListRuleDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuleDeployments(request);
    }

    public final ListRuleDeploymentsPagedResponse listRuleDeployments(String parent) {
        ListRuleDeploymentsRequest request = ListRuleDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listRuleDeployments(request);
    }

    public final ListRuleDeploymentsPagedResponse listRuleDeployments(ListRuleDeploymentsRequest request) {
        return (ListRuleDeploymentsPagedResponse)((Object)this.listRuleDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuleDeploymentsRequest, ListRuleDeploymentsPagedResponse> listRuleDeploymentsPagedCallable() {
        return this.stub.listRuleDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse> listRuleDeploymentsCallable() {
        return this.stub.listRuleDeploymentsCallable();
    }

    public final RuleDeployment updateRuleDeployment(RuleDeployment ruleDeployment, FieldMask updateMask) {
        UpdateRuleDeploymentRequest request = UpdateRuleDeploymentRequest.newBuilder().setRuleDeployment(ruleDeployment).setUpdateMask(updateMask).build();
        return this.updateRuleDeployment(request);
    }

    public final RuleDeployment updateRuleDeployment(UpdateRuleDeploymentRequest request) {
        return (RuleDeployment)this.updateRuleDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentCallable() {
        return this.stub.updateRuleDeploymentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRuleDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment, ListRuleDeploymentsPage, ListRuleDeploymentsFixedSizeCollection> {
        private ListRuleDeploymentsFixedSizeCollection(List<ListRuleDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuleDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListRuleDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListRuleDeploymentsFixedSizeCollection createCollection(List<ListRuleDeploymentsPage> pages, int collectionSize) {
            return new ListRuleDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuleDeploymentsPage
    extends AbstractPage<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment, ListRuleDeploymentsPage> {
        private ListRuleDeploymentsPage(PageContext<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment> context, ListRuleDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListRuleDeploymentsPage createEmptyPage() {
            return new ListRuleDeploymentsPage(null, null);
        }

        protected ListRuleDeploymentsPage createPage(PageContext<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment> context, ListRuleDeploymentsResponse response) {
            return new ListRuleDeploymentsPage(context, response);
        }

        public ApiFuture<ListRuleDeploymentsPage> createPageAsync(PageContext<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment> context, ApiFuture<ListRuleDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuleDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment, ListRuleDeploymentsPage, ListRuleDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListRuleDeploymentsPagedResponse> createAsync(PageContext<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment> context, ApiFuture<ListRuleDeploymentsResponse> futureResponse) {
            ApiFuture<ListRuleDeploymentsPage> futurePage = ListRuleDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuleDeploymentsPagedResponse((ListRuleDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuleDeploymentsPagedResponse(ListRuleDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuleDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRetrohuntsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt, ListRetrohuntsPage, ListRetrohuntsFixedSizeCollection> {
        private ListRetrohuntsFixedSizeCollection(List<ListRetrohuntsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRetrohuntsFixedSizeCollection createEmptyCollection() {
            return new ListRetrohuntsFixedSizeCollection(null, 0);
        }

        protected ListRetrohuntsFixedSizeCollection createCollection(List<ListRetrohuntsPage> pages, int collectionSize) {
            return new ListRetrohuntsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRetrohuntsPage
    extends AbstractPage<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt, ListRetrohuntsPage> {
        private ListRetrohuntsPage(PageContext<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt> context, ListRetrohuntsResponse response) {
            super(context, (Object)response);
        }

        private static ListRetrohuntsPage createEmptyPage() {
            return new ListRetrohuntsPage(null, null);
        }

        protected ListRetrohuntsPage createPage(PageContext<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt> context, ListRetrohuntsResponse response) {
            return new ListRetrohuntsPage(context, response);
        }

        public ApiFuture<ListRetrohuntsPage> createPageAsync(PageContext<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt> context, ApiFuture<ListRetrohuntsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRetrohuntsPagedResponse
    extends AbstractPagedListResponse<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt, ListRetrohuntsPage, ListRetrohuntsFixedSizeCollection> {
        public static ApiFuture<ListRetrohuntsPagedResponse> createAsync(PageContext<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt> context, ApiFuture<ListRetrohuntsResponse> futureResponse) {
            ApiFuture<ListRetrohuntsPage> futurePage = ListRetrohuntsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRetrohuntsPagedResponse((ListRetrohuntsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRetrohuntsPagedResponse(ListRetrohuntsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRetrohuntsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRuleRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule, ListRuleRevisionsPage, ListRuleRevisionsFixedSizeCollection> {
        private ListRuleRevisionsFixedSizeCollection(List<ListRuleRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuleRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListRuleRevisionsFixedSizeCollection(null, 0);
        }

        protected ListRuleRevisionsFixedSizeCollection createCollection(List<ListRuleRevisionsPage> pages, int collectionSize) {
            return new ListRuleRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuleRevisionsPage
    extends AbstractPage<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule, ListRuleRevisionsPage> {
        private ListRuleRevisionsPage(PageContext<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule> context, ListRuleRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListRuleRevisionsPage createEmptyPage() {
            return new ListRuleRevisionsPage(null, null);
        }

        protected ListRuleRevisionsPage createPage(PageContext<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule> context, ListRuleRevisionsResponse response) {
            return new ListRuleRevisionsPage(context, response);
        }

        public ApiFuture<ListRuleRevisionsPage> createPageAsync(PageContext<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule> context, ApiFuture<ListRuleRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuleRevisionsPagedResponse
    extends AbstractPagedListResponse<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule, ListRuleRevisionsPage, ListRuleRevisionsFixedSizeCollection> {
        public static ApiFuture<ListRuleRevisionsPagedResponse> createAsync(PageContext<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule> context, ApiFuture<ListRuleRevisionsResponse> futureResponse) {
            ApiFuture<ListRuleRevisionsPage> futurePage = ListRuleRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuleRevisionsPagedResponse((ListRuleRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuleRevisionsPagedResponse(ListRuleRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuleRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage, ListRulesFixedSizeCollection> {
        private ListRulesFixedSizeCollection(List<ListRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRulesFixedSizeCollection createEmptyCollection() {
            return new ListRulesFixedSizeCollection(null, 0);
        }

        protected ListRulesFixedSizeCollection createCollection(List<ListRulesPage> pages, int collectionSize) {
            return new ListRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRulesPage
    extends AbstractPage<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage> {
        private ListRulesPage(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ListRulesResponse response) {
            super(context, (Object)response);
        }

        private static ListRulesPage createEmptyPage() {
            return new ListRulesPage(null, null);
        }

        protected ListRulesPage createPage(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ListRulesResponse response) {
            return new ListRulesPage(context, response);
        }

        public ApiFuture<ListRulesPage> createPageAsync(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ApiFuture<ListRulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRulesPagedResponse
    extends AbstractPagedListResponse<ListRulesRequest, ListRulesResponse, Rule, ListRulesPage, ListRulesFixedSizeCollection> {
        public static ApiFuture<ListRulesPagedResponse> createAsync(PageContext<ListRulesRequest, ListRulesResponse, Rule> context, ApiFuture<ListRulesResponse> futureResponse) {
            ApiFuture<ListRulesPage> futurePage = ListRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRulesPagedResponse((ListRulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRulesPagedResponse(ListRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRulesFixedSizeCollection.createEmptyCollection());
        }
    }
}

