/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateReferenceListRequest;
import com.google.cloud.chronicle.v1.GetReferenceListRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsResponse;
import com.google.cloud.chronicle.v1.ReferenceList;
import com.google.cloud.chronicle.v1.ReferenceListServiceClient;
import com.google.cloud.chronicle.v1.UpdateReferenceListRequest;
import com.google.cloud.chronicle.v1.stub.GrpcReferenceListServiceStub;
import com.google.cloud.chronicle.v1.stub.HttpJsonReferenceListServiceStub;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReferenceListServiceStubSettings
extends StubSettings<ReferenceListServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetReferenceListRequest, ReferenceList> getReferenceListSettings;
    private final PagedCallSettings<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsSettings;
    private final UnaryCallSettings<CreateReferenceListRequest, ReferenceList> createReferenceListSettings;
    private final UnaryCallSettings<UpdateReferenceListRequest, ReferenceList> updateReferenceListSettings;
    private static final PagedListDescriptor<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList> LIST_REFERENCE_LISTS_PAGE_STR_DESC = new PagedListDescriptor<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList>(){

        public String emptyToken() {
            return "";
        }

        public ListReferenceListsRequest injectToken(ListReferenceListsRequest payload, String token) {
            return ListReferenceListsRequest.newBuilder((ListReferenceListsRequest)payload).setPageToken(token).build();
        }

        public ListReferenceListsRequest injectPageSize(ListReferenceListsRequest payload, int pageSize) {
            return ListReferenceListsRequest.newBuilder((ListReferenceListsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReferenceListsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReferenceListsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReferenceList> extractResources(ListReferenceListsResponse payload) {
            return payload.getReferenceListsList();
        }
    };
    private static final PagedListResponseFactory<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse> LIST_REFERENCE_LISTS_PAGE_STR_FACT = new PagedListResponseFactory<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse>(){

        public ApiFuture<ReferenceListServiceClient.ListReferenceListsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> callable, ListReferenceListsRequest request, ApiCallContext context, ApiFuture<ListReferenceListsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REFERENCE_LISTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReferenceListServiceClient.ListReferenceListsPagedResponse.createAsync((PageContext<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetReferenceListRequest, ReferenceList> getReferenceListSettings() {
        return this.getReferenceListSettings;
    }

    public PagedCallSettings<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsSettings() {
        return this.listReferenceListsSettings;
    }

    public UnaryCallSettings<CreateReferenceListRequest, ReferenceList> createReferenceListSettings() {
        return this.createReferenceListSettings;
    }

    public UnaryCallSettings<UpdateReferenceListRequest, ReferenceList> updateReferenceListSettings() {
        return this.updateReferenceListSettings;
    }

    public ReferenceListServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcReferenceListServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReferenceListServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "chronicle";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "chronicle.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "chronicle.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReferenceListServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReferenceListServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReferenceListServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ReferenceListServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReferenceListServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getReferenceListSettings = settingsBuilder.getReferenceListSettings().build();
        this.listReferenceListsSettings = settingsBuilder.listReferenceListsSettings().build();
        this.createReferenceListSettings = settingsBuilder.createReferenceListSettings().build();
        this.updateReferenceListSettings = settingsBuilder.updateReferenceListSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReferenceListServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetReferenceListRequest, ReferenceList> getReferenceListSettings;
        private final PagedCallSettings.Builder<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsSettings;
        private final UnaryCallSettings.Builder<CreateReferenceListRequest, ReferenceList> createReferenceListSettings;
        private final UnaryCallSettings.Builder<UpdateReferenceListRequest, ReferenceList> updateReferenceListSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getReferenceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReferenceListsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REFERENCE_LISTS_PAGE_STR_FACT);
            this.createReferenceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateReferenceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getReferenceListSettings, this.listReferenceListsSettings, this.createReferenceListSettings, this.updateReferenceListSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReferenceListServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getReferenceListSettings = settings.getReferenceListSettings.toBuilder();
            this.listReferenceListsSettings = settings.listReferenceListsSettings.toBuilder();
            this.createReferenceListSettings = settings.createReferenceListSettings.toBuilder();
            this.updateReferenceListSettings = settings.updateReferenceListSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getReferenceListSettings, this.listReferenceListsSettings, this.createReferenceListSettings, this.updateReferenceListSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReferenceListServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReferenceListServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReferenceListServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReferenceListServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ReferenceListServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ReferenceListServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReferenceListServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReferenceListServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getReferenceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listReferenceListsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createReferenceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.updateReferenceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetReferenceListRequest, ReferenceList> getReferenceListSettings() {
            return this.getReferenceListSettings;
        }

        public PagedCallSettings.Builder<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsSettings() {
            return this.listReferenceListsSettings;
        }

        public UnaryCallSettings.Builder<CreateReferenceListRequest, ReferenceList> createReferenceListSettings() {
            return this.createReferenceListSettings;
        }

        public UnaryCallSettings.Builder<UpdateReferenceListRequest, ReferenceList> updateReferenceListSettings() {
            return this.updateReferenceListSettings;
        }

        public ReferenceListServiceStubSettings build() throws IOException {
            return new ReferenceListServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

