/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateWatchlistRequest;
import com.google.cloud.chronicle.v1.DeleteWatchlistRequest;
import com.google.cloud.chronicle.v1.EntityServiceClient;
import com.google.cloud.chronicle.v1.GetWatchlistRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsResponse;
import com.google.cloud.chronicle.v1.UpdateWatchlistRequest;
import com.google.cloud.chronicle.v1.Watchlist;
import com.google.cloud.chronicle.v1.stub.EntityServiceStub;
import com.google.cloud.chronicle.v1.stub.GrpcEntityServiceStub;
import com.google.cloud.chronicle.v1.stub.HttpJsonEntityServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EntityServiceStubSettings
extends StubSettings<EntityServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetWatchlistRequest, Watchlist> getWatchlistSettings;
    private final PagedCallSettings<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsSettings;
    private final UnaryCallSettings<CreateWatchlistRequest, Watchlist> createWatchlistSettings;
    private final UnaryCallSettings<UpdateWatchlistRequest, Watchlist> updateWatchlistSettings;
    private final UnaryCallSettings<DeleteWatchlistRequest, Empty> deleteWatchlistSettings;
    private static final PagedListDescriptor<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist> LIST_WATCHLISTS_PAGE_STR_DESC = new PagedListDescriptor<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist>(){

        public String emptyToken() {
            return "";
        }

        public ListWatchlistsRequest injectToken(ListWatchlistsRequest payload, String token) {
            return ListWatchlistsRequest.newBuilder((ListWatchlistsRequest)payload).setPageToken(token).build();
        }

        public ListWatchlistsRequest injectPageSize(ListWatchlistsRequest payload, int pageSize) {
            return ListWatchlistsRequest.newBuilder((ListWatchlistsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWatchlistsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWatchlistsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Watchlist> extractResources(ListWatchlistsResponse payload) {
            return payload.getWatchlistsList();
        }
    };
    private static final PagedListResponseFactory<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse> LIST_WATCHLISTS_PAGE_STR_FACT = new PagedListResponseFactory<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse>(){

        public ApiFuture<EntityServiceClient.ListWatchlistsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> callable, ListWatchlistsRequest request, ApiCallContext context, ApiFuture<ListWatchlistsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WATCHLISTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityServiceClient.ListWatchlistsPagedResponse.createAsync((PageContext<ListWatchlistsRequest, ListWatchlistsResponse, Watchlist>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetWatchlistRequest, Watchlist> getWatchlistSettings() {
        return this.getWatchlistSettings;
    }

    public PagedCallSettings<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsSettings() {
        return this.listWatchlistsSettings;
    }

    public UnaryCallSettings<CreateWatchlistRequest, Watchlist> createWatchlistSettings() {
        return this.createWatchlistSettings;
    }

    public UnaryCallSettings<UpdateWatchlistRequest, Watchlist> updateWatchlistSettings() {
        return this.updateWatchlistSettings;
    }

    public UnaryCallSettings<DeleteWatchlistRequest, Empty> deleteWatchlistSettings() {
        return this.deleteWatchlistSettings;
    }

    public EntityServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEntityServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEntityServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "chronicle";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "chronicle.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "chronicle.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EntityServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EntityServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EntityServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getWatchlistSettings = settingsBuilder.getWatchlistSettings().build();
        this.listWatchlistsSettings = settingsBuilder.listWatchlistsSettings().build();
        this.createWatchlistSettings = settingsBuilder.createWatchlistSettings().build();
        this.updateWatchlistSettings = settingsBuilder.updateWatchlistSettings().build();
        this.deleteWatchlistSettings = settingsBuilder.deleteWatchlistSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EntityServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetWatchlistRequest, Watchlist> getWatchlistSettings;
        private final PagedCallSettings.Builder<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsSettings;
        private final UnaryCallSettings.Builder<CreateWatchlistRequest, Watchlist> createWatchlistSettings;
        private final UnaryCallSettings.Builder<UpdateWatchlistRequest, Watchlist> updateWatchlistSettings;
        private final UnaryCallSettings.Builder<DeleteWatchlistRequest, Empty> deleteWatchlistSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getWatchlistSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWatchlistsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WATCHLISTS_PAGE_STR_FACT);
            this.createWatchlistSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWatchlistSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWatchlistSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWatchlistSettings, this.listWatchlistsSettings, this.createWatchlistSettings, this.updateWatchlistSettings, this.deleteWatchlistSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EntityServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getWatchlistSettings = settings.getWatchlistSettings.toBuilder();
            this.listWatchlistsSettings = settings.listWatchlistsSettings.toBuilder();
            this.createWatchlistSettings = settings.createWatchlistSettings.toBuilder();
            this.updateWatchlistSettings = settings.updateWatchlistSettings.toBuilder();
            this.deleteWatchlistSettings = settings.deleteWatchlistSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWatchlistSettings, this.listWatchlistsSettings, this.createWatchlistSettings, this.updateWatchlistSettings, this.deleteWatchlistSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EntityServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EntityServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EntityServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EntityServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getWatchlistSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listWatchlistsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createWatchlistSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.updateWatchlistSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.deleteWatchlistSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetWatchlistRequest, Watchlist> getWatchlistSettings() {
            return this.getWatchlistSettings;
        }

        public PagedCallSettings.Builder<ListWatchlistsRequest, ListWatchlistsResponse, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsSettings() {
            return this.listWatchlistsSettings;
        }

        public UnaryCallSettings.Builder<CreateWatchlistRequest, Watchlist> createWatchlistSettings() {
            return this.createWatchlistSettings;
        }

        public UnaryCallSettings.Builder<UpdateWatchlistRequest, Watchlist> updateWatchlistSettings() {
            return this.updateWatchlistSettings;
        }

        public UnaryCallSettings.Builder<DeleteWatchlistRequest, Empty> deleteWatchlistSettings() {
            return this.deleteWatchlistSettings;
        }

        public EntityServiceStubSettings build() throws IOException {
            return new EntityServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(90000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(90000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(90000L)).setTotalTimeoutDuration(Duration.ofMillis(90000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(90000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(90000L)).setTotalTimeoutDuration(Duration.ofMillis(90000L)).build();
            definitions.put((Object)"no_retry_5_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

