/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.CreateDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.DataAccessControlServiceClient;
import com.google.cloud.chronicle.v1.DataAccessLabel;
import com.google.cloud.chronicle.v1.DataAccessScope;
import com.google.cloud.chronicle.v1.DeleteDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.DeleteDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.GetDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.GetDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.ListDataAccessLabelsRequest;
import com.google.cloud.chronicle.v1.ListDataAccessLabelsResponse;
import com.google.cloud.chronicle.v1.ListDataAccessScopesRequest;
import com.google.cloud.chronicle.v1.ListDataAccessScopesResponse;
import com.google.cloud.chronicle.v1.UpdateDataAccessLabelRequest;
import com.google.cloud.chronicle.v1.UpdateDataAccessScopeRequest;
import com.google.cloud.chronicle.v1.stub.DataAccessControlServiceStub;
import com.google.cloud.chronicle.v1.stub.GrpcDataAccessControlServiceStub;
import com.google.cloud.chronicle.v1.stub.HttpJsonDataAccessControlServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DataAccessControlServiceStubSettings
extends StubSettings<DataAccessControlServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataAccessLabelRequest, DataAccessLabel> createDataAccessLabelSettings;
    private final UnaryCallSettings<GetDataAccessLabelRequest, DataAccessLabel> getDataAccessLabelSettings;
    private final PagedCallSettings<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> listDataAccessLabelsSettings;
    private final UnaryCallSettings<UpdateDataAccessLabelRequest, DataAccessLabel> updateDataAccessLabelSettings;
    private final UnaryCallSettings<DeleteDataAccessLabelRequest, Empty> deleteDataAccessLabelSettings;
    private final UnaryCallSettings<CreateDataAccessScopeRequest, DataAccessScope> createDataAccessScopeSettings;
    private final UnaryCallSettings<GetDataAccessScopeRequest, DataAccessScope> getDataAccessScopeSettings;
    private final PagedCallSettings<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> listDataAccessScopesSettings;
    private final UnaryCallSettings<UpdateDataAccessScopeRequest, DataAccessScope> updateDataAccessScopeSettings;
    private final UnaryCallSettings<DeleteDataAccessScopeRequest, Empty> deleteDataAccessScopeSettings;
    private static final PagedListDescriptor<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel> LIST_DATA_ACCESS_LABELS_PAGE_STR_DESC = new PagedListDescriptor<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel>(){

        public String emptyToken() {
            return "";
        }

        public ListDataAccessLabelsRequest injectToken(ListDataAccessLabelsRequest payload, String token) {
            return ListDataAccessLabelsRequest.newBuilder((ListDataAccessLabelsRequest)payload).setPageToken(token).build();
        }

        public ListDataAccessLabelsRequest injectPageSize(ListDataAccessLabelsRequest payload, int pageSize) {
            return ListDataAccessLabelsRequest.newBuilder((ListDataAccessLabelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataAccessLabelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataAccessLabelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAccessLabel> extractResources(ListDataAccessLabelsResponse payload) {
            return payload.getDataAccessLabelsList();
        }
    };
    private static final PagedListDescriptor<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope> LIST_DATA_ACCESS_SCOPES_PAGE_STR_DESC = new PagedListDescriptor<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope>(){

        public String emptyToken() {
            return "";
        }

        public ListDataAccessScopesRequest injectToken(ListDataAccessScopesRequest payload, String token) {
            return ListDataAccessScopesRequest.newBuilder((ListDataAccessScopesRequest)payload).setPageToken(token).build();
        }

        public ListDataAccessScopesRequest injectPageSize(ListDataAccessScopesRequest payload, int pageSize) {
            return ListDataAccessScopesRequest.newBuilder((ListDataAccessScopesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataAccessScopesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataAccessScopesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataAccessScope> extractResources(ListDataAccessScopesResponse payload) {
            return payload.getDataAccessScopesList();
        }
    };
    private static final PagedListResponseFactory<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> LIST_DATA_ACCESS_LABELS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse>(){

        public ApiFuture<DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse> callable, ListDataAccessLabelsRequest request, ApiCallContext context, ApiFuture<ListDataAccessLabelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_ACCESS_LABELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse.createAsync((PageContext<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessLabel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> LIST_DATA_ACCESS_SCOPES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse>(){

        public ApiFuture<DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataAccessScopesRequest, ListDataAccessScopesResponse> callable, ListDataAccessScopesRequest request, ApiCallContext context, ApiFuture<ListDataAccessScopesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_ACCESS_SCOPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataAccessControlServiceClient.ListDataAccessScopesPagedResponse.createAsync((PageContext<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessScope>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataAccessLabelRequest, DataAccessLabel> createDataAccessLabelSettings() {
        return this.createDataAccessLabelSettings;
    }

    public UnaryCallSettings<GetDataAccessLabelRequest, DataAccessLabel> getDataAccessLabelSettings() {
        return this.getDataAccessLabelSettings;
    }

    public PagedCallSettings<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> listDataAccessLabelsSettings() {
        return this.listDataAccessLabelsSettings;
    }

    public UnaryCallSettings<UpdateDataAccessLabelRequest, DataAccessLabel> updateDataAccessLabelSettings() {
        return this.updateDataAccessLabelSettings;
    }

    public UnaryCallSettings<DeleteDataAccessLabelRequest, Empty> deleteDataAccessLabelSettings() {
        return this.deleteDataAccessLabelSettings;
    }

    public UnaryCallSettings<CreateDataAccessScopeRequest, DataAccessScope> createDataAccessScopeSettings() {
        return this.createDataAccessScopeSettings;
    }

    public UnaryCallSettings<GetDataAccessScopeRequest, DataAccessScope> getDataAccessScopeSettings() {
        return this.getDataAccessScopeSettings;
    }

    public PagedCallSettings<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> listDataAccessScopesSettings() {
        return this.listDataAccessScopesSettings;
    }

    public UnaryCallSettings<UpdateDataAccessScopeRequest, DataAccessScope> updateDataAccessScopeSettings() {
        return this.updateDataAccessScopeSettings;
    }

    public UnaryCallSettings<DeleteDataAccessScopeRequest, Empty> deleteDataAccessScopeSettings() {
        return this.deleteDataAccessScopeSettings;
    }

    public DataAccessControlServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataAccessControlServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataAccessControlServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "chronicle";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "chronicle.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "chronicle.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataAccessControlServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataAccessControlServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataAccessControlServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataAccessControlServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataAccessControlServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataAccessLabelSettings = settingsBuilder.createDataAccessLabelSettings().build();
        this.getDataAccessLabelSettings = settingsBuilder.getDataAccessLabelSettings().build();
        this.listDataAccessLabelsSettings = settingsBuilder.listDataAccessLabelsSettings().build();
        this.updateDataAccessLabelSettings = settingsBuilder.updateDataAccessLabelSettings().build();
        this.deleteDataAccessLabelSettings = settingsBuilder.deleteDataAccessLabelSettings().build();
        this.createDataAccessScopeSettings = settingsBuilder.createDataAccessScopeSettings().build();
        this.getDataAccessScopeSettings = settingsBuilder.getDataAccessScopeSettings().build();
        this.listDataAccessScopesSettings = settingsBuilder.listDataAccessScopesSettings().build();
        this.updateDataAccessScopeSettings = settingsBuilder.updateDataAccessScopeSettings().build();
        this.deleteDataAccessScopeSettings = settingsBuilder.deleteDataAccessScopeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataAccessControlServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataAccessLabelRequest, DataAccessLabel> createDataAccessLabelSettings;
        private final UnaryCallSettings.Builder<GetDataAccessLabelRequest, DataAccessLabel> getDataAccessLabelSettings;
        private final PagedCallSettings.Builder<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> listDataAccessLabelsSettings;
        private final UnaryCallSettings.Builder<UpdateDataAccessLabelRequest, DataAccessLabel> updateDataAccessLabelSettings;
        private final UnaryCallSettings.Builder<DeleteDataAccessLabelRequest, Empty> deleteDataAccessLabelSettings;
        private final UnaryCallSettings.Builder<CreateDataAccessScopeRequest, DataAccessScope> createDataAccessScopeSettings;
        private final UnaryCallSettings.Builder<GetDataAccessScopeRequest, DataAccessScope> getDataAccessScopeSettings;
        private final PagedCallSettings.Builder<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> listDataAccessScopesSettings;
        private final UnaryCallSettings.Builder<UpdateDataAccessScopeRequest, DataAccessScope> updateDataAccessScopeSettings;
        private final UnaryCallSettings.Builder<DeleteDataAccessScopeRequest, Empty> deleteDataAccessScopeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataAccessLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDataAccessLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataAccessLabelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_ACCESS_LABELS_PAGE_STR_FACT);
            this.updateDataAccessLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataAccessLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataAccessScopeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDataAccessScopeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataAccessScopesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_ACCESS_SCOPES_PAGE_STR_FACT);
            this.updateDataAccessScopeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataAccessScopeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataAccessLabelSettings, this.getDataAccessLabelSettings, this.listDataAccessLabelsSettings, this.updateDataAccessLabelSettings, this.deleteDataAccessLabelSettings, this.createDataAccessScopeSettings, this.getDataAccessScopeSettings, this.listDataAccessScopesSettings, this.updateDataAccessScopeSettings, this.deleteDataAccessScopeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataAccessControlServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataAccessLabelSettings = settings.createDataAccessLabelSettings.toBuilder();
            this.getDataAccessLabelSettings = settings.getDataAccessLabelSettings.toBuilder();
            this.listDataAccessLabelsSettings = settings.listDataAccessLabelsSettings.toBuilder();
            this.updateDataAccessLabelSettings = settings.updateDataAccessLabelSettings.toBuilder();
            this.deleteDataAccessLabelSettings = settings.deleteDataAccessLabelSettings.toBuilder();
            this.createDataAccessScopeSettings = settings.createDataAccessScopeSettings.toBuilder();
            this.getDataAccessScopeSettings = settings.getDataAccessScopeSettings.toBuilder();
            this.listDataAccessScopesSettings = settings.listDataAccessScopesSettings.toBuilder();
            this.updateDataAccessScopeSettings = settings.updateDataAccessScopeSettings.toBuilder();
            this.deleteDataAccessScopeSettings = settings.deleteDataAccessScopeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataAccessLabelSettings, this.getDataAccessLabelSettings, this.listDataAccessLabelsSettings, this.updateDataAccessLabelSettings, this.deleteDataAccessLabelSettings, this.createDataAccessScopeSettings, this.getDataAccessScopeSettings, this.listDataAccessScopesSettings, this.updateDataAccessScopeSettings, this.deleteDataAccessScopeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataAccessControlServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataAccessControlServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataAccessControlServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataAccessControlServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataAccessControlServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataAccessControlServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataAccessControlServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataAccessControlServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataAccessLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getDataAccessLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDataAccessLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataAccessLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.deleteDataAccessLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.createDataAccessScopeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getDataAccessScopeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDataAccessScopesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataAccessScopeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.deleteDataAccessScopeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataAccessLabelRequest, DataAccessLabel> createDataAccessLabelSettings() {
            return this.createDataAccessLabelSettings;
        }

        public UnaryCallSettings.Builder<GetDataAccessLabelRequest, DataAccessLabel> getDataAccessLabelSettings() {
            return this.getDataAccessLabelSettings;
        }

        public PagedCallSettings.Builder<ListDataAccessLabelsRequest, ListDataAccessLabelsResponse, DataAccessControlServiceClient.ListDataAccessLabelsPagedResponse> listDataAccessLabelsSettings() {
            return this.listDataAccessLabelsSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataAccessLabelRequest, DataAccessLabel> updateDataAccessLabelSettings() {
            return this.updateDataAccessLabelSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataAccessLabelRequest, Empty> deleteDataAccessLabelSettings() {
            return this.deleteDataAccessLabelSettings;
        }

        public UnaryCallSettings.Builder<CreateDataAccessScopeRequest, DataAccessScope> createDataAccessScopeSettings() {
            return this.createDataAccessScopeSettings;
        }

        public UnaryCallSettings.Builder<GetDataAccessScopeRequest, DataAccessScope> getDataAccessScopeSettings() {
            return this.getDataAccessScopeSettings;
        }

        public PagedCallSettings.Builder<ListDataAccessScopesRequest, ListDataAccessScopesResponse, DataAccessControlServiceClient.ListDataAccessScopesPagedResponse> listDataAccessScopesSettings() {
            return this.listDataAccessScopesSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataAccessScopeRequest, DataAccessScope> updateDataAccessScopeSettings() {
            return this.updateDataAccessScopeSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataAccessScopeRequest, Empty> deleteDataAccessScopeSettings() {
            return this.deleteDataAccessScopeSettings;
        }

        public DataAccessControlServiceStubSettings build() throws IOException {
            return new DataAccessControlServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

