/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.chat.v1.Attachment;
import com.google.chat.v1.AttachmentName;
import com.google.chat.v1.ChatServiceSettings;
import com.google.chat.v1.CompleteImportSpaceRequest;
import com.google.chat.v1.CompleteImportSpaceResponse;
import com.google.chat.v1.CreateMembershipRequest;
import com.google.chat.v1.CreateMessageRequest;
import com.google.chat.v1.CreateReactionRequest;
import com.google.chat.v1.CreateSpaceRequest;
import com.google.chat.v1.DeleteMembershipRequest;
import com.google.chat.v1.DeleteMessageRequest;
import com.google.chat.v1.DeleteReactionRequest;
import com.google.chat.v1.DeleteSpaceRequest;
import com.google.chat.v1.FindDirectMessageRequest;
import com.google.chat.v1.GetAttachmentRequest;
import com.google.chat.v1.GetMembershipRequest;
import com.google.chat.v1.GetMessageRequest;
import com.google.chat.v1.GetSpaceEventRequest;
import com.google.chat.v1.GetSpaceReadStateRequest;
import com.google.chat.v1.GetSpaceRequest;
import com.google.chat.v1.GetThreadReadStateRequest;
import com.google.chat.v1.ListMembershipsRequest;
import com.google.chat.v1.ListMembershipsResponse;
import com.google.chat.v1.ListMessagesRequest;
import com.google.chat.v1.ListMessagesResponse;
import com.google.chat.v1.ListReactionsRequest;
import com.google.chat.v1.ListReactionsResponse;
import com.google.chat.v1.ListSpaceEventsRequest;
import com.google.chat.v1.ListSpaceEventsResponse;
import com.google.chat.v1.ListSpacesRequest;
import com.google.chat.v1.ListSpacesResponse;
import com.google.chat.v1.Membership;
import com.google.chat.v1.MembershipName;
import com.google.chat.v1.Message;
import com.google.chat.v1.MessageName;
import com.google.chat.v1.Reaction;
import com.google.chat.v1.ReactionName;
import com.google.chat.v1.SearchSpacesRequest;
import com.google.chat.v1.SearchSpacesResponse;
import com.google.chat.v1.SetUpSpaceRequest;
import com.google.chat.v1.Space;
import com.google.chat.v1.SpaceEvent;
import com.google.chat.v1.SpaceEventName;
import com.google.chat.v1.SpaceName;
import com.google.chat.v1.SpaceReadState;
import com.google.chat.v1.SpaceReadStateName;
import com.google.chat.v1.ThreadReadState;
import com.google.chat.v1.ThreadReadStateName;
import com.google.chat.v1.UpdateMembershipRequest;
import com.google.chat.v1.UpdateMessageRequest;
import com.google.chat.v1.UpdateSpaceReadStateRequest;
import com.google.chat.v1.UpdateSpaceRequest;
import com.google.chat.v1.UploadAttachmentRequest;
import com.google.chat.v1.UploadAttachmentResponse;
import com.google.chat.v1.stub.ChatServiceStub;
import com.google.chat.v1.stub.ChatServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ChatServiceClient
implements BackgroundResource {
    private final ChatServiceSettings settings;
    private final ChatServiceStub stub;

    public static final ChatServiceClient create() throws IOException {
        return ChatServiceClient.create(ChatServiceSettings.newBuilder().build());
    }

    public static final ChatServiceClient create(ChatServiceSettings settings) throws IOException {
        return new ChatServiceClient(settings);
    }

    public static final ChatServiceClient create(ChatServiceStub stub) {
        return new ChatServiceClient(stub);
    }

    protected ChatServiceClient(ChatServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ChatServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ChatServiceClient(ChatServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ChatServiceSettings getSettings() {
        return this.settings;
    }

    public ChatServiceStub getStub() {
        return this.stub;
    }

    public final Message createMessage(SpaceName parent, Message message, String messageId) {
        CreateMessageRequest request = CreateMessageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMessage(message).setMessageId(messageId).build();
        return this.createMessage(request);
    }

    public final Message createMessage(String parent, Message message, String messageId) {
        CreateMessageRequest request = CreateMessageRequest.newBuilder().setParent(parent).setMessage(message).setMessageId(messageId).build();
        return this.createMessage(request);
    }

    public final Message createMessage(CreateMessageRequest request) {
        return (Message)this.createMessageCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMessageRequest, Message> createMessageCallable() {
        return this.stub.createMessageCallable();
    }

    public final ListMessagesPagedResponse listMessages(SpaceName parent) {
        ListMessagesRequest request = ListMessagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMessages(request);
    }

    public final ListMessagesPagedResponse listMessages(String parent) {
        ListMessagesRequest request = ListMessagesRequest.newBuilder().setParent(parent).build();
        return this.listMessages(request);
    }

    public final ListMessagesPagedResponse listMessages(ListMessagesRequest request) {
        return (ListMessagesPagedResponse)((Object)this.listMessagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMessagesRequest, ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.stub.listMessagesPagedCallable();
    }

    public final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.stub.listMessagesCallable();
    }

    public final ListMembershipsPagedResponse listMemberships(SpaceName parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(String parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(ListMembershipsRequest request) {
        return (ListMembershipsPagedResponse)((Object)this.listMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.stub.listMembershipsPagedCallable();
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.stub.listMembershipsCallable();
    }

    public final Membership getMembership(MembershipName name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(String name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(GetMembershipRequest request) {
        return (Membership)this.getMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.stub.getMembershipCallable();
    }

    public final Message getMessage(MessageName name) {
        GetMessageRequest request = GetMessageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMessage(request);
    }

    public final Message getMessage(String name) {
        GetMessageRequest request = GetMessageRequest.newBuilder().setName(name).build();
        return this.getMessage(request);
    }

    public final Message getMessage(GetMessageRequest request) {
        return (Message)this.getMessageCallable().call((Object)request);
    }

    public final UnaryCallable<GetMessageRequest, Message> getMessageCallable() {
        return this.stub.getMessageCallable();
    }

    public final Message updateMessage(Message message, FieldMask updateMask) {
        UpdateMessageRequest request = UpdateMessageRequest.newBuilder().setMessage(message).setUpdateMask(updateMask).build();
        return this.updateMessage(request);
    }

    public final Message updateMessage(UpdateMessageRequest request) {
        return (Message)this.updateMessageCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateMessageRequest, Message> updateMessageCallable() {
        return this.stub.updateMessageCallable();
    }

    public final void deleteMessage(MessageName name) {
        DeleteMessageRequest request = DeleteMessageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMessage(request);
    }

    public final void deleteMessage(String name) {
        DeleteMessageRequest request = DeleteMessageRequest.newBuilder().setName(name).build();
        this.deleteMessage(request);
    }

    public final void deleteMessage(DeleteMessageRequest request) {
        this.deleteMessageCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMessageRequest, Empty> deleteMessageCallable() {
        return this.stub.deleteMessageCallable();
    }

    public final Attachment getAttachment(AttachmentName name) {
        GetAttachmentRequest request = GetAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttachment(request);
    }

    public final Attachment getAttachment(String name) {
        GetAttachmentRequest request = GetAttachmentRequest.newBuilder().setName(name).build();
        return this.getAttachment(request);
    }

    public final Attachment getAttachment(GetAttachmentRequest request) {
        return (Attachment)this.getAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttachmentRequest, Attachment> getAttachmentCallable() {
        return this.stub.getAttachmentCallable();
    }

    public final UploadAttachmentResponse uploadAttachment(UploadAttachmentRequest request) {
        return (UploadAttachmentResponse)this.uploadAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentCallable() {
        return this.stub.uploadAttachmentCallable();
    }

    public final ListSpacesPagedResponse listSpaces() {
        ListSpacesRequest request = ListSpacesRequest.newBuilder().build();
        return this.listSpaces(request);
    }

    public final ListSpacesPagedResponse listSpaces(ListSpacesRequest request) {
        return (ListSpacesPagedResponse)((Object)this.listSpacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpacesRequest, ListSpacesPagedResponse> listSpacesPagedCallable() {
        return this.stub.listSpacesPagedCallable();
    }

    public final UnaryCallable<ListSpacesRequest, ListSpacesResponse> listSpacesCallable() {
        return this.stub.listSpacesCallable();
    }

    public final SearchSpacesPagedResponse searchSpaces() {
        SearchSpacesRequest request = SearchSpacesRequest.newBuilder().build();
        return this.searchSpaces(request);
    }

    public final SearchSpacesPagedResponse searchSpaces(SearchSpacesRequest request) {
        return (SearchSpacesPagedResponse)((Object)this.searchSpacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchSpacesRequest, SearchSpacesPagedResponse> searchSpacesPagedCallable() {
        return this.stub.searchSpacesPagedCallable();
    }

    public final UnaryCallable<SearchSpacesRequest, SearchSpacesResponse> searchSpacesCallable() {
        return this.stub.searchSpacesCallable();
    }

    public final Space getSpace(SpaceName name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpace(request);
    }

    public final Space getSpace(String name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name).build();
        return this.getSpace(request);
    }

    public final Space getSpace(GetSpaceRequest request) {
        return (Space)this.getSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpaceRequest, Space> getSpaceCallable() {
        return this.stub.getSpaceCallable();
    }

    public final Space createSpace(Space space) {
        CreateSpaceRequest request = CreateSpaceRequest.newBuilder().setSpace(space).build();
        return this.createSpace(request);
    }

    public final Space createSpace(CreateSpaceRequest request) {
        return (Space)this.createSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable() {
        return this.stub.createSpaceCallable();
    }

    public final Space setUpSpace(SetUpSpaceRequest request) {
        return (Space)this.setUpSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<SetUpSpaceRequest, Space> setUpSpaceCallable() {
        return this.stub.setUpSpaceCallable();
    }

    public final Space updateSpace(Space space, FieldMask updateMask) {
        UpdateSpaceRequest request = UpdateSpaceRequest.newBuilder().setSpace(space).setUpdateMask(updateMask).build();
        return this.updateSpace(request);
    }

    public final Space updateSpace(UpdateSpaceRequest request) {
        return (Space)this.updateSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable() {
        return this.stub.updateSpaceCallable();
    }

    public final void deleteSpace(SpaceName name) {
        DeleteSpaceRequest request = DeleteSpaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSpace(request);
    }

    public final void deleteSpace(String name) {
        DeleteSpaceRequest request = DeleteSpaceRequest.newBuilder().setName(name).build();
        this.deleteSpace(request);
    }

    public final void deleteSpace(DeleteSpaceRequest request) {
        this.deleteSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSpaceRequest, Empty> deleteSpaceCallable() {
        return this.stub.deleteSpaceCallable();
    }

    public final CompleteImportSpaceResponse completeImportSpace(CompleteImportSpaceRequest request) {
        return (CompleteImportSpaceResponse)this.completeImportSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceCallable() {
        return this.stub.completeImportSpaceCallable();
    }

    public final Space findDirectMessage(FindDirectMessageRequest request) {
        return (Space)this.findDirectMessageCallable().call((Object)request);
    }

    public final UnaryCallable<FindDirectMessageRequest, Space> findDirectMessageCallable() {
        return this.stub.findDirectMessageCallable();
    }

    public final Membership createMembership(SpaceName parent, Membership membership) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMembership(membership).build();
        return this.createMembership(request);
    }

    public final Membership createMembership(String parent, Membership membership) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent).setMembership(membership).build();
        return this.createMembership(request);
    }

    public final Membership createMembership(CreateMembershipRequest request) {
        return (Membership)this.createMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMembershipRequest, Membership> createMembershipCallable() {
        return this.stub.createMembershipCallable();
    }

    public final Membership updateMembership(Membership membership, FieldMask updateMask) {
        UpdateMembershipRequest request = UpdateMembershipRequest.newBuilder().setMembership(membership).setUpdateMask(updateMask).build();
        return this.updateMembership(request);
    }

    public final Membership updateMembership(UpdateMembershipRequest request) {
        return (Membership)this.updateMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateMembershipRequest, Membership> updateMembershipCallable() {
        return this.stub.updateMembershipCallable();
    }

    public final Membership deleteMembership(MembershipName name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMembership(request);
    }

    public final Membership deleteMembership(String name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name).build();
        return this.deleteMembership(request);
    }

    public final Membership deleteMembership(DeleteMembershipRequest request) {
        return (Membership)this.deleteMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMembershipRequest, Membership> deleteMembershipCallable() {
        return this.stub.deleteMembershipCallable();
    }

    public final Reaction createReaction(MessageName parent, Reaction reaction) {
        CreateReactionRequest request = CreateReactionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReaction(reaction).build();
        return this.createReaction(request);
    }

    public final Reaction createReaction(String parent, Reaction reaction) {
        CreateReactionRequest request = CreateReactionRequest.newBuilder().setParent(parent).setReaction(reaction).build();
        return this.createReaction(request);
    }

    public final Reaction createReaction(CreateReactionRequest request) {
        return (Reaction)this.createReactionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReactionRequest, Reaction> createReactionCallable() {
        return this.stub.createReactionCallable();
    }

    public final ListReactionsPagedResponse listReactions(MessageName parent) {
        ListReactionsRequest request = ListReactionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReactions(request);
    }

    public final ListReactionsPagedResponse listReactions(String parent) {
        ListReactionsRequest request = ListReactionsRequest.newBuilder().setParent(parent).build();
        return this.listReactions(request);
    }

    public final ListReactionsPagedResponse listReactions(ListReactionsRequest request) {
        return (ListReactionsPagedResponse)((Object)this.listReactionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReactionsRequest, ListReactionsPagedResponse> listReactionsPagedCallable() {
        return this.stub.listReactionsPagedCallable();
    }

    public final UnaryCallable<ListReactionsRequest, ListReactionsResponse> listReactionsCallable() {
        return this.stub.listReactionsCallable();
    }

    public final void deleteReaction(ReactionName name) {
        DeleteReactionRequest request = DeleteReactionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteReaction(request);
    }

    public final void deleteReaction(String name) {
        DeleteReactionRequest request = DeleteReactionRequest.newBuilder().setName(name).build();
        this.deleteReaction(request);
    }

    public final void deleteReaction(DeleteReactionRequest request) {
        this.deleteReactionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReactionRequest, Empty> deleteReactionCallable() {
        return this.stub.deleteReactionCallable();
    }

    public final SpaceReadState getSpaceReadState(SpaceReadStateName name) {
        GetSpaceReadStateRequest request = GetSpaceReadStateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpaceReadState(request);
    }

    public final SpaceReadState getSpaceReadState(String name) {
        GetSpaceReadStateRequest request = GetSpaceReadStateRequest.newBuilder().setName(name).build();
        return this.getSpaceReadState(request);
    }

    public final SpaceReadState getSpaceReadState(GetSpaceReadStateRequest request) {
        return (SpaceReadState)this.getSpaceReadStateCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateCallable() {
        return this.stub.getSpaceReadStateCallable();
    }

    public final SpaceReadState updateSpaceReadState(SpaceReadState spaceReadState, FieldMask updateMask) {
        UpdateSpaceReadStateRequest request = UpdateSpaceReadStateRequest.newBuilder().setSpaceReadState(spaceReadState).setUpdateMask(updateMask).build();
        return this.updateSpaceReadState(request);
    }

    public final SpaceReadState updateSpaceReadState(UpdateSpaceReadStateRequest request) {
        return (SpaceReadState)this.updateSpaceReadStateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateCallable() {
        return this.stub.updateSpaceReadStateCallable();
    }

    public final ThreadReadState getThreadReadState(ThreadReadStateName name) {
        GetThreadReadStateRequest request = GetThreadReadStateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getThreadReadState(request);
    }

    public final ThreadReadState getThreadReadState(String name) {
        GetThreadReadStateRequest request = GetThreadReadStateRequest.newBuilder().setName(name).build();
        return this.getThreadReadState(request);
    }

    public final ThreadReadState getThreadReadState(GetThreadReadStateRequest request) {
        return (ThreadReadState)this.getThreadReadStateCallable().call((Object)request);
    }

    public final UnaryCallable<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateCallable() {
        return this.stub.getThreadReadStateCallable();
    }

    public final SpaceEvent getSpaceEvent(SpaceEventName name) {
        GetSpaceEventRequest request = GetSpaceEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpaceEvent(request);
    }

    public final SpaceEvent getSpaceEvent(String name) {
        GetSpaceEventRequest request = GetSpaceEventRequest.newBuilder().setName(name).build();
        return this.getSpaceEvent(request);
    }

    public final SpaceEvent getSpaceEvent(GetSpaceEventRequest request) {
        return (SpaceEvent)this.getSpaceEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpaceEventRequest, SpaceEvent> getSpaceEventCallable() {
        return this.stub.getSpaceEventCallable();
    }

    public final ListSpaceEventsPagedResponse listSpaceEvents(SpaceName parent, String filter) {
        ListSpaceEventsRequest request = ListSpaceEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listSpaceEvents(request);
    }

    public final ListSpaceEventsPagedResponse listSpaceEvents(String parent, String filter) {
        ListSpaceEventsRequest request = ListSpaceEventsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listSpaceEvents(request);
    }

    public final ListSpaceEventsPagedResponse listSpaceEvents(ListSpaceEventsRequest request) {
        return (ListSpaceEventsPagedResponse)((Object)this.listSpaceEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpaceEventsRequest, ListSpaceEventsPagedResponse> listSpaceEventsPagedCallable() {
        return this.stub.listSpaceEventsPagedCallable();
    }

    public final UnaryCallable<ListSpaceEventsRequest, ListSpaceEventsResponse> listSpaceEventsCallable() {
        return this.stub.listSpaceEventsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSpaceEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent, ListSpaceEventsPage, ListSpaceEventsFixedSizeCollection> {
        private ListSpaceEventsFixedSizeCollection(List<ListSpaceEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpaceEventsFixedSizeCollection createEmptyCollection() {
            return new ListSpaceEventsFixedSizeCollection(null, 0);
        }

        protected ListSpaceEventsFixedSizeCollection createCollection(List<ListSpaceEventsPage> pages, int collectionSize) {
            return new ListSpaceEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpaceEventsPage
    extends AbstractPage<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent, ListSpaceEventsPage> {
        private ListSpaceEventsPage(PageContext<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent> context, ListSpaceEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListSpaceEventsPage createEmptyPage() {
            return new ListSpaceEventsPage(null, null);
        }

        protected ListSpaceEventsPage createPage(PageContext<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent> context, ListSpaceEventsResponse response) {
            return new ListSpaceEventsPage(context, response);
        }

        public ApiFuture<ListSpaceEventsPage> createPageAsync(PageContext<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent> context, ApiFuture<ListSpaceEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpaceEventsPagedResponse
    extends AbstractPagedListResponse<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent, ListSpaceEventsPage, ListSpaceEventsFixedSizeCollection> {
        public static ApiFuture<ListSpaceEventsPagedResponse> createAsync(PageContext<ListSpaceEventsRequest, ListSpaceEventsResponse, SpaceEvent> context, ApiFuture<ListSpaceEventsResponse> futureResponse) {
            ApiFuture<ListSpaceEventsPage> futurePage = ListSpaceEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpaceEventsPagedResponse((ListSpaceEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpaceEventsPagedResponse(ListSpaceEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpaceEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReactionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReactionsRequest, ListReactionsResponse, Reaction, ListReactionsPage, ListReactionsFixedSizeCollection> {
        private ListReactionsFixedSizeCollection(List<ListReactionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReactionsFixedSizeCollection createEmptyCollection() {
            return new ListReactionsFixedSizeCollection(null, 0);
        }

        protected ListReactionsFixedSizeCollection createCollection(List<ListReactionsPage> pages, int collectionSize) {
            return new ListReactionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReactionsPage
    extends AbstractPage<ListReactionsRequest, ListReactionsResponse, Reaction, ListReactionsPage> {
        private ListReactionsPage(PageContext<ListReactionsRequest, ListReactionsResponse, Reaction> context, ListReactionsResponse response) {
            super(context, (Object)response);
        }

        private static ListReactionsPage createEmptyPage() {
            return new ListReactionsPage(null, null);
        }

        protected ListReactionsPage createPage(PageContext<ListReactionsRequest, ListReactionsResponse, Reaction> context, ListReactionsResponse response) {
            return new ListReactionsPage(context, response);
        }

        public ApiFuture<ListReactionsPage> createPageAsync(PageContext<ListReactionsRequest, ListReactionsResponse, Reaction> context, ApiFuture<ListReactionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReactionsPagedResponse
    extends AbstractPagedListResponse<ListReactionsRequest, ListReactionsResponse, Reaction, ListReactionsPage, ListReactionsFixedSizeCollection> {
        public static ApiFuture<ListReactionsPagedResponse> createAsync(PageContext<ListReactionsRequest, ListReactionsResponse, Reaction> context, ApiFuture<ListReactionsResponse> futureResponse) {
            ApiFuture<ListReactionsPage> futurePage = ListReactionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReactionsPagedResponse((ListReactionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReactionsPagedResponse(ListReactionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReactionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchSpacesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchSpacesRequest, SearchSpacesResponse, Space, SearchSpacesPage, SearchSpacesFixedSizeCollection> {
        private SearchSpacesFixedSizeCollection(List<SearchSpacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchSpacesFixedSizeCollection createEmptyCollection() {
            return new SearchSpacesFixedSizeCollection(null, 0);
        }

        protected SearchSpacesFixedSizeCollection createCollection(List<SearchSpacesPage> pages, int collectionSize) {
            return new SearchSpacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchSpacesPage
    extends AbstractPage<SearchSpacesRequest, SearchSpacesResponse, Space, SearchSpacesPage> {
        private SearchSpacesPage(PageContext<SearchSpacesRequest, SearchSpacesResponse, Space> context, SearchSpacesResponse response) {
            super(context, (Object)response);
        }

        private static SearchSpacesPage createEmptyPage() {
            return new SearchSpacesPage(null, null);
        }

        protected SearchSpacesPage createPage(PageContext<SearchSpacesRequest, SearchSpacesResponse, Space> context, SearchSpacesResponse response) {
            return new SearchSpacesPage(context, response);
        }

        public ApiFuture<SearchSpacesPage> createPageAsync(PageContext<SearchSpacesRequest, SearchSpacesResponse, Space> context, ApiFuture<SearchSpacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchSpacesPagedResponse
    extends AbstractPagedListResponse<SearchSpacesRequest, SearchSpacesResponse, Space, SearchSpacesPage, SearchSpacesFixedSizeCollection> {
        public static ApiFuture<SearchSpacesPagedResponse> createAsync(PageContext<SearchSpacesRequest, SearchSpacesResponse, Space> context, ApiFuture<SearchSpacesResponse> futureResponse) {
            ApiFuture<SearchSpacesPage> futurePage = SearchSpacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchSpacesPagedResponse((SearchSpacesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchSpacesPagedResponse(SearchSpacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchSpacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSpacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpacesRequest, ListSpacesResponse, Space, ListSpacesPage, ListSpacesFixedSizeCollection> {
        private ListSpacesFixedSizeCollection(List<ListSpacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpacesFixedSizeCollection createEmptyCollection() {
            return new ListSpacesFixedSizeCollection(null, 0);
        }

        protected ListSpacesFixedSizeCollection createCollection(List<ListSpacesPage> pages, int collectionSize) {
            return new ListSpacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpacesPage
    extends AbstractPage<ListSpacesRequest, ListSpacesResponse, Space, ListSpacesPage> {
        private ListSpacesPage(PageContext<ListSpacesRequest, ListSpacesResponse, Space> context, ListSpacesResponse response) {
            super(context, (Object)response);
        }

        private static ListSpacesPage createEmptyPage() {
            return new ListSpacesPage(null, null);
        }

        protected ListSpacesPage createPage(PageContext<ListSpacesRequest, ListSpacesResponse, Space> context, ListSpacesResponse response) {
            return new ListSpacesPage(context, response);
        }

        public ApiFuture<ListSpacesPage> createPageAsync(PageContext<ListSpacesRequest, ListSpacesResponse, Space> context, ApiFuture<ListSpacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpacesPagedResponse
    extends AbstractPagedListResponse<ListSpacesRequest, ListSpacesResponse, Space, ListSpacesPage, ListSpacesFixedSizeCollection> {
        public static ApiFuture<ListSpacesPagedResponse> createAsync(PageContext<ListSpacesRequest, ListSpacesResponse, Space> context, ApiFuture<ListSpacesResponse> futureResponse) {
            ApiFuture<ListSpacesPage> futurePage = ListSpacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpacesPagedResponse((ListSpacesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpacesPagedResponse(ListSpacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        private ListMembershipsFixedSizeCollection(List<ListMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMembershipsFixedSizeCollection createEmptyCollection() {
            return new ListMembershipsFixedSizeCollection(null, 0);
        }

        protected ListMembershipsFixedSizeCollection createCollection(List<ListMembershipsPage> pages, int collectionSize) {
            return new ListMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMembershipsPage
    extends AbstractPage<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage> {
        private ListMembershipsPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static ListMembershipsPage createEmptyPage() {
            return new ListMembershipsPage(null, null);
        }

        protected ListMembershipsPage createPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            return new ListMembershipsPage(context, response);
        }

        public ApiFuture<ListMembershipsPage> createPageAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMembershipsPagedResponse
    extends AbstractPagedListResponse<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        public static ApiFuture<ListMembershipsPagedResponse> createAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            ApiFuture<ListMembershipsPage> futurePage = ListMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMembershipsPagedResponse((ListMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMembershipsPagedResponse(ListMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMessagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage, ListMessagesFixedSizeCollection> {
        private ListMessagesFixedSizeCollection(List<ListMessagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMessagesFixedSizeCollection createEmptyCollection() {
            return new ListMessagesFixedSizeCollection(null, 0);
        }

        protected ListMessagesFixedSizeCollection createCollection(List<ListMessagesPage> pages, int collectionSize) {
            return new ListMessagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMessagesPage
    extends AbstractPage<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage> {
        private ListMessagesPage(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ListMessagesResponse response) {
            super(context, (Object)response);
        }

        private static ListMessagesPage createEmptyPage() {
            return new ListMessagesPage(null, null);
        }

        protected ListMessagesPage createPage(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ListMessagesResponse response) {
            return new ListMessagesPage(context, response);
        }

        public ApiFuture<ListMessagesPage> createPageAsync(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ApiFuture<ListMessagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMessagesPagedResponse
    extends AbstractPagedListResponse<ListMessagesRequest, ListMessagesResponse, Message, ListMessagesPage, ListMessagesFixedSizeCollection> {
        public static ApiFuture<ListMessagesPagedResponse> createAsync(PageContext<ListMessagesRequest, ListMessagesResponse, Message> context, ApiFuture<ListMessagesResponse> futureResponse) {
            ApiFuture<ListMessagesPage> futurePage = ListMessagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMessagesPagedResponse((ListMessagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMessagesPagedResponse(ListMessagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMessagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

