/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.capacityplanner.v1beta;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageRequest;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageResponse;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.LocationName;
import com.google.cloud.capacityplanner.v1beta.OperationMetadata;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.UsageServiceSettings;
import com.google.cloud.capacityplanner.v1beta.stub.UsageServiceStub;
import com.google.cloud.capacityplanner.v1beta.stub.UsageServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class UsageServiceClient
implements BackgroundResource {
    private final UsageServiceSettings settings;
    private final UsageServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final UsageServiceClient create() throws IOException {
        return UsageServiceClient.create(UsageServiceSettings.newBuilder().build());
    }

    public static final UsageServiceClient create(UsageServiceSettings settings) throws IOException {
        return new UsageServiceClient(settings);
    }

    public static final UsageServiceClient create(UsageServiceStub stub) {
        return new UsageServiceClient(stub);
    }

    protected UsageServiceClient(UsageServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UsageServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected UsageServiceClient(UsageServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final UsageServiceSettings getSettings() {
        return this.settings;
    }

    public UsageServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final QueryUsageHistoriesResponse queryUsageHistories(QueryUsageHistoriesRequest request) {
        return (QueryUsageHistoriesResponse)this.queryUsageHistoriesCallable().call((Object)request);
    }

    public final UnaryCallable<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesCallable() {
        return this.stub.queryUsageHistoriesCallable();
    }

    public final QueryForecastsResponse queryForecasts(QueryForecastsRequest request) {
        return (QueryForecastsResponse)this.queryForecastsCallable().call((Object)request);
    }

    public final UnaryCallable<QueryForecastsRequest, QueryForecastsResponse> queryForecastsCallable() {
        return this.stub.queryForecastsCallable();
    }

    public final QueryReservationsResponse queryReservations(LocationName parent) {
        QueryReservationsRequest request = QueryReservationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.queryReservations(request);
    }

    public final QueryReservationsResponse queryReservations(String parent) {
        QueryReservationsRequest request = QueryReservationsRequest.newBuilder().setParent(parent).build();
        return this.queryReservations(request);
    }

    public final QueryReservationsResponse queryReservations(QueryReservationsRequest request) {
        return (QueryReservationsResponse)this.queryReservationsCallable().call((Object)request);
    }

    public final UnaryCallable<QueryReservationsRequest, QueryReservationsResponse> queryReservationsCallable() {
        return this.stub.queryReservationsCallable();
    }

    public final OperationFuture<ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesAsync(ExportUsageHistoriesRequest request) {
        return this.exportUsageHistoriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationCallable() {
        return this.stub.exportUsageHistoriesOperationCallable();
    }

    public final UnaryCallable<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesCallable() {
        return this.stub.exportUsageHistoriesCallable();
    }

    public final OperationFuture<ExportForecastsResponse, OperationMetadata> exportForecastsAsync(ExportForecastsRequest request) {
        return this.exportForecastsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationCallable() {
        return this.stub.exportForecastsOperationCallable();
    }

    public final UnaryCallable<ExportForecastsRequest, Operation> exportForecastsCallable() {
        return this.stub.exportForecastsCallable();
    }

    public final OperationFuture<ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageAsync(ExportReservationsUsageRequest request) {
        return this.exportReservationsUsageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationCallable() {
        return this.stub.exportReservationsUsageOperationCallable();
    }

    public final UnaryCallable<ExportReservationsUsageRequest, Operation> exportReservationsUsageCallable() {
        return this.stub.exportReservationsUsageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

