/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v2.RepositoryManagerSettings;
import com.google.cloud.devtools.cloudbuild.v2.stub.RepositoryManagerStub;
import com.google.cloud.devtools.cloudbuild.v2.stub.RepositoryManagerStubSettings;
import com.google.cloudbuild.v2.BatchCreateRepositoriesRequest;
import com.google.cloudbuild.v2.BatchCreateRepositoriesResponse;
import com.google.cloudbuild.v2.Connection;
import com.google.cloudbuild.v2.ConnectionName;
import com.google.cloudbuild.v2.CreateConnectionRequest;
import com.google.cloudbuild.v2.CreateRepositoryRequest;
import com.google.cloudbuild.v2.DeleteConnectionRequest;
import com.google.cloudbuild.v2.DeleteRepositoryRequest;
import com.google.cloudbuild.v2.FetchGitRefsRequest;
import com.google.cloudbuild.v2.FetchGitRefsResponse;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesRequest;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesResponse;
import com.google.cloudbuild.v2.FetchReadTokenRequest;
import com.google.cloudbuild.v2.FetchReadTokenResponse;
import com.google.cloudbuild.v2.FetchReadWriteTokenRequest;
import com.google.cloudbuild.v2.FetchReadWriteTokenResponse;
import com.google.cloudbuild.v2.GetConnectionRequest;
import com.google.cloudbuild.v2.GetRepositoryRequest;
import com.google.cloudbuild.v2.ListConnectionsRequest;
import com.google.cloudbuild.v2.ListConnectionsResponse;
import com.google.cloudbuild.v2.ListRepositoriesRequest;
import com.google.cloudbuild.v2.ListRepositoriesResponse;
import com.google.cloudbuild.v2.LocationName;
import com.google.cloudbuild.v2.OperationMetadata;
import com.google.cloudbuild.v2.Repository;
import com.google.cloudbuild.v2.RepositoryName;
import com.google.cloudbuild.v2.UpdateConnectionRequest;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RepositoryManagerClient
implements BackgroundResource {
    private final RepositoryManagerSettings settings;
    private final RepositoryManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final RepositoryManagerClient create() throws IOException {
        return RepositoryManagerClient.create(RepositoryManagerSettings.newBuilder().build());
    }

    public static final RepositoryManagerClient create(RepositoryManagerSettings settings) throws IOException {
        return new RepositoryManagerClient(settings);
    }

    public static final RepositoryManagerClient create(RepositoryManagerStub stub) {
        return new RepositoryManagerClient(stub);
    }

    protected RepositoryManagerClient(RepositoryManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RepositoryManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected RepositoryManagerClient(RepositoryManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final RepositoryManagerSettings getSettings() {
        return this.settings;
    }

    public RepositoryManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(LocationName parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(String parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.stub.createConnectionOperationCallable();
    }

    public final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.stub.createConnectionCallable();
    }

    public final Connection getConnection(ConnectionName name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(String name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(GetConnectionRequest request) {
        return (Connection)this.getConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.stub.getConnectionCallable();
    }

    public final ListConnectionsPagedResponse listConnections(LocationName parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(String parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsPagedResponse)((Object)this.listConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.stub.listConnectionsPagedCallable();
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final OperationFuture<Connection, OperationMetadata> updateConnectionAsync(Connection connection, FieldMask updateMask) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> updateConnectionAsync(UpdateConnectionRequest request) {
        return this.updateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.stub.updateConnectionOperationCallable();
    }

    public final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.stub.updateConnectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(ConnectionName name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(String name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name).build();
        return this.deleteConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.stub.deleteConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.stub.deleteConnectionCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(ConnectionName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.stub.createRepositoryOperationCallable();
    }

    public final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final OperationFuture<BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesAsync(ConnectionName parent, List<CreateRepositoryRequest> requests) {
        BatchCreateRepositoriesRequest request = BatchCreateRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateRepositoriesAsync(request);
    }

    public final OperationFuture<BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesAsync(String parent, List<CreateRepositoryRequest> requests) {
        BatchCreateRepositoriesRequest request = BatchCreateRepositoriesRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateRepositoriesAsync(request);
    }

    public final OperationFuture<BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesAsync(BatchCreateRepositoriesRequest request) {
        return this.batchCreateRepositoriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationCallable() {
        return this.stub.batchCreateRepositoriesOperationCallable();
    }

    public final UnaryCallable<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesCallable() {
        return this.stub.batchCreateRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(ConnectionName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.stub.deleteRepositoryOperationCallable();
    }

    public final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(RepositoryName repository) {
        FetchReadWriteTokenRequest request = FetchReadWriteTokenRequest.newBuilder().setRepository(repository == null ? null : repository.toString()).build();
        return this.fetchReadWriteToken(request);
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(String repository) {
        FetchReadWriteTokenRequest request = FetchReadWriteTokenRequest.newBuilder().setRepository(repository).build();
        return this.fetchReadWriteToken(request);
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(FetchReadWriteTokenRequest request) {
        return (FetchReadWriteTokenResponse)this.fetchReadWriteTokenCallable().call((Object)request);
    }

    public final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.stub.fetchReadWriteTokenCallable();
    }

    public final FetchReadTokenResponse fetchReadToken(RepositoryName repository) {
        FetchReadTokenRequest request = FetchReadTokenRequest.newBuilder().setRepository(repository == null ? null : repository.toString()).build();
        return this.fetchReadToken(request);
    }

    public final FetchReadTokenResponse fetchReadToken(String repository) {
        FetchReadTokenRequest request = FetchReadTokenRequest.newBuilder().setRepository(repository).build();
        return this.fetchReadToken(request);
    }

    public final FetchReadTokenResponse fetchReadToken(FetchReadTokenRequest request) {
        return (FetchReadTokenResponse)this.fetchReadTokenCallable().call((Object)request);
    }

    public final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.stub.fetchReadTokenCallable();
    }

    public final FetchLinkableRepositoriesPagedResponse fetchLinkableRepositories(FetchLinkableRepositoriesRequest request) {
        return (FetchLinkableRepositoriesPagedResponse)((Object)this.fetchLinkableRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesPagedCallable() {
        return this.stub.fetchLinkableRepositoriesPagedCallable();
    }

    public final UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesCallable() {
        return this.stub.fetchLinkableRepositoriesCallable();
    }

    public final FetchGitRefsResponse fetchGitRefs(RepositoryName repository) {
        FetchGitRefsRequest request = FetchGitRefsRequest.newBuilder().setRepository(repository == null ? null : repository.toString()).build();
        return this.fetchGitRefs(request);
    }

    public final FetchGitRefsResponse fetchGitRefs(String repository) {
        FetchGitRefsRequest request = FetchGitRefsRequest.newBuilder().setRepository(repository).build();
        return this.fetchGitRefs(request);
    }

    public final FetchGitRefsResponse fetchGitRefs(FetchGitRefsRequest request) {
        return (FetchGitRefsResponse)this.fetchGitRefsCallable().call((Object)request);
    }

    public final UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable() {
        return this.stub.fetchGitRefsCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class FetchLinkableRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository, FetchLinkableRepositoriesPage, FetchLinkableRepositoriesFixedSizeCollection> {
        private FetchLinkableRepositoriesFixedSizeCollection(List<FetchLinkableRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchLinkableRepositoriesFixedSizeCollection createEmptyCollection() {
            return new FetchLinkableRepositoriesFixedSizeCollection(null, 0);
        }

        protected FetchLinkableRepositoriesFixedSizeCollection createCollection(List<FetchLinkableRepositoriesPage> pages, int collectionSize) {
            return new FetchLinkableRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchLinkableRepositoriesPage
    extends AbstractPage<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository, FetchLinkableRepositoriesPage> {
        private FetchLinkableRepositoriesPage(PageContext<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository> context, FetchLinkableRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static FetchLinkableRepositoriesPage createEmptyPage() {
            return new FetchLinkableRepositoriesPage(null, null);
        }

        protected FetchLinkableRepositoriesPage createPage(PageContext<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository> context, FetchLinkableRepositoriesResponse response) {
            return new FetchLinkableRepositoriesPage(context, response);
        }

        public ApiFuture<FetchLinkableRepositoriesPage> createPageAsync(PageContext<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository> context, ApiFuture<FetchLinkableRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchLinkableRepositoriesPagedResponse
    extends AbstractPagedListResponse<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository, FetchLinkableRepositoriesPage, FetchLinkableRepositoriesFixedSizeCollection> {
        public static ApiFuture<FetchLinkableRepositoriesPagedResponse> createAsync(PageContext<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository> context, ApiFuture<FetchLinkableRepositoriesResponse> futureResponse) {
            ApiFuture<FetchLinkableRepositoriesPage> futurePage = FetchLinkableRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchLinkableRepositoriesPagedResponse((FetchLinkableRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchLinkableRepositoriesPagedResponse(FetchLinkableRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchLinkableRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        private ListConnectionsFixedSizeCollection(List<ListConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListConnectionsFixedSizeCollection(null, 0);
        }

        protected ListConnectionsFixedSizeCollection createCollection(List<ListConnectionsPage> pages, int collectionSize) {
            return new ListConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionsPage
    extends AbstractPage<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage> {
        private ListConnectionsPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionsPage createEmptyPage() {
            return new ListConnectionsPage(null, null);
        }

        protected ListConnectionsPage createPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            return new ListConnectionsPage(context, response);
        }

        public ApiFuture<ListConnectionsPage> createPageAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionsPagedResponse
    extends AbstractPagedListResponse<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        public static ApiFuture<ListConnectionsPagedResponse> createAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            ApiFuture<ListConnectionsPage> futurePage = ListConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectionsPagedResponse((ListConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionsPagedResponse(ListConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

