/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v1.CloudBuildClient;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.GrpcCloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.HttpJsonCloudBuildStub;
import com.google.cloudbuild.v1.ApproveBuildRequest;
import com.google.cloudbuild.v1.Build;
import com.google.cloudbuild.v1.BuildOperationMetadata;
import com.google.cloudbuild.v1.BuildTrigger;
import com.google.cloudbuild.v1.CancelBuildRequest;
import com.google.cloudbuild.v1.CreateBuildRequest;
import com.google.cloudbuild.v1.CreateBuildTriggerRequest;
import com.google.cloudbuild.v1.CreateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.CreateWorkerPoolRequest;
import com.google.cloudbuild.v1.DeleteBuildTriggerRequest;
import com.google.cloudbuild.v1.DeleteWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.DeleteWorkerPoolRequest;
import com.google.cloudbuild.v1.GetBuildRequest;
import com.google.cloudbuild.v1.GetBuildTriggerRequest;
import com.google.cloudbuild.v1.GetWorkerPoolRequest;
import com.google.cloudbuild.v1.ListBuildTriggersRequest;
import com.google.cloudbuild.v1.ListBuildTriggersResponse;
import com.google.cloudbuild.v1.ListBuildsRequest;
import com.google.cloudbuild.v1.ListBuildsResponse;
import com.google.cloudbuild.v1.ListWorkerPoolsRequest;
import com.google.cloudbuild.v1.ListWorkerPoolsResponse;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookRequest;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookResponse;
import com.google.cloudbuild.v1.RetryBuildRequest;
import com.google.cloudbuild.v1.RunBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.UpdateWorkerPoolRequest;
import com.google.cloudbuild.v1.WorkerPool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudBuildStubSettings
extends StubSettings<CloudBuildStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateBuildRequest, Operation> createBuildSettings;
    private final OperationCallSettings<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationSettings;
    private final UnaryCallSettings<GetBuildRequest, Build> getBuildSettings;
    private final PagedCallSettings<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings;
    private final UnaryCallSettings<CancelBuildRequest, Build> cancelBuildSettings;
    private final UnaryCallSettings<RetryBuildRequest, Operation> retryBuildSettings;
    private final OperationCallSettings<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationSettings;
    private final UnaryCallSettings<ApproveBuildRequest, Operation> approveBuildSettings;
    private final OperationCallSettings<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationSettings;
    private final UnaryCallSettings<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings;
    private final UnaryCallSettings<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings;
    private final PagedCallSettings<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersSettings;
    private final UnaryCallSettings<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings;
    private final UnaryCallSettings<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings;
    private final UnaryCallSettings<RunBuildTriggerRequest, Operation> runBuildTriggerSettings;
    private final OperationCallSettings<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationSettings;
    private final UnaryCallSettings<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookSettings;
    private final UnaryCallSettings<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings;
    private final OperationCallSettings<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationSettings;
    private final UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
    private final UnaryCallSettings<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings;
    private final OperationCallSettings<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationSettings;
    private final UnaryCallSettings<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings;
    private final OperationCallSettings<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationSettings;
    private final PagedCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings;
    private static final PagedListDescriptor<ListBuildsRequest, ListBuildsResponse, Build> LIST_BUILDS_PAGE_STR_DESC = new PagedListDescriptor<ListBuildsRequest, ListBuildsResponse, Build>(){

        public String emptyToken() {
            return "";
        }

        public ListBuildsRequest injectToken(ListBuildsRequest payload, String token) {
            return ListBuildsRequest.newBuilder((ListBuildsRequest)payload).setPageToken(token).build();
        }

        public ListBuildsRequest injectPageSize(ListBuildsRequest payload, int pageSize) {
            return ListBuildsRequest.newBuilder((ListBuildsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBuildsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBuildsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Build> extractResources(ListBuildsResponse payload) {
            return payload.getBuildsList() == null ? ImmutableList.of() : payload.getBuildsList();
        }
    };
    private static final PagedListDescriptor<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger> LIST_BUILD_TRIGGERS_PAGE_STR_DESC = new PagedListDescriptor<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger>(){

        public String emptyToken() {
            return "";
        }

        public ListBuildTriggersRequest injectToken(ListBuildTriggersRequest payload, String token) {
            return ListBuildTriggersRequest.newBuilder((ListBuildTriggersRequest)payload).setPageToken(token).build();
        }

        public ListBuildTriggersRequest injectPageSize(ListBuildTriggersRequest payload, int pageSize) {
            return ListBuildTriggersRequest.newBuilder((ListBuildTriggersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBuildTriggersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBuildTriggersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BuildTrigger> extractResources(ListBuildTriggersResponse payload) {
            return payload.getTriggersList() == null ? ImmutableList.of() : payload.getTriggersList();
        }
    };
    private static final PagedListDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> LIST_WORKER_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkerPoolsRequest injectToken(ListWorkerPoolsRequest payload, String token) {
            return ListWorkerPoolsRequest.newBuilder((ListWorkerPoolsRequest)payload).setPageToken(token).build();
        }

        public ListWorkerPoolsRequest injectPageSize(ListWorkerPoolsRequest payload, int pageSize) {
            return ListWorkerPoolsRequest.newBuilder((ListWorkerPoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkerPoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkerPoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkerPool> extractResources(ListWorkerPoolsResponse payload) {
            return payload.getWorkerPoolsList() == null ? ImmutableList.of() : payload.getWorkerPoolsList();
        }
    };
    private static final PagedListResponseFactory<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> LIST_BUILDS_PAGE_STR_FACT = new PagedListResponseFactory<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse>(){

        public ApiFuture<CloudBuildClient.ListBuildsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBuildsRequest, ListBuildsResponse> callable, ListBuildsRequest request, ApiCallContext context, ApiFuture<ListBuildsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUILDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBuildClient.ListBuildsPagedResponse.createAsync((PageContext<ListBuildsRequest, ListBuildsResponse, Build>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse> LIST_BUILD_TRIGGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse>(){

        public ApiFuture<CloudBuildClient.ListBuildTriggersPagedResponse> getFuturePagedResponse(UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersResponse> callable, ListBuildTriggersRequest request, ApiCallContext context, ApiFuture<ListBuildTriggersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUILD_TRIGGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBuildClient.ListBuildTriggersPagedResponse.createAsync((PageContext<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse> LIST_WORKER_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse>(){

        public ApiFuture<CloudBuildClient.ListWorkerPoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> callable, ListWorkerPoolsRequest request, ApiCallContext context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKER_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudBuildClient.ListWorkerPoolsPagedResponse.createAsync((PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateBuildRequest, Operation> createBuildSettings() {
        return this.createBuildSettings;
    }

    public OperationCallSettings<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationSettings() {
        return this.createBuildOperationSettings;
    }

    public UnaryCallSettings<GetBuildRequest, Build> getBuildSettings() {
        return this.getBuildSettings;
    }

    public PagedCallSettings<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings() {
        return this.listBuildsSettings;
    }

    public UnaryCallSettings<CancelBuildRequest, Build> cancelBuildSettings() {
        return this.cancelBuildSettings;
    }

    public UnaryCallSettings<RetryBuildRequest, Operation> retryBuildSettings() {
        return this.retryBuildSettings;
    }

    public OperationCallSettings<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationSettings() {
        return this.retryBuildOperationSettings;
    }

    public UnaryCallSettings<ApproveBuildRequest, Operation> approveBuildSettings() {
        return this.approveBuildSettings;
    }

    public OperationCallSettings<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationSettings() {
        return this.approveBuildOperationSettings;
    }

    public UnaryCallSettings<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings() {
        return this.createBuildTriggerSettings;
    }

    public UnaryCallSettings<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings() {
        return this.getBuildTriggerSettings;
    }

    public PagedCallSettings<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersSettings() {
        return this.listBuildTriggersSettings;
    }

    public UnaryCallSettings<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings() {
        return this.deleteBuildTriggerSettings;
    }

    public UnaryCallSettings<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings() {
        return this.updateBuildTriggerSettings;
    }

    public UnaryCallSettings<RunBuildTriggerRequest, Operation> runBuildTriggerSettings() {
        return this.runBuildTriggerSettings;
    }

    public OperationCallSettings<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationSettings() {
        return this.runBuildTriggerOperationSettings;
    }

    public UnaryCallSettings<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookSettings() {
        return this.receiveTriggerWebhookSettings;
    }

    public UnaryCallSettings<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings() {
        return this.createWorkerPoolSettings;
    }

    public OperationCallSettings<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationSettings() {
        return this.createWorkerPoolOperationSettings;
    }

    public UnaryCallSettings<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
        return this.getWorkerPoolSettings;
    }

    public UnaryCallSettings<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings() {
        return this.deleteWorkerPoolSettings;
    }

    public OperationCallSettings<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationSettings() {
        return this.deleteWorkerPoolOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings() {
        return this.updateWorkerPoolSettings;
    }

    public OperationCallSettings<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationSettings() {
        return this.updateWorkerPoolOperationSettings;
    }

    public PagedCallSettings<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings() {
        return this.listWorkerPoolsSettings;
    }

    public CloudBuildStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudBuildStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudBuildStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudbuild.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudbuild.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudBuildStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudBuildStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudBuildStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudBuildStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudBuildStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createBuildSettings = settingsBuilder.createBuildSettings().build();
        this.createBuildOperationSettings = settingsBuilder.createBuildOperationSettings().build();
        this.getBuildSettings = settingsBuilder.getBuildSettings().build();
        this.listBuildsSettings = settingsBuilder.listBuildsSettings().build();
        this.cancelBuildSettings = settingsBuilder.cancelBuildSettings().build();
        this.retryBuildSettings = settingsBuilder.retryBuildSettings().build();
        this.retryBuildOperationSettings = settingsBuilder.retryBuildOperationSettings().build();
        this.approveBuildSettings = settingsBuilder.approveBuildSettings().build();
        this.approveBuildOperationSettings = settingsBuilder.approveBuildOperationSettings().build();
        this.createBuildTriggerSettings = settingsBuilder.createBuildTriggerSettings().build();
        this.getBuildTriggerSettings = settingsBuilder.getBuildTriggerSettings().build();
        this.listBuildTriggersSettings = settingsBuilder.listBuildTriggersSettings().build();
        this.deleteBuildTriggerSettings = settingsBuilder.deleteBuildTriggerSettings().build();
        this.updateBuildTriggerSettings = settingsBuilder.updateBuildTriggerSettings().build();
        this.runBuildTriggerSettings = settingsBuilder.runBuildTriggerSettings().build();
        this.runBuildTriggerOperationSettings = settingsBuilder.runBuildTriggerOperationSettings().build();
        this.receiveTriggerWebhookSettings = settingsBuilder.receiveTriggerWebhookSettings().build();
        this.createWorkerPoolSettings = settingsBuilder.createWorkerPoolSettings().build();
        this.createWorkerPoolOperationSettings = settingsBuilder.createWorkerPoolOperationSettings().build();
        this.getWorkerPoolSettings = settingsBuilder.getWorkerPoolSettings().build();
        this.deleteWorkerPoolSettings = settingsBuilder.deleteWorkerPoolSettings().build();
        this.deleteWorkerPoolOperationSettings = settingsBuilder.deleteWorkerPoolOperationSettings().build();
        this.updateWorkerPoolSettings = settingsBuilder.updateWorkerPoolSettings().build();
        this.updateWorkerPoolOperationSettings = settingsBuilder.updateWorkerPoolOperationSettings().build();
        this.listWorkerPoolsSettings = settingsBuilder.listWorkerPoolsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudBuildStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateBuildRequest, Operation> createBuildSettings;
        private final OperationCallSettings.Builder<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationSettings;
        private final UnaryCallSettings.Builder<GetBuildRequest, Build> getBuildSettings;
        private final PagedCallSettings.Builder<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings;
        private final UnaryCallSettings.Builder<CancelBuildRequest, Build> cancelBuildSettings;
        private final UnaryCallSettings.Builder<RetryBuildRequest, Operation> retryBuildSettings;
        private final OperationCallSettings.Builder<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationSettings;
        private final UnaryCallSettings.Builder<ApproveBuildRequest, Operation> approveBuildSettings;
        private final OperationCallSettings.Builder<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationSettings;
        private final UnaryCallSettings.Builder<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings;
        private final UnaryCallSettings.Builder<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings;
        private final PagedCallSettings.Builder<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersSettings;
        private final UnaryCallSettings.Builder<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings;
        private final UnaryCallSettings.Builder<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings;
        private final UnaryCallSettings.Builder<RunBuildTriggerRequest, Operation> runBuildTriggerSettings;
        private final OperationCallSettings.Builder<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationSettings;
        private final UnaryCallSettings.Builder<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookSettings;
        private final UnaryCallSettings.Builder<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings;
        private final OperationCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationSettings;
        private final UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings;
        private final UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings;
        private final OperationCallSettings.Builder<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings;
        private final OperationCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationSettings;
        private final PagedCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBuildOperationSettings = OperationCallSettings.newBuilder();
            this.getBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBuildsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUILDS_PAGE_STR_FACT);
            this.cancelBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.retryBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.retryBuildOperationSettings = OperationCallSettings.newBuilder();
            this.approveBuildSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.approveBuildOperationSettings = OperationCallSettings.newBuilder();
            this.createBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBuildTriggersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUILD_TRIGGERS_PAGE_STR_FACT);
            this.deleteBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runBuildTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runBuildTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.receiveTriggerWebhookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.getWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkerPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkerPoolOperationSettings = OperationCallSettings.newBuilder();
            this.listWorkerPoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKER_POOLS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBuildSettings, this.getBuildSettings, this.listBuildsSettings, this.cancelBuildSettings, this.retryBuildSettings, this.approveBuildSettings, this.createBuildTriggerSettings, this.getBuildTriggerSettings, this.listBuildTriggersSettings, this.deleteBuildTriggerSettings, this.updateBuildTriggerSettings, this.runBuildTriggerSettings, (Object[])new UnaryCallSettings.Builder[]{this.receiveTriggerWebhookSettings, this.createWorkerPoolSettings, this.getWorkerPoolSettings, this.deleteWorkerPoolSettings, this.updateWorkerPoolSettings, this.listWorkerPoolsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudBuildStubSettings settings) {
            super((StubSettings)settings);
            this.createBuildSettings = settings.createBuildSettings.toBuilder();
            this.createBuildOperationSettings = settings.createBuildOperationSettings.toBuilder();
            this.getBuildSettings = settings.getBuildSettings.toBuilder();
            this.listBuildsSettings = settings.listBuildsSettings.toBuilder();
            this.cancelBuildSettings = settings.cancelBuildSettings.toBuilder();
            this.retryBuildSettings = settings.retryBuildSettings.toBuilder();
            this.retryBuildOperationSettings = settings.retryBuildOperationSettings.toBuilder();
            this.approveBuildSettings = settings.approveBuildSettings.toBuilder();
            this.approveBuildOperationSettings = settings.approveBuildOperationSettings.toBuilder();
            this.createBuildTriggerSettings = settings.createBuildTriggerSettings.toBuilder();
            this.getBuildTriggerSettings = settings.getBuildTriggerSettings.toBuilder();
            this.listBuildTriggersSettings = settings.listBuildTriggersSettings.toBuilder();
            this.deleteBuildTriggerSettings = settings.deleteBuildTriggerSettings.toBuilder();
            this.updateBuildTriggerSettings = settings.updateBuildTriggerSettings.toBuilder();
            this.runBuildTriggerSettings = settings.runBuildTriggerSettings.toBuilder();
            this.runBuildTriggerOperationSettings = settings.runBuildTriggerOperationSettings.toBuilder();
            this.receiveTriggerWebhookSettings = settings.receiveTriggerWebhookSettings.toBuilder();
            this.createWorkerPoolSettings = settings.createWorkerPoolSettings.toBuilder();
            this.createWorkerPoolOperationSettings = settings.createWorkerPoolOperationSettings.toBuilder();
            this.getWorkerPoolSettings = settings.getWorkerPoolSettings.toBuilder();
            this.deleteWorkerPoolSettings = settings.deleteWorkerPoolSettings.toBuilder();
            this.deleteWorkerPoolOperationSettings = settings.deleteWorkerPoolOperationSettings.toBuilder();
            this.updateWorkerPoolSettings = settings.updateWorkerPoolSettings.toBuilder();
            this.updateWorkerPoolOperationSettings = settings.updateWorkerPoolOperationSettings.toBuilder();
            this.listWorkerPoolsSettings = settings.listWorkerPoolsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBuildSettings, this.getBuildSettings, this.listBuildsSettings, this.cancelBuildSettings, this.retryBuildSettings, this.approveBuildSettings, this.createBuildTriggerSettings, this.getBuildTriggerSettings, this.listBuildTriggersSettings, this.deleteBuildTriggerSettings, this.updateBuildTriggerSettings, this.runBuildTriggerSettings, (Object[])new UnaryCallSettings.Builder[]{this.receiveTriggerWebhookSettings, this.createWorkerPoolSettings, this.getWorkerPoolSettings, this.deleteWorkerPoolSettings, this.updateWorkerPoolSettings, this.listWorkerPoolsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudBuildStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudBuildStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudBuildStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudBuildStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudBuildStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudBuildStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudBuildStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudBuildStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudBuildStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudBuildStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBuildsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.retryBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.approveBuildSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBuildTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.runBuildTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.receiveTriggerWebhookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateWorkerPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listWorkerPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createBuildOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Build.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BuildOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.retryBuildOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Build.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BuildOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.approveBuildOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Build.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BuildOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.runBuildTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Build.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BuildOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkerPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateWorkerPoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteWorkerPoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateWorkerPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(WorkerPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateWorkerPoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateBuildRequest, Operation> createBuildSettings() {
            return this.createBuildSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationSettings() {
            return this.createBuildOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBuildRequest, Build> getBuildSettings() {
            return this.getBuildSettings;
        }

        public PagedCallSettings.Builder<ListBuildsRequest, ListBuildsResponse, CloudBuildClient.ListBuildsPagedResponse> listBuildsSettings() {
            return this.listBuildsSettings;
        }

        public UnaryCallSettings.Builder<CancelBuildRequest, Build> cancelBuildSettings() {
            return this.cancelBuildSettings;
        }

        public UnaryCallSettings.Builder<RetryBuildRequest, Operation> retryBuildSettings() {
            return this.retryBuildSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationSettings() {
            return this.retryBuildOperationSettings;
        }

        public UnaryCallSettings.Builder<ApproveBuildRequest, Operation> approveBuildSettings() {
            return this.approveBuildSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ApproveBuildRequest, Build, BuildOperationMetadata> approveBuildOperationSettings() {
            return this.approveBuildOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerSettings() {
            return this.createBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerSettings() {
            return this.getBuildTriggerSettings;
        }

        public PagedCallSettings.Builder<ListBuildTriggersRequest, ListBuildTriggersResponse, CloudBuildClient.ListBuildTriggersPagedResponse> listBuildTriggersSettings() {
            return this.listBuildTriggersSettings;
        }

        public UnaryCallSettings.Builder<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerSettings() {
            return this.deleteBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerSettings() {
            return this.updateBuildTriggerSettings;
        }

        public UnaryCallSettings.Builder<RunBuildTriggerRequest, Operation> runBuildTriggerSettings() {
            return this.runBuildTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationSettings() {
            return this.runBuildTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookSettings() {
            return this.receiveTriggerWebhookSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkerPoolRequest, Operation> createWorkerPoolSettings() {
            return this.createWorkerPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationSettings() {
            return this.createWorkerPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetWorkerPoolRequest, WorkerPool> getWorkerPoolSettings() {
            return this.getWorkerPoolSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolSettings() {
            return this.deleteWorkerPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationSettings() {
            return this.deleteWorkerPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkerPoolRequest, Operation> updateWorkerPoolSettings() {
            return this.updateWorkerPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationSettings() {
            return this.updateWorkerPoolOperationSettings;
        }

        public PagedCallSettings.Builder<ListWorkerPoolsRequest, ListWorkerPoolsResponse, CloudBuildClient.ListWorkerPoolsPagedResponse> listWorkerPoolsSettings() {
            return this.listWorkerPoolsSettings;
        }

        public CloudBuildStubSettings build() throws IOException {
            return new CloudBuildStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

