/*
 * Decompiled with CFR 0.152.
 */
package com.google.protos.google.cloud.binaryauthorization.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protos.google.cloud.binaryauthorization.v1.AttestorName;
import com.google.protos.google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1Settings;
import com.google.protos.google.cloud.binaryauthorization.v1.PolicyName;
import com.google.protos.google.cloud.binaryauthorization.v1.ProjectName;
import com.google.protos.google.cloud.binaryauthorization.v1.Resources;
import com.google.protos.google.cloud.binaryauthorization.v1.Service;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.BinauthzManagementServiceV1Stub;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.BinauthzManagementServiceV1StubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BinauthzManagementServiceV1Client
implements BackgroundResource {
    private final BinauthzManagementServiceV1Settings settings;
    private final BinauthzManagementServiceV1Stub stub;

    public static final BinauthzManagementServiceV1Client create() throws IOException {
        return BinauthzManagementServiceV1Client.create(BinauthzManagementServiceV1Settings.newBuilder().build());
    }

    public static final BinauthzManagementServiceV1Client create(BinauthzManagementServiceV1Settings settings) throws IOException {
        return new BinauthzManagementServiceV1Client(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BinauthzManagementServiceV1Client create(BinauthzManagementServiceV1Stub stub) {
        return new BinauthzManagementServiceV1Client(stub);
    }

    protected BinauthzManagementServiceV1Client(BinauthzManagementServiceV1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BinauthzManagementServiceV1StubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BinauthzManagementServiceV1Client(BinauthzManagementServiceV1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BinauthzManagementServiceV1Settings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BinauthzManagementServiceV1Stub getStub() {
        return this.stub;
    }

    public final Resources.Policy getPolicy(PolicyName name) {
        Service.GetPolicyRequest request = Service.GetPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicy(request);
    }

    public final Resources.Policy getPolicy(String name) {
        Service.GetPolicyRequest request = Service.GetPolicyRequest.newBuilder().setName(name).build();
        return this.getPolicy(request);
    }

    public final Resources.Policy getPolicy(Service.GetPolicyRequest request) {
        return (Resources.Policy)this.getPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<Service.GetPolicyRequest, Resources.Policy> getPolicyCallable() {
        return this.stub.getPolicyCallable();
    }

    public final Resources.Policy updatePolicy(Resources.Policy policy) {
        Service.UpdatePolicyRequest request = Service.UpdatePolicyRequest.newBuilder().setPolicy(policy).build();
        return this.updatePolicy(request);
    }

    public final Resources.Policy updatePolicy(Service.UpdatePolicyRequest request) {
        return (Resources.Policy)this.updatePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<Service.UpdatePolicyRequest, Resources.Policy> updatePolicyCallable() {
        return this.stub.updatePolicyCallable();
    }

    public final Resources.Attestor createAttestor(ProjectName parent, String attestorId, Resources.Attestor attestor) {
        Service.CreateAttestorRequest request = Service.CreateAttestorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttestorId(attestorId).setAttestor(attestor).build();
        return this.createAttestor(request);
    }

    public final Resources.Attestor createAttestor(String parent, String attestorId, Resources.Attestor attestor) {
        Service.CreateAttestorRequest request = Service.CreateAttestorRequest.newBuilder().setParent(parent).setAttestorId(attestorId).setAttestor(attestor).build();
        return this.createAttestor(request);
    }

    public final Resources.Attestor createAttestor(Service.CreateAttestorRequest request) {
        return (Resources.Attestor)this.createAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<Service.CreateAttestorRequest, Resources.Attestor> createAttestorCallable() {
        return this.stub.createAttestorCallable();
    }

    public final Resources.Attestor getAttestor(AttestorName name) {
        Service.GetAttestorRequest request = Service.GetAttestorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttestor(request);
    }

    public final Resources.Attestor getAttestor(String name) {
        Service.GetAttestorRequest request = Service.GetAttestorRequest.newBuilder().setName(name).build();
        return this.getAttestor(request);
    }

    public final Resources.Attestor getAttestor(Service.GetAttestorRequest request) {
        return (Resources.Attestor)this.getAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<Service.GetAttestorRequest, Resources.Attestor> getAttestorCallable() {
        return this.stub.getAttestorCallable();
    }

    public final Resources.Attestor updateAttestor(Resources.Attestor attestor) {
        Service.UpdateAttestorRequest request = Service.UpdateAttestorRequest.newBuilder().setAttestor(attestor).build();
        return this.updateAttestor(request);
    }

    public final Resources.Attestor updateAttestor(Service.UpdateAttestorRequest request) {
        return (Resources.Attestor)this.updateAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<Service.UpdateAttestorRequest, Resources.Attestor> updateAttestorCallable() {
        return this.stub.updateAttestorCallable();
    }

    public final ListAttestorsPagedResponse listAttestors(ProjectName parent) {
        Service.ListAttestorsRequest request = Service.ListAttestorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttestors(request);
    }

    public final ListAttestorsPagedResponse listAttestors(String parent) {
        Service.ListAttestorsRequest request = Service.ListAttestorsRequest.newBuilder().setParent(parent).build();
        return this.listAttestors(request);
    }

    public final ListAttestorsPagedResponse listAttestors(Service.ListAttestorsRequest request) {
        return (ListAttestorsPagedResponse)((Object)this.listAttestorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<Service.ListAttestorsRequest, ListAttestorsPagedResponse> listAttestorsPagedCallable() {
        return this.stub.listAttestorsPagedCallable();
    }

    public final UnaryCallable<Service.ListAttestorsRequest, Service.ListAttestorsResponse> listAttestorsCallable() {
        return this.stub.listAttestorsCallable();
    }

    public final void deleteAttestor(AttestorName name) {
        Service.DeleteAttestorRequest request = Service.DeleteAttestorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAttestor(request);
    }

    public final void deleteAttestor(String name) {
        Service.DeleteAttestorRequest request = Service.DeleteAttestorRequest.newBuilder().setName(name).build();
        this.deleteAttestor(request);
    }

    public final void deleteAttestor(Service.DeleteAttestorRequest request) {
        this.deleteAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<Service.DeleteAttestorRequest, Empty> deleteAttestorCallable() {
        return this.stub.deleteAttestorCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAttestorsFixedSizeCollection
    extends AbstractFixedSizeCollection<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor, ListAttestorsPage, ListAttestorsFixedSizeCollection> {
        private ListAttestorsFixedSizeCollection(List<ListAttestorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttestorsFixedSizeCollection createEmptyCollection() {
            return new ListAttestorsFixedSizeCollection(null, 0);
        }

        protected ListAttestorsFixedSizeCollection createCollection(List<ListAttestorsPage> pages, int collectionSize) {
            return new ListAttestorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttestorsPage
    extends AbstractPage<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor, ListAttestorsPage> {
        private ListAttestorsPage(PageContext<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor> context, Service.ListAttestorsResponse response) {
            super(context, (Object)response);
        }

        private static ListAttestorsPage createEmptyPage() {
            return new ListAttestorsPage(null, null);
        }

        protected ListAttestorsPage createPage(PageContext<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor> context, Service.ListAttestorsResponse response) {
            return new ListAttestorsPage(context, response);
        }

        public ApiFuture<ListAttestorsPage> createPageAsync(PageContext<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor> context, ApiFuture<Service.ListAttestorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttestorsPagedResponse
    extends AbstractPagedListResponse<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor, ListAttestorsPage, ListAttestorsFixedSizeCollection> {
        public static ApiFuture<ListAttestorsPagedResponse> createAsync(PageContext<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor> context, ApiFuture<Service.ListAttestorsResponse> futureResponse) {
            ApiFuture<ListAttestorsPage> futurePage = ListAttestorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttestorsPagedResponse((ListAttestorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttestorsPagedResponse(ListAttestorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttestorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

