/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.budgets.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.budgets.v1.Budget;
import com.google.cloud.billing.budgets.v1.BudgetServiceClient;
import com.google.cloud.billing.budgets.v1.CreateBudgetRequest;
import com.google.cloud.billing.budgets.v1.DeleteBudgetRequest;
import com.google.cloud.billing.budgets.v1.GetBudgetRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsResponse;
import com.google.cloud.billing.budgets.v1.UpdateBudgetRequest;
import com.google.cloud.billing.budgets.v1.stub.BudgetServiceStub;
import com.google.cloud.billing.budgets.v1.stub.GrpcBudgetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BudgetServiceStubSettings
extends StubSettings<BudgetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-billing").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateBudgetRequest, Budget> createBudgetSettings;
    private final UnaryCallSettings<UpdateBudgetRequest, Budget> updateBudgetSettings;
    private final UnaryCallSettings<GetBudgetRequest, Budget> getBudgetSettings;
    private final PagedCallSettings<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsSettings;
    private final UnaryCallSettings<DeleteBudgetRequest, Empty> deleteBudgetSettings;
    private static final PagedListDescriptor<ListBudgetsRequest, ListBudgetsResponse, Budget> LIST_BUDGETS_PAGE_STR_DESC = new PagedListDescriptor<ListBudgetsRequest, ListBudgetsResponse, Budget>(){

        public String emptyToken() {
            return "";
        }

        public ListBudgetsRequest injectToken(ListBudgetsRequest payload, String token) {
            return ListBudgetsRequest.newBuilder((ListBudgetsRequest)payload).setPageToken(token).build();
        }

        public ListBudgetsRequest injectPageSize(ListBudgetsRequest payload, int pageSize) {
            return ListBudgetsRequest.newBuilder((ListBudgetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBudgetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBudgetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Budget> extractResources(ListBudgetsResponse payload) {
            return payload.getBudgetsList() == null ? ImmutableList.of() : payload.getBudgetsList();
        }
    };
    private static final PagedListResponseFactory<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse> LIST_BUDGETS_PAGE_STR_FACT = new PagedListResponseFactory<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse>(){

        public ApiFuture<BudgetServiceClient.ListBudgetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> callable, ListBudgetsRequest request, ApiCallContext context, ApiFuture<ListBudgetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUDGETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BudgetServiceClient.ListBudgetsPagedResponse.createAsync((PageContext<ListBudgetsRequest, ListBudgetsResponse, Budget>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateBudgetRequest, Budget> createBudgetSettings() {
        return this.createBudgetSettings;
    }

    public UnaryCallSettings<UpdateBudgetRequest, Budget> updateBudgetSettings() {
        return this.updateBudgetSettings;
    }

    public UnaryCallSettings<GetBudgetRequest, Budget> getBudgetSettings() {
        return this.getBudgetSettings;
    }

    public PagedCallSettings<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsSettings() {
        return this.listBudgetsSettings;
    }

    public UnaryCallSettings<DeleteBudgetRequest, Empty> deleteBudgetSettings() {
        return this.deleteBudgetSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BudgetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBudgetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "billingbudgets.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BudgetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BudgetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BudgetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createBudgetSettings = settingsBuilder.createBudgetSettings().build();
        this.updateBudgetSettings = settingsBuilder.updateBudgetSettings().build();
        this.getBudgetSettings = settingsBuilder.getBudgetSettings().build();
        this.listBudgetsSettings = settingsBuilder.listBudgetsSettings().build();
        this.deleteBudgetSettings = settingsBuilder.deleteBudgetSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BudgetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateBudgetRequest, Budget> createBudgetSettings;
        private final UnaryCallSettings.Builder<UpdateBudgetRequest, Budget> updateBudgetSettings;
        private final UnaryCallSettings.Builder<GetBudgetRequest, Budget> getBudgetSettings;
        private final PagedCallSettings.Builder<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsSettings;
        private final UnaryCallSettings.Builder<DeleteBudgetRequest, Empty> deleteBudgetSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createBudgetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBudgetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBudgetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBudgetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUDGETS_PAGE_STR_FACT);
            this.deleteBudgetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBudgetSettings, this.updateBudgetSettings, this.getBudgetSettings, this.listBudgetsSettings, this.deleteBudgetSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BudgetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createBudgetSettings = settings.createBudgetSettings.toBuilder();
            this.updateBudgetSettings = settings.updateBudgetSettings.toBuilder();
            this.getBudgetSettings = settings.getBudgetSettings.toBuilder();
            this.listBudgetsSettings = settings.listBudgetsSettings.toBuilder();
            this.deleteBudgetSettings = settings.deleteBudgetSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBudgetSettings, this.updateBudgetSettings, this.getBudgetSettings, this.listBudgetsSettings, this.deleteBudgetSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BudgetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BudgetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BudgetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BudgetServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createBudgetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateBudgetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getBudgetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listBudgetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteBudgetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateBudgetRequest, Budget> createBudgetSettings() {
            return this.createBudgetSettings;
        }

        public UnaryCallSettings.Builder<UpdateBudgetRequest, Budget> updateBudgetSettings() {
            return this.updateBudgetSettings;
        }

        public UnaryCallSettings.Builder<GetBudgetRequest, Budget> getBudgetSettings() {
            return this.getBudgetSettings;
        }

        public PagedCallSettings.Builder<ListBudgetsRequest, ListBudgetsResponse, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsSettings() {
            return this.listBudgetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteBudgetRequest, Empty> deleteBudgetSettings() {
            return this.deleteBudgetSettings;
        }

        public BudgetServiceStubSettings build() throws IOException {
            return new BudgetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

