/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.CloudCatalogClient;
import com.google.cloud.billing.v1.ListServicesRequest;
import com.google.cloud.billing.v1.ListServicesResponse;
import com.google.cloud.billing.v1.ListSkusRequest;
import com.google.cloud.billing.v1.ListSkusResponse;
import com.google.cloud.billing.v1.stub.CloudCatalogStub;
import com.google.cloud.billing.v1.stub.CloudCatalogStubSettings;
import com.google.cloud.billing.v1.stub.GrpcCloudCatalogCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCloudCatalogStub
extends CloudCatalogStub {
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudCatalog/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSkusRequest, ListSkusResponse> listSkusMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudCatalog/ListSkus").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSkusRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSkusResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, CloudCatalogClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable;
    private final UnaryCallable<ListSkusRequest, CloudCatalogClient.ListSkusPagedResponse> listSkusPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudCatalogStub create(CloudCatalogStubSettings settings) throws IOException {
        return new GrpcCloudCatalogStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudCatalogStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudCatalogStub(CloudCatalogStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudCatalogStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudCatalogStub(CloudCatalogStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudCatalogStub(CloudCatalogStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudCatalogCallableFactory());
    }

    protected GrpcCloudCatalogStub(CloudCatalogStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).build();
        GrpcCallSettings listSkusTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSkusMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listSkusCallable = callableFactory.createUnaryCallable(listSkusTransportSettings, settings.listSkusSettings(), clientContext);
        this.listSkusPagedCallable = callableFactory.createPagedCallable(listSkusTransportSettings, settings.listSkusSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, CloudCatalogClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable() {
        return this.listSkusCallable;
    }

    @Override
    public UnaryCallable<ListSkusRequest, CloudCatalogClient.ListSkusPagedResponse> listSkusPagedCallable() {
        return this.listSkusPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

