/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.PartialResultSet;
import com.google.bigtable.v2.ProtoRows;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
final class ProtoRowsMergingStateMachine {
    private static final HashFunction CRC32C = Hashing.crc32c();
    private final Supplier<ResultSetMetadata> metadataSupplier;
    private @Nullable ResultSetMetadata metadata;
    private State state;
    private ByteString batchBuffer;
    private List<List<Value>> parsedBatches;
    private boolean hasReceivedFirstResumeToken;

    ProtoRowsMergingStateMachine(Supplier<ResultSetMetadata> metadataSupplier) {
        this.metadataSupplier = metadataSupplier;
        this.state = State.AWAITING_NEW_DATA;
        this.batchBuffer = ByteString.empty();
        this.parsedBatches = new ArrayList<List<Value>>();
        this.hasReceivedFirstResumeToken = false;
    }

    void addPartialResultSet(PartialResultSet results) {
        boolean hasResumeToken;
        Preconditions.checkState((this.state != State.AWAITING_BATCH_CONSUME ? 1 : 0) != 0, (Object)"Attempting to add partial result set to state machine in state AWAITING_BATCH_CONSUME");
        if (results.getReset()) {
            this.batchBuffer = ByteString.EMPTY;
            this.parsedBatches.clear();
        }
        this.batchBuffer = this.batchBuffer.concat(results.getProtoRowsBatch().getBatchData());
        if (results.hasBatchChecksum()) {
            HashCode hash = CRC32C.hashBytes(this.batchBuffer.toByteArray());
            Preconditions.checkState((hash.hashCode() == results.getBatchChecksum() ? 1 : 0) != 0, (Object)"Unexpected checksum mismatch");
            try {
                ProtoRows completeBatch = ProtoRows.parseFrom((ByteString)this.batchBuffer);
                this.batchBuffer = ByteString.EMPTY;
                this.parsedBatches.add(completeBatch.getValuesList());
            }
            catch (InvalidProtocolBufferException e) {
                throw new InternalError("Unexpected exception parsing response protobuf", e);
            }
        }
        boolean bl = hasResumeToken = !results.getResumeToken().isEmpty();
        if (hasResumeToken) {
            if (!this.hasReceivedFirstResumeToken) {
                this.metadata = this.metadataSupplier.get();
                this.hasReceivedFirstResumeToken = true;
            }
            Preconditions.checkState((boolean)this.batchBuffer.isEmpty(), (Object)"Received resumeToken with buffered data and no checksum");
            this.state = State.AWAITING_BATCH_CONSUME;
        }
    }

    boolean hasCompleteBatches() {
        return this.state == State.AWAITING_BATCH_CONSUME;
    }

    boolean isBatchInProgress() {
        boolean hasBufferedData = !this.batchBuffer.isEmpty() || !this.parsedBatches.isEmpty();
        return this.hasCompleteBatches() || hasBufferedData;
    }

    void populateQueue(Queue<SqlRow> queue) {
        Preconditions.checkState((this.state == State.AWAITING_BATCH_CONSUME ? 1 : 0) != 0, (Object)"Attempting to populate Queue from state machine without completed batch");
        Preconditions.checkState((boolean)this.batchBuffer.isEmpty(), (Object)"Unexpected buffered partial batch while consuming rows.");
        Preconditions.checkNotNull((Object)this.metadata, (Object)"Unexpected empty metadata when parsing response");
        Iterator valuesIterator = Iterables.concat(this.parsedBatches).iterator();
        while (valuesIterator.hasNext()) {
            ImmutableList.Builder rowDataBuilder = ImmutableList.builder();
            for (ColumnMetadata c : this.metadata.getColumns()) {
                Preconditions.checkState((boolean)valuesIterator.hasNext(), (String)"Incomplete row received with first missing column: %s", (Object)c);
                Value v = (Value)valuesIterator.next();
                ProtoRowsMergingStateMachine.validateValueAndType(c.type(), v);
                rowDataBuilder.add((Object)v);
            }
            queue.add(ProtoSqlRow.create(this.metadata, (List<Value>)rowDataBuilder.build()));
        }
        this.parsedBatches = new ArrayList<List<Value>>();
        this.state = State.AWAITING_NEW_DATA;
    }

    @InternalApi(value="VisibleForTestingOnly")
    static void validateValueAndType(SqlType<?> type, Value value) {
        if (value.getKindCase() == Value.KindCase.KIND_NOT_SET) {
            return;
        }
        switch (type.getCode()) {
            case STRING: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.STRING_VALUE, type);
                break;
            }
            case BYTES: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.BYTES_VALUE, type);
                break;
            }
            case INT64: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.INT_VALUE, type);
                break;
            }
            case FLOAT64: 
            case FLOAT32: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.FLOAT_VALUE, type);
                break;
            }
            case BOOL: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.BOOL_VALUE, type);
                break;
            }
            case TIMESTAMP: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.TIMESTAMP_VALUE, type);
                break;
            }
            case DATE: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.DATE_VALUE, type);
                break;
            }
            case ARRAY: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                SqlType.Array arrayType = (SqlType.Array)type;
                SqlType elemType = arrayType.getElementType();
                for (Value element : value.getArrayValue().getValuesList()) {
                    ProtoRowsMergingStateMachine.validateValueAndType(elemType, element);
                }
                break;
            }
            case STRUCT: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                List fieldValues = value.getArrayValue().getValuesList();
                SqlType.Struct structType = (SqlType.Struct)type;
                if (fieldValues.size() != structType.getFields().size()) {
                    throw new IllegalStateException(String.format("Unexpected malformed struct data. Expected %s fields, received: %s", structType.getFields().size(), fieldValues.size()));
                }
                for (int i = 0; i < fieldValues.size(); ++i) {
                    ProtoRowsMergingStateMachine.validateValueAndType(structType.getType(i), (Value)fieldValues.get(i));
                }
                break;
            }
            case MAP: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                SqlType.Map mapType = (SqlType.Map)type;
                for (Value mapElement : value.getArrayValue().getValuesList()) {
                    Preconditions.checkState((mapElement.getArrayValue().getValuesCount() == 2 ? 1 : 0) != 0, (Object)"Map elements must have exactly 2 elementss");
                    ProtoRowsMergingStateMachine.validateValueAndType(mapType.getKeyType(), (Value)mapElement.getArrayValue().getValuesList().get(0));
                    ProtoRowsMergingStateMachine.validateValueAndType(mapType.getValueType(), (Value)mapElement.getArrayValue().getValuesList().get(1));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized type: " + type);
            }
        }
    }

    private static void checkExpectedKind(Value value, Value.KindCase expectedKind, SqlType<?> type) {
        Preconditions.checkState((value.getKindCase() == expectedKind ? 1 : 0) != 0, (String)"Value kind must be %s for columns of type: %s", (Object)expectedKind.name(), type);
    }

    static enum State {
        AWAITING_NEW_DATA,
        AWAITING_BATCH_CONSUME;

    }
}

