/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateSchemaBundleRequest;
import com.google.bigtable.admin.v2.ProtoSchema;
import com.google.bigtable.admin.v2.SchemaBundle;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;

public final class CreateSchemaBundleRequest {
    private final String tableId;
    private final CreateSchemaBundleRequest.Builder requestBuilder = com.google.bigtable.admin.v2.CreateSchemaBundleRequest.newBuilder();

    public static CreateSchemaBundleRequest of(@Nonnull String tableId, @Nonnull String schemaBundleId) {
        return new CreateSchemaBundleRequest(tableId, schemaBundleId);
    }

    private CreateSchemaBundleRequest(@Nonnull String tableId, @Nonnull String schemaBundleId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId must be set");
        Preconditions.checkNotNull((Object)schemaBundleId, (Object)"schemaBundleId must be set");
        this.tableId = tableId;
        this.requestBuilder.setSchemaBundleId(schemaBundleId);
    }

    public CreateSchemaBundleRequest setProtoSchemaFile(@Nonnull String protoSchemaFile) throws IOException {
        Preconditions.checkNotNull((Object)protoSchemaFile, (Object)"protoSchemaFile must be set");
        byte[] content = Files.readAllBytes(Paths.get(protoSchemaFile, new String[0]));
        return this.setProtoSchema(ByteString.copyFrom((byte[])content));
    }

    public CreateSchemaBundleRequest setProtoSchema(@Nonnull ByteString protoSchema) throws IOException {
        Preconditions.checkNotNull((Object)protoSchema, (Object)"protoSchema must be set");
        this.requestBuilder.setSchemaBundle(SchemaBundle.newBuilder().setProtoSchema(ProtoSchema.newBuilder().setProtoDescriptors(protoSchema)));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSchemaBundleRequest that = (CreateSchemaBundleRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build()) && Objects.equal((Object)this.tableId, (Object)that.tableId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build(), this.tableId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateSchemaBundleRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        return this.requestBuilder.setParent(NameUtil.formatTableName(projectId, instanceId, this.tableId)).build();
    }
}

