/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.bigtable.admin.v2.AuthorizedViewName;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.BackupName;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.CopyBackupMetadata;
import com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.bigtable.admin.v2.CreateAuthorizedViewMetadata;
import com.google.bigtable.admin.v2.CreateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.CreateBackupMetadata;
import com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.admin.v2.CreateSchemaBundleMetadata;
import com.google.bigtable.admin.v2.CreateSchemaBundleRequest;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotMetadata;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteAuthorizedViewRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteSchemaBundleRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetAuthorizedViewRequest;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetSchemaBundleRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListAuthorizedViewsRequest;
import com.google.bigtable.admin.v2.ListAuthorizedViewsResponse;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.admin.v2.ListSchemaBundlesRequest;
import com.google.bigtable.admin.v2.ListSchemaBundlesResponse;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.admin.v2.SchemaBundle;
import com.google.bigtable.admin.v2.SchemaBundleName;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotName;
import com.google.bigtable.admin.v2.SnapshotTableMetadata;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.bigtable.admin.v2.UndeleteTableMetadata;
import com.google.bigtable.admin.v2.UndeleteTableRequest;
import com.google.bigtable.admin.v2.UpdateAuthorizedViewMetadata;
import com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.admin.v2.UpdateSchemaBundleMetadata;
import com.google.bigtable.admin.v2.UpdateSchemaBundleRequest;
import com.google.bigtable.admin.v2.UpdateTableMetadata;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@InternalApi
public class BaseBigtableTableAdminClient
implements BackgroundResource {
    private final BaseBigtableTableAdminSettings settings;
    private final BigtableTableAdminStub stub;
    private final OperationsClient operationsClient;

    public static final BaseBigtableTableAdminClient create() throws IOException {
        return BaseBigtableTableAdminClient.create(BaseBigtableTableAdminSettings.newBuilder().build());
    }

    public static final BaseBigtableTableAdminClient create(BaseBigtableTableAdminSettings settings) throws IOException {
        return new BaseBigtableTableAdminClient(settings);
    }

    public static final BaseBigtableTableAdminClient create(BigtableTableAdminStub stub) {
        return new BaseBigtableTableAdminClient(stub);
    }

    protected BaseBigtableTableAdminClient(BaseBigtableTableAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigtableTableAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected BaseBigtableTableAdminClient(BigtableTableAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BaseBigtableTableAdminSettings getSettings() {
        return this.settings;
    }

    public BigtableTableAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Table createTable(InstanceName parent, String tableId, Table table) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTableId(tableId).setTable(table).build();
        return this.createTable(request);
    }

    public final Table createTable(String parent, String tableId, Table table) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent).setTableId(tableId).setTable(table).build();
        return this.createTable(request);
    }

    public final Table createTable(CreateTableRequest request) {
        return (Table)this.createTableCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTableRequest, Table> createTableCallable() {
        return this.stub.createTableCallable();
    }

    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(InstanceName parent, String tableId, SnapshotName sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTableId(tableId).setSourceSnapshot(sourceSnapshot == null ? null : sourceSnapshot.toString()).build();
        return this.createTableFromSnapshotAsync(request);
    }

    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(InstanceName parent, String tableId, String sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTableId(tableId).setSourceSnapshot(sourceSnapshot).build();
        return this.createTableFromSnapshotAsync(request);
    }

    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(String parent, String tableId, SnapshotName sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent).setTableId(tableId).setSourceSnapshot(sourceSnapshot == null ? null : sourceSnapshot.toString()).build();
        return this.createTableFromSnapshotAsync(request);
    }

    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(String parent, String tableId, String sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent).setTableId(tableId).setSourceSnapshot(sourceSnapshot).build();
        return this.createTableFromSnapshotAsync(request);
    }

    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return this.createTableFromSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationCallable() {
        return this.stub.createTableFromSnapshotOperationCallable();
    }

    public final UnaryCallable<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotCallable() {
        return this.stub.createTableFromSnapshotCallable();
    }

    public final ListTablesPagedResponse listTables(InstanceName parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(String parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(ListTablesRequest request) {
        return (ListTablesPagedResponse)((Object)this.listTablesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTablesRequest, ListTablesPagedResponse> listTablesPagedCallable() {
        return this.stub.listTablesPagedCallable();
    }

    public final UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable() {
        return this.stub.listTablesCallable();
    }

    public final Table getTable(TableName name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTable(request);
    }

    public final Table getTable(String name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name).build();
        return this.getTable(request);
    }

    public final Table getTable(GetTableRequest request) {
        return (Table)this.getTableCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableRequest, Table> getTableCallable() {
        return this.stub.getTableCallable();
    }

    public final OperationFuture<Table, UpdateTableMetadata> updateTableAsync(Table table, FieldMask updateMask) {
        UpdateTableRequest request = UpdateTableRequest.newBuilder().setTable(table).setUpdateMask(updateMask).build();
        return this.updateTableAsync(request);
    }

    public final OperationFuture<Table, UpdateTableMetadata> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationCallable() {
        return this.stub.updateTableOperationCallable();
    }

    public final UnaryCallable<UpdateTableRequest, Operation> updateTableCallable() {
        return this.stub.updateTableCallable();
    }

    public final void deleteTable(TableName name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTable(request);
    }

    public final void deleteTable(String name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name).build();
        this.deleteTable(request);
    }

    public final void deleteTable(DeleteTableRequest request) {
        this.deleteTableCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTableRequest, Empty> deleteTableCallable() {
        return this.stub.deleteTableCallable();
    }

    public final OperationFuture<Table, UndeleteTableMetadata> undeleteTableAsync(TableName name) {
        UndeleteTableRequest request = UndeleteTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteTableAsync(request);
    }

    public final OperationFuture<Table, UndeleteTableMetadata> undeleteTableAsync(String name) {
        UndeleteTableRequest request = UndeleteTableRequest.newBuilder().setName(name).build();
        return this.undeleteTableAsync(request);
    }

    public final OperationFuture<Table, UndeleteTableMetadata> undeleteTableAsync(UndeleteTableRequest request) {
        return this.undeleteTableOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationCallable() {
        return this.stub.undeleteTableOperationCallable();
    }

    public final UnaryCallable<UndeleteTableRequest, Operation> undeleteTableCallable() {
        return this.stub.undeleteTableCallable();
    }

    public final OperationFuture<AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewAsync(TableName parent, AuthorizedView authorizedView, String authorizedViewId) {
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAuthorizedView(authorizedView).setAuthorizedViewId(authorizedViewId).build();
        return this.createAuthorizedViewAsync(request);
    }

    public final OperationFuture<AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewAsync(String parent, AuthorizedView authorizedView, String authorizedViewId) {
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.newBuilder().setParent(parent).setAuthorizedView(authorizedView).setAuthorizedViewId(authorizedViewId).build();
        return this.createAuthorizedViewAsync(request);
    }

    public final OperationFuture<AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewAsync(CreateAuthorizedViewRequest request) {
        return this.createAuthorizedViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAuthorizedViewRequest, AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewOperationCallable() {
        return this.stub.createAuthorizedViewOperationCallable();
    }

    public final UnaryCallable<CreateAuthorizedViewRequest, Operation> createAuthorizedViewCallable() {
        return this.stub.createAuthorizedViewCallable();
    }

    public final ListAuthorizedViewsPagedResponse listAuthorizedViews(TableName parent) {
        ListAuthorizedViewsRequest request = ListAuthorizedViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAuthorizedViews(request);
    }

    public final ListAuthorizedViewsPagedResponse listAuthorizedViews(String parent) {
        ListAuthorizedViewsRequest request = ListAuthorizedViewsRequest.newBuilder().setParent(parent).build();
        return this.listAuthorizedViews(request);
    }

    public final ListAuthorizedViewsPagedResponse listAuthorizedViews(ListAuthorizedViewsRequest request) {
        return (ListAuthorizedViewsPagedResponse)((Object)this.listAuthorizedViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAuthorizedViewsRequest, ListAuthorizedViewsPagedResponse> listAuthorizedViewsPagedCallable() {
        return this.stub.listAuthorizedViewsPagedCallable();
    }

    public final UnaryCallable<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse> listAuthorizedViewsCallable() {
        return this.stub.listAuthorizedViewsCallable();
    }

    public final AuthorizedView getAuthorizedView(AuthorizedViewName name) {
        GetAuthorizedViewRequest request = GetAuthorizedViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAuthorizedView(request);
    }

    public final AuthorizedView getAuthorizedView(String name) {
        GetAuthorizedViewRequest request = GetAuthorizedViewRequest.newBuilder().setName(name).build();
        return this.getAuthorizedView(request);
    }

    public final AuthorizedView getAuthorizedView(GetAuthorizedViewRequest request) {
        return (AuthorizedView)this.getAuthorizedViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetAuthorizedViewRequest, AuthorizedView> getAuthorizedViewCallable() {
        return this.stub.getAuthorizedViewCallable();
    }

    public final OperationFuture<AuthorizedView, UpdateAuthorizedViewMetadata> updateAuthorizedViewAsync(AuthorizedView authorizedView, FieldMask updateMask) {
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.newBuilder().setAuthorizedView(authorizedView).setUpdateMask(updateMask).build();
        return this.updateAuthorizedViewAsync(request);
    }

    public final OperationFuture<AuthorizedView, UpdateAuthorizedViewMetadata> updateAuthorizedViewAsync(UpdateAuthorizedViewRequest request) {
        return this.updateAuthorizedViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAuthorizedViewRequest, AuthorizedView, UpdateAuthorizedViewMetadata> updateAuthorizedViewOperationCallable() {
        return this.stub.updateAuthorizedViewOperationCallable();
    }

    public final UnaryCallable<UpdateAuthorizedViewRequest, Operation> updateAuthorizedViewCallable() {
        return this.stub.updateAuthorizedViewCallable();
    }

    public final void deleteAuthorizedView(AuthorizedViewName name) {
        DeleteAuthorizedViewRequest request = DeleteAuthorizedViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAuthorizedView(request);
    }

    public final void deleteAuthorizedView(String name) {
        DeleteAuthorizedViewRequest request = DeleteAuthorizedViewRequest.newBuilder().setName(name).build();
        this.deleteAuthorizedView(request);
    }

    public final void deleteAuthorizedView(DeleteAuthorizedViewRequest request) {
        this.deleteAuthorizedViewCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAuthorizedViewRequest, Empty> deleteAuthorizedViewCallable() {
        return this.stub.deleteAuthorizedViewCallable();
    }

    public final Table modifyColumnFamilies(TableName name, List<ModifyColumnFamiliesRequest.Modification> modifications) {
        ModifyColumnFamiliesRequest request = ModifyColumnFamiliesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllModifications(modifications).build();
        return this.modifyColumnFamilies(request);
    }

    public final Table modifyColumnFamilies(String name, List<ModifyColumnFamiliesRequest.Modification> modifications) {
        ModifyColumnFamiliesRequest request = ModifyColumnFamiliesRequest.newBuilder().setName(name).addAllModifications(modifications).build();
        return this.modifyColumnFamilies(request);
    }

    public final Table modifyColumnFamilies(ModifyColumnFamiliesRequest request) {
        return (Table)this.modifyColumnFamiliesCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesCallable() {
        return this.stub.modifyColumnFamiliesCallable();
    }

    public final void dropRowRange(DropRowRangeRequest request) {
        this.dropRowRangeCallable().call((Object)request);
    }

    public final UnaryCallable<DropRowRangeRequest, Empty> dropRowRangeCallable() {
        return this.stub.dropRowRangeCallable();
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(TableName name) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.generateConsistencyToken(request);
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(String name) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(name).build();
        return this.generateConsistencyToken(request);
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(GenerateConsistencyTokenRequest request) {
        return (GenerateConsistencyTokenResponse)this.generateConsistencyTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenCallable() {
        return this.stub.generateConsistencyTokenCallable();
    }

    public final CheckConsistencyResponse checkConsistency(TableName name, String consistencyToken) {
        CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(name == null ? null : name.toString()).setConsistencyToken(consistencyToken).build();
        return this.checkConsistency(request);
    }

    public final CheckConsistencyResponse checkConsistency(String name, String consistencyToken) {
        CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(name).setConsistencyToken(consistencyToken).build();
        return this.checkConsistency(request);
    }

    public final CheckConsistencyResponse checkConsistency(CheckConsistencyRequest request) {
        return (CheckConsistencyResponse)this.checkConsistencyCallable().call((Object)request);
    }

    public final UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyCallable() {
        return this.stub.checkConsistencyCallable();
    }

    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(TableName name, ClusterName cluster, String snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name == null ? null : name.toString()).setCluster(cluster == null ? null : cluster.toString()).setSnapshotId(snapshotId).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(TableName name, String cluster, String snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name == null ? null : name.toString()).setCluster(cluster).setSnapshotId(snapshotId).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(String name, ClusterName cluster, String snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name).setCluster(cluster == null ? null : cluster.toString()).setSnapshotId(snapshotId).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(String name, String cluster, String snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name).setCluster(cluster).setSnapshotId(snapshotId).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(SnapshotTableRequest request) {
        return this.snapshotTableOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationCallable() {
        return this.stub.snapshotTableOperationCallable();
    }

    public final UnaryCallable<SnapshotTableRequest, Operation> snapshotTableCallable() {
        return this.stub.snapshotTableCallable();
    }

    public final Snapshot getSnapshot(SnapshotName name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(String name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(GetSnapshotRequest request) {
        return (Snapshot)this.getSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.stub.getSnapshotCallable();
    }

    public final ListSnapshotsPagedResponse listSnapshots(ClusterName parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(String parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(ListSnapshotsRequest request) {
        return (ListSnapshotsPagedResponse)((Object)this.listSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.stub.listSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.stub.listSnapshotsCallable();
    }

    public final void deleteSnapshot(SnapshotName name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(String name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(DeleteSnapshotRequest request) {
        this.deleteSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.stub.deleteSnapshotCallable();
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(ClusterName parent, String backupId, Backup backup) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupId(backupId).setBackup(backup).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(String parent, String backupId, Backup backup) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackupId(backupId).setBackup(backup).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final Backup updateBackup(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackup(request);
    }

    public final Backup updateBackup(UpdateBackupRequest request) {
        return (Backup)this.updateBackupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBackupRequest, Backup> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final void deleteBackup(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(DeleteBackupRequest request) {
        this.deleteBackupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBackupRequest, Empty> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final ListBackupsPagedResponse listBackups(ClusterName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final OperationFuture<Table, RestoreTableMetadata> restoreTableAsync(RestoreTableRequest request) {
        return this.restoreTableOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationCallable() {
        return this.stub.restoreTableOperationCallable();
    }

    public final UnaryCallable<RestoreTableRequest, Operation> restoreTableCallable() {
        return this.stub.restoreTableCallable();
    }

    public final OperationFuture<Backup, CopyBackupMetadata> copyBackupAsync(ClusterName parent, String backupId, BackupName sourceBackup, Timestamp expireTime) {
        CopyBackupRequest request = CopyBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupId(backupId).setSourceBackup(sourceBackup == null ? null : sourceBackup.toString()).setExpireTime(expireTime).build();
        return this.copyBackupAsync(request);
    }

    public final OperationFuture<Backup, CopyBackupMetadata> copyBackupAsync(ClusterName parent, String backupId, String sourceBackup, Timestamp expireTime) {
        CopyBackupRequest request = CopyBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackupId(backupId).setSourceBackup(sourceBackup).setExpireTime(expireTime).build();
        return this.copyBackupAsync(request);
    }

    public final OperationFuture<Backup, CopyBackupMetadata> copyBackupAsync(String parent, String backupId, BackupName sourceBackup, Timestamp expireTime) {
        CopyBackupRequest request = CopyBackupRequest.newBuilder().setParent(parent).setBackupId(backupId).setSourceBackup(sourceBackup == null ? null : sourceBackup.toString()).setExpireTime(expireTime).build();
        return this.copyBackupAsync(request);
    }

    public final OperationFuture<Backup, CopyBackupMetadata> copyBackupAsync(String parent, String backupId, String sourceBackup, Timestamp expireTime) {
        CopyBackupRequest request = CopyBackupRequest.newBuilder().setParent(parent).setBackupId(backupId).setSourceBackup(sourceBackup).setExpireTime(expireTime).build();
        return this.copyBackupAsync(request);
    }

    public final OperationFuture<Backup, CopyBackupMetadata> copyBackupAsync(CopyBackupRequest request) {
        return this.copyBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationCallable() {
        return this.stub.copyBackupOperationCallable();
    }

    public final UnaryCallable<CopyBackupRequest, Operation> copyBackupCallable() {
        return this.stub.copyBackupCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<SchemaBundle, CreateSchemaBundleMetadata> createSchemaBundleAsync(TableName parent, String schemaBundleId, SchemaBundle schemaBundle) {
        CreateSchemaBundleRequest request = CreateSchemaBundleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchemaBundleId(schemaBundleId).setSchemaBundle(schemaBundle).build();
        return this.createSchemaBundleAsync(request);
    }

    public final OperationFuture<SchemaBundle, CreateSchemaBundleMetadata> createSchemaBundleAsync(String parent, String schemaBundleId, SchemaBundle schemaBundle) {
        CreateSchemaBundleRequest request = CreateSchemaBundleRequest.newBuilder().setParent(parent).setSchemaBundleId(schemaBundleId).setSchemaBundle(schemaBundle).build();
        return this.createSchemaBundleAsync(request);
    }

    public final OperationFuture<SchemaBundle, CreateSchemaBundleMetadata> createSchemaBundleAsync(CreateSchemaBundleRequest request) {
        return this.createSchemaBundleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSchemaBundleRequest, SchemaBundle, CreateSchemaBundleMetadata> createSchemaBundleOperationCallable() {
        return this.stub.createSchemaBundleOperationCallable();
    }

    public final UnaryCallable<CreateSchemaBundleRequest, Operation> createSchemaBundleCallable() {
        return this.stub.createSchemaBundleCallable();
    }

    public final OperationFuture<SchemaBundle, UpdateSchemaBundleMetadata> updateSchemaBundleAsync(SchemaBundle schemaBundle, FieldMask updateMask) {
        UpdateSchemaBundleRequest request = UpdateSchemaBundleRequest.newBuilder().setSchemaBundle(schemaBundle).setUpdateMask(updateMask).build();
        return this.updateSchemaBundleAsync(request);
    }

    public final OperationFuture<SchemaBundle, UpdateSchemaBundleMetadata> updateSchemaBundleAsync(UpdateSchemaBundleRequest request) {
        return this.updateSchemaBundleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSchemaBundleRequest, SchemaBundle, UpdateSchemaBundleMetadata> updateSchemaBundleOperationCallable() {
        return this.stub.updateSchemaBundleOperationCallable();
    }

    public final UnaryCallable<UpdateSchemaBundleRequest, Operation> updateSchemaBundleCallable() {
        return this.stub.updateSchemaBundleCallable();
    }

    public final SchemaBundle getSchemaBundle(SchemaBundleName name) {
        GetSchemaBundleRequest request = GetSchemaBundleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSchemaBundle(request);
    }

    public final SchemaBundle getSchemaBundle(String name) {
        GetSchemaBundleRequest request = GetSchemaBundleRequest.newBuilder().setName(name).build();
        return this.getSchemaBundle(request);
    }

    public final SchemaBundle getSchemaBundle(GetSchemaBundleRequest request) {
        return (SchemaBundle)this.getSchemaBundleCallable().call((Object)request);
    }

    public final UnaryCallable<GetSchemaBundleRequest, SchemaBundle> getSchemaBundleCallable() {
        return this.stub.getSchemaBundleCallable();
    }

    public final ListSchemaBundlesPagedResponse listSchemaBundles(TableName parent) {
        ListSchemaBundlesRequest request = ListSchemaBundlesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSchemaBundles(request);
    }

    public final ListSchemaBundlesPagedResponse listSchemaBundles(String parent) {
        ListSchemaBundlesRequest request = ListSchemaBundlesRequest.newBuilder().setParent(parent).build();
        return this.listSchemaBundles(request);
    }

    public final ListSchemaBundlesPagedResponse listSchemaBundles(ListSchemaBundlesRequest request) {
        return (ListSchemaBundlesPagedResponse)((Object)this.listSchemaBundlesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSchemaBundlesRequest, ListSchemaBundlesPagedResponse> listSchemaBundlesPagedCallable() {
        return this.stub.listSchemaBundlesPagedCallable();
    }

    public final UnaryCallable<ListSchemaBundlesRequest, ListSchemaBundlesResponse> listSchemaBundlesCallable() {
        return this.stub.listSchemaBundlesCallable();
    }

    public final void deleteSchemaBundle(SchemaBundleName name) {
        DeleteSchemaBundleRequest request = DeleteSchemaBundleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSchemaBundle(request);
    }

    public final void deleteSchemaBundle(String name) {
        DeleteSchemaBundleRequest request = DeleteSchemaBundleRequest.newBuilder().setName(name).build();
        this.deleteSchemaBundle(request);
    }

    public final void deleteSchemaBundle(DeleteSchemaBundleRequest request) {
        this.deleteSchemaBundleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSchemaBundleRequest, Empty> deleteSchemaBundleCallable() {
        return this.stub.deleteSchemaBundleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTablesPagedResponse
    extends AbstractPagedListResponse<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        public static ApiFuture<ListTablesPagedResponse> createAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            ApiFuture<ListTablesPage> futurePage = ListTablesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTablesPagedResponse((ListTablesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTablesPagedResponse(ListTablesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTablesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAuthorizedViewsPagedResponse
    extends AbstractPagedListResponse<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView, ListAuthorizedViewsPage, ListAuthorizedViewsFixedSizeCollection> {
        public static ApiFuture<ListAuthorizedViewsPagedResponse> createAsync(PageContext<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView> context, ApiFuture<ListAuthorizedViewsResponse> futureResponse) {
            ApiFuture<ListAuthorizedViewsPage> futurePage = ListAuthorizedViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAuthorizedViewsPagedResponse((ListAuthorizedViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAuthorizedViewsPagedResponse(ListAuthorizedViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAuthorizedViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListSnapshotsPagedResponse> createAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            ApiFuture<ListSnapshotsPage> futurePage = ListSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSnapshotsPagedResponse((ListSnapshotsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSnapshotsPagedResponse(ListSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSchemaBundlesPagedResponse
    extends AbstractPagedListResponse<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle, ListSchemaBundlesPage, ListSchemaBundlesFixedSizeCollection> {
        public static ApiFuture<ListSchemaBundlesPagedResponse> createAsync(PageContext<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle> context, ApiFuture<ListSchemaBundlesResponse> futureResponse) {
            ApiFuture<ListSchemaBundlesPage> futurePage = ListSchemaBundlesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSchemaBundlesPagedResponse((ListSchemaBundlesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSchemaBundlesPagedResponse(ListSchemaBundlesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSchemaBundlesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSchemaBundlesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle, ListSchemaBundlesPage, ListSchemaBundlesFixedSizeCollection> {
        private ListSchemaBundlesFixedSizeCollection(List<ListSchemaBundlesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSchemaBundlesFixedSizeCollection createEmptyCollection() {
            return new ListSchemaBundlesFixedSizeCollection(null, 0);
        }

        protected ListSchemaBundlesFixedSizeCollection createCollection(List<ListSchemaBundlesPage> pages, int collectionSize) {
            return new ListSchemaBundlesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSchemaBundlesPage
    extends AbstractPage<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle, ListSchemaBundlesPage> {
        private ListSchemaBundlesPage(PageContext<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle> context, ListSchemaBundlesResponse response) {
            super(context, (Object)response);
        }

        private static ListSchemaBundlesPage createEmptyPage() {
            return new ListSchemaBundlesPage(null, null);
        }

        protected ListSchemaBundlesPage createPage(PageContext<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle> context, ListSchemaBundlesResponse response) {
            return new ListSchemaBundlesPage(context, response);
        }

        public ApiFuture<ListSchemaBundlesPage> createPageAsync(PageContext<ListSchemaBundlesRequest, ListSchemaBundlesResponse, SchemaBundle> context, ApiFuture<ListSchemaBundlesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        private ListSnapshotsFixedSizeCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListSnapshotsFixedSizeCollection createCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            return new ListSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotsPage
    extends AbstractPage<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage> {
        private ListSnapshotsPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListSnapshotsPage createEmptyPage() {
            return new ListSnapshotsPage(null, null);
        }

        protected ListSnapshotsPage createPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            return new ListSnapshotsPage(context, response);
        }

        public ApiFuture<ListSnapshotsPage> createPageAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAuthorizedViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView, ListAuthorizedViewsPage, ListAuthorizedViewsFixedSizeCollection> {
        private ListAuthorizedViewsFixedSizeCollection(List<ListAuthorizedViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAuthorizedViewsFixedSizeCollection createEmptyCollection() {
            return new ListAuthorizedViewsFixedSizeCollection(null, 0);
        }

        protected ListAuthorizedViewsFixedSizeCollection createCollection(List<ListAuthorizedViewsPage> pages, int collectionSize) {
            return new ListAuthorizedViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAuthorizedViewsPage
    extends AbstractPage<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView, ListAuthorizedViewsPage> {
        private ListAuthorizedViewsPage(PageContext<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView> context, ListAuthorizedViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListAuthorizedViewsPage createEmptyPage() {
            return new ListAuthorizedViewsPage(null, null);
        }

        protected ListAuthorizedViewsPage createPage(PageContext<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView> context, ListAuthorizedViewsResponse response) {
            return new ListAuthorizedViewsPage(context, response);
        }

        public ApiFuture<ListAuthorizedViewsPage> createPageAsync(PageContext<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse, AuthorizedView> context, ApiFuture<ListAuthorizedViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTablesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        private ListTablesFixedSizeCollection(List<ListTablesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTablesFixedSizeCollection createEmptyCollection() {
            return new ListTablesFixedSizeCollection(null, 0);
        }

        protected ListTablesFixedSizeCollection createCollection(List<ListTablesPage> pages, int collectionSize) {
            return new ListTablesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTablesPage
    extends AbstractPage<ListTablesRequest, ListTablesResponse, Table, ListTablesPage> {
        private ListTablesPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            super(context, (Object)response);
        }

        private static ListTablesPage createEmptyPage() {
            return new ListTablesPage(null, null);
        }

        protected ListTablesPage createPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            return new ListTablesPage(context, response);
        }

        public ApiFuture<ListTablesPage> createPageAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

