/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import javax.annotation.Nonnull;

@InternalApi
public class HeaderTracerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;

    public HeaderTracerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> callable) {
        this.innerCallable = (ServerStreamingCallable)Preconditions.checkNotNull(callable, (Object)"Inner callable must be set");
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        if (RpcViews.isGfeMetricsRegistered() && context.getTracer() instanceof BigtableTracer) {
            HeaderTracerResponseObserver<ResponseT> innerObserver = new HeaderTracerResponseObserver<ResponseT>(responseObserver, (BigtableTracer)context.getTracer(), responseMetadata);
            this.innerCallable.call(request, innerObserver, (ApiCallContext)responseMetadata.addHandlers(context));
        } else {
            this.innerCallable.call(request, responseObserver, context);
        }
    }

    private class HeaderTracerResponseObserver<ResponseT>
    implements ResponseObserver<ResponseT> {
        private final BigtableTracer tracer;
        private final ResponseObserver<ResponseT> outerObserver;
        private final GrpcResponseMetadata responseMetadata;

        HeaderTracerResponseObserver(ResponseObserver<ResponseT> observer, BigtableTracer tracer, GrpcResponseMetadata metadata) {
            this.tracer = tracer;
            this.outerObserver = observer;
            this.responseMetadata = metadata;
        }

        public void onStart(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        public void onResponse(ResponseT response) {
            this.outerObserver.onResponse(response);
        }

        public void onError(Throwable t) {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, t);
            this.outerObserver.onError(t);
        }

        public void onComplete() {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, null);
            this.outerObserver.onComplete();
        }
    }
}

