/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;

@InternalApi(value="For internal use only")
public class MutateRowsBatchingDescriptor
implements BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> {
    public BatchingRequestBuilder<RowMutationEntry, BulkMutation> newRequestBuilder(BulkMutation prototype) {
        return new RequestBuilder(prototype);
    }

    public void splitResponse(Void response, List<SettableApiFuture<Void>> batch) {
        for (SettableApiFuture<Void> batchResponse : batch) {
            batchResponse.set(null);
        }
    }

    public void splitException(Throwable throwable, List<SettableApiFuture<Void>> batch) {
        if (!(throwable instanceof MutateRowsException)) {
            for (SettableApiFuture<Void> future : batch) {
                future.setException(throwable);
            }
            return;
        }
        List<MutateRowsException.FailedMutation> failedMutations = ((MutateRowsException)((Object)throwable)).getFailedMutations();
        HashMap entryErrors = Maps.newHashMap();
        for (MutateRowsException.FailedMutation failure : failedMutations) {
            entryErrors.put(failure.getIndex(), failure.getError());
        }
        int i = 0;
        for (SettableApiFuture<Void> entryResultFuture : batch) {
            Throwable entryError;
            if ((entryError = (Throwable)entryErrors.get(i++)) == null) {
                entryResultFuture.set(null);
                continue;
            }
            entryResultFuture.setException(entryError);
        }
    }

    public long countBytes(RowMutationEntry entry) {
        return entry.toProto().getSerializedSize();
    }

    static class RequestBuilder
    implements BatchingRequestBuilder<RowMutationEntry, BulkMutation> {
        private BulkMutation bulkMutation;

        RequestBuilder(BulkMutation prototype) {
            this.bulkMutation = prototype.clone();
        }

        public void add(RowMutationEntry entry) {
            this.bulkMutation.add(entry);
        }

        public BulkMutation build() {
            return this.bulkMutation;
        }
    }
}

