/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Preconditions;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class MeasuredReadRowsCallable<RowT>
extends ServerStreamingCallable<Query, RowT> {
    private final ServerStreamingCallable<Query, RowT> innerCallable;
    private final TagValue methodName;
    private final TagContext parentCtx;
    private final Tagger tagger;
    private final StatsRecorder stats;
    private final ApiClock clock;

    public MeasuredReadRowsCallable(@Nonnull ServerStreamingCallable<Query, RowT> innerCallable, @Nonnull String methodName, @Nonnull Tagger tagger, @Nonnull StatsRecorder stats, @Nonnull ApiClock clock) {
        this.innerCallable = (ServerStreamingCallable)Preconditions.checkNotNull(innerCallable, (Object)"innerCallable");
        this.methodName = TagValue.create((String)((String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName")));
        this.tagger = (Tagger)Preconditions.checkNotNull((Object)tagger, (Object)"tagger");
        this.parentCtx = tagger.getCurrentTagContext();
        this.stats = (StatsRecorder)Preconditions.checkNotNull((Object)stats, (Object)"stats");
        this.clock = (ApiClock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
    }

    public void call(Query request, ResponseObserver<RowT> outerObserver, ApiCallContext context) {
        this.innerCallable.call((Object)request, (ResponseObserver)new MeasuredResponseObserver(outerObserver), context);
    }

    private class MeasuredResponseObserver
    implements ResponseObserver<RowT> {
        private final ResponseObserver<RowT> outerResponseObserver;
        private final long operationStart;
        private Long firstRowReceivedAt = null;
        private long rowsRead = 0L;

        private MeasuredResponseObserver(ResponseObserver<RowT> outerResponseObserver) {
            this.outerResponseObserver = (ResponseObserver)Preconditions.checkNotNull(outerResponseObserver, (Object)"outerResponseObserver");
            this.operationStart = MeasuredReadRowsCallable.this.clock.nanoTime();
        }

        public void onStart(StreamController controller) {
            this.outerResponseObserver.onStart(controller);
        }

        public void onResponse(RowT row) {
            if (this.firstRowReceivedAt == null) {
                this.firstRowReceivedAt = MeasuredReadRowsCallable.this.clock.nanoTime();
            }
            ++this.rowsRead;
            this.outerResponseObserver.onResponse(row);
        }

        public void onError(Throwable t) {
            this.recordStats(t);
            this.outerResponseObserver.onError(t);
        }

        public void onComplete() {
            this.recordStats(null);
            this.outerResponseObserver.onComplete();
        }

        private void recordStats(@Nullable Throwable error) {
            long now = MeasuredReadRowsCallable.this.clock.nanoTime();
            long elapsed = TimeUnit.NANOSECONDS.toMillis(now - this.operationStart);
            MeasureMap measures = MeasuredReadRowsCallable.this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_OP_LATENCY, (double)elapsed).put(RpcMeasureConstants.BIGTABLE_ROWS_READ_PER_OP, this.rowsRead);
            if (this.firstRowReceivedAt != null) {
                long firstRowLatency = TimeUnit.NANOSECONDS.toMillis(this.firstRowReceivedAt - this.operationStart);
                measures.put(RpcMeasureConstants.BIGTABLE_READ_ROWS_FIRST_ROW_LATENCY, (double)firstRowLatency);
            }
            measures.record(MeasuredReadRowsCallable.this.tagger.toBuilder(MeasuredReadRowsCallable.this.parentCtx).putLocal(RpcMeasureConstants.BIGTABLE_OP, MeasuredReadRowsCallable.this.methodName).putLocal(RpcMeasureConstants.BIGTABLE_STATUS, Util.extractStatus(error)).build());
        }
    }
}

