/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.data.v2.stub.metrics.AutoValue_HeaderTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.common.base.MoreObjects;
import io.grpc.Metadata;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

@InternalApi
@AutoValue
public abstract class HeaderTracer {
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_HEADER_PATTERN = Pattern.compile(".*dur=(?<dur>\\d+)");

    public abstract Tagger getTagger();

    public abstract StatsRecorder getStats();

    public abstract Map<TagKey, TagValue> getStatsAttributes();

    public void recordGfeMetadata(@Nonnull Metadata metadata, @Nonnull String spanName) {
        MeasureMap measures = this.getStats().newMeasureMap();
        if (metadata.get(SERVER_TIMING_HEADER_KEY) != null) {
            String serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY);
            Matcher matcher = SERVER_TIMING_HEADER_PATTERN.matcher(serverTiming);
            measures.put(RpcMeasureConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT, 0L);
            if (matcher.find()) {
                long latency = Long.valueOf(matcher.group("dur"));
                measures.put(RpcMeasureConstants.BIGTABLE_GFE_LATENCY, latency);
            }
        } else {
            measures.put(RpcMeasureConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT, 1L);
        }
        measures.record(this.newTagCtxBuilder(spanName).build());
    }

    public void recordGfeMissingHeader(@Nonnull String spanName) {
        MeasureMap measures = this.getStats().newMeasureMap().put(RpcMeasureConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT, 1L);
        measures.record(this.newTagCtxBuilder(spanName).build());
    }

    private TagContextBuilder newTagCtxBuilder(String span) {
        TagContextBuilder tagContextBuilder = this.getTagger().currentBuilder();
        if (span != null) {
            tagContextBuilder.putLocal(RpcMeasureConstants.BIGTABLE_OP, TagValue.create((String)span));
        }
        for (Map.Entry<TagKey, TagValue> entry : this.getStatsAttributes().entrySet()) {
            tagContextBuilder.putLocal(entry.getKey(), entry.getValue());
        }
        return tagContextBuilder;
    }

    public static Builder newBuilder() {
        return new AutoValue_HeaderTracer.Builder().setTagger(Tags.getTagger()).setStats(Stats.getStatsRecorder()).setStatsAttributes(Collections.emptyMap());
    }

    public abstract Builder toBuilder();

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stats", (Object)this.getStats()).add("tagger", (Object)this.getTagger()).add("statsAttributes", this.getStatsAttributes()).toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTagger(@Nonnull Tagger var1);

        public abstract Builder setStats(@Nonnull StatsRecorder var1);

        public abstract Builder setStatsAttributes(@Nonnull Map<TagKey, TagValue> var1);

        abstract HeaderTracer autoBuild();

        public HeaderTracer build() {
            HeaderTracer headerTracer = this.autoBuild();
            return headerTracer;
        }
    }
}

