/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.List;

public class DefaultRowAdapter
implements RowAdapter<Row> {
    @Override
    public boolean isScanMarkerRow(Row row) {
        return row.getCells().isEmpty();
    }

    @Override
    public RowAdapter.RowBuilder<Row> createRowBuilder() {
        return new DefaultRowBuilder();
    }

    @Override
    public ByteString getKey(Row row) {
        return row.getKey();
    }

    public class DefaultRowBuilder
    implements RowAdapter.RowBuilder<Row> {
        private ByteString currentKey;
        private ImmutableList.Builder<RowCell> cells;
        private String family;
        private ByteString qualifier;
        private List<String> labels;
        private long timestamp;
        private ByteString value;

        @Override
        public Row createScanMarkerRow(ByteString key) {
            return Row.create(key, (List<RowCell>)ImmutableList.of());
        }

        @Override
        public void startRow(ByteString key) {
            this.currentKey = key;
            this.cells = ImmutableList.builder();
        }

        @Override
        public void startCell(String family, ByteString qualifier, long timestamp, List<String> labels, long size) {
            this.family = family;
            this.qualifier = qualifier;
            this.timestamp = timestamp;
            this.labels = labels;
            this.value = ByteString.EMPTY;
        }

        @Override
        public void cellValue(ByteString value) {
            this.value = this.value.concat(value);
        }

        @Override
        public void finishCell() {
            this.cells.add((Object)RowCell.create(this.family, this.qualifier, this.timestamp, this.labels, this.value));
        }

        @Override
        public Row finishRow() {
            return Row.create(this.currentKey, (List<RowCell>)this.cells.build());
        }

        @Override
        public void reset() {
            this.currentKey = null;
            this.cells = null;
            this.family = null;
            this.qualifier = null;
            this.labels = null;
            this.timestamp = 0L;
            this.value = null;
        }
    }
}

