/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.StreamConnection;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.Int64Value;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class StreamWriter
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriter.class.getName());
    private Lock lock = new ReentrantLock();
    private Condition hasMessageInWaitingQueue = this.lock.newCondition();
    private Condition inflightReduced = this.lock.newCondition();
    private final String streamName;
    private final ProtoSchema writerSchema;
    private final long maxInflightRequests;
    private final long maxInflightBytes;
    private final String traceId;
    @GuardedBy(value="lock")
    private long inflightRequests = 0L;
    @GuardedBy(value="lock")
    private long inflightBytes = 0L;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> waitingRequestQueue;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> inflightRequestQueue;
    private BigQueryWriteClient client;
    private boolean ownsBigQueryWriteClient = false;
    private StreamConnection streamConnection;
    private Thread appendThread;

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private StreamWriter(Builder builder) throws IOException {
        this.streamName = builder.streamName;
        if (builder.writerSchema == null) {
            throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("Writer schema must be provided when building this writer."));
        }
        this.writerSchema = builder.writerSchema;
        this.maxInflightRequests = builder.maxInflightRequest;
        this.maxInflightBytes = builder.maxInflightBytes;
        this.traceId = builder.traceId;
        this.waitingRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.inflightRequestQueue = new LinkedList<AppendRequestAndResponse>();
        if (builder.client == null) {
            BigQueryWriteSettings stubSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(builder.channelProvider)).setEndpoint(builder.endpoint)).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"x-goog-request-params", "write_stream=" + this.streamName}))).build();
            this.client = BigQueryWriteClient.create(stubSettings);
            this.ownsBigQueryWriteClient = true;
        } else {
            this.client = builder.client;
            this.ownsBigQueryWriteClient = false;
        }
        this.streamConnection = new StreamConnection(this.client, new StreamConnection.RequestCallback(){

            @Override
            public void run(AppendRowsResponse response) {
                StreamWriter.this.requestCallback(response);
            }
        }, new StreamConnection.DoneCallback(){

            @Override
            public void run(Throwable finalStatus) {
                StreamWriter.this.doneCallback(finalStatus);
            }
        });
        this.appendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StreamWriter.this.appendLoop();
            }
        });
        this.appendThread.start();
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows, long offset) {
        AppendRowsRequest.Builder requestBuilder = AppendRowsRequest.newBuilder();
        requestBuilder.setProtoRows(AppendRowsRequest.ProtoData.newBuilder().setRows(rows).build());
        if (offset >= 0L) {
            requestBuilder.setOffset(Int64Value.of((long)offset));
        }
        return this.appendInternal(requestBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<AppendRowsResponse> appendInternal(AppendRowsRequest message) {
        AppendRequestAndResponse requestWrapper = new AppendRequestAndResponse(message);
        if (requestWrapper.messageSize > StreamWriter.getApiMaxRequestBytes()) {
            requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("MessageSize is too large. Max allow: " + StreamWriter.getApiMaxRequestBytes() + " Actual: " + requestWrapper.messageSize)));
            return requestWrapper.appendResult;
        }
        this.lock.lock();
        try {
            if (this.userClosed) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is already closed")));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            if (this.connectionFinalStatus != null) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is closed due to " + this.connectionFinalStatus.toString())));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            ++this.inflightRequests;
            this.inflightBytes += requestWrapper.messageSize;
            this.waitingRequestQueue.addLast(requestWrapper);
            this.hasMessageInWaitingQueue.signal();
            this.maybeWaitForInflightQuota();
            SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
            return settableApiFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void maybeWaitForInflightQuota() {
        while (this.inflightRequests >= this.maxInflightRequests || this.inflightBytes >= this.maxInflightBytes) {
            try {
                this.inflightReduced.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for inflight quota. Stream: " + this.streamName + " Error: " + e.toString());
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.CANCELLED).withCause((Throwable)e).withDescription("Interrupted while waiting for quota."));
            }
        }
    }

    @Override
    public void close() {
        log.info("User closing stream: " + this.streamName);
        this.lock.lock();
        try {
            this.userClosed = true;
        }
        finally {
            this.lock.unlock();
        }
        log.fine("Waiting for append thread to finish. Stream: " + this.streamName);
        try {
            this.appendThread.join();
            log.info("User close complete. Stream: " + this.streamName);
        }
        catch (InterruptedException e) {
            log.warning("Append handler join is interrupted. Stream: " + this.streamName + " Error: " + e.toString());
        }
        if (this.ownsBigQueryWriteClient) {
            this.client.close();
            try {
                this.client.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLoop() {
        boolean isFirstRequestInConnection = true;
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        while (!this.waitingQueueDrained()) {
            this.lock.lock();
            try {
                this.hasMessageInWaitingQueue.await(100L, TimeUnit.MILLISECONDS);
                while (!this.waitingRequestQueue.isEmpty()) {
                    AppendRequestAndResponse requestWrapper = this.waitingRequestQueue.pollFirst();
                    this.inflightRequestQueue.addLast(requestWrapper);
                    localQueue.addLast(requestWrapper);
                }
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for message. Stream: " + this.streamName + " Error: " + e.toString());
            }
            finally {
                this.lock.unlock();
            }
            if (localQueue.isEmpty()) continue;
            while (!localQueue.isEmpty()) {
                AppendRowsRequest preparedRequest = this.prepareRequestBasedOnPosition(((AppendRequestAndResponse)localQueue.pollFirst()).message, isFirstRequestInConnection);
                this.streamConnection.send(preparedRequest);
                isFirstRequestInConnection = false;
            }
        }
        log.fine("Cleanup starts. Stream: " + this.streamName);
        this.streamConnection.close();
        this.waitForDoneCallback();
        log.fine("Stream connection is fully closed. Cleaning up inflight requests. Stream: " + this.streamName);
        this.cleanupInflightRequests();
        log.fine("Append thread is done. Stream: " + this.streamName);
    }

    private boolean waitingQueueDrained() {
        this.lock.lock();
        try {
            boolean bl = (this.userClosed || this.connectionFinalStatus != null) && this.waitingRequestQueue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForDoneCallback() {
        log.fine("Waiting for done callback from stream connection. Stream: " + this.streamName);
        while (true) {
            this.lock.lock();
            try {
                if (this.connectionFinalStatus != null) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private AppendRowsRequest prepareRequestBasedOnPosition(AppendRowsRequest original, boolean isFirstRequest) {
        AppendRowsRequest.Builder requestBuilder = original.toBuilder();
        if (isFirstRequest) {
            if (this.writerSchema != null) {
                requestBuilder.getProtoRowsBuilder().setWriterSchema(this.writerSchema);
            }
            requestBuilder.setWriteStream(this.streamName);
            if (this.traceId != null) {
                requestBuilder.setTraceId(this.traceId);
            }
        } else {
            requestBuilder.clearWriteStream();
            requestBuilder.getProtoRowsBuilder().clearWriterSchema();
        }
        return requestBuilder.build();
    }

    private void cleanupInflightRequests() {
        Throwable finalStatus;
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        this.lock.lock();
        try {
            finalStatus = this.connectionFinalStatus;
            while (!this.inflightRequestQueue.isEmpty()) {
                localQueue.addLast(this.pollInflightRequestQueue());
            }
        }
        finally {
            this.lock.unlock();
        }
        log.fine("Cleaning " + localQueue.size() + " inflight requests with error: " + finalStatus.toString());
        while (!localQueue.isEmpty()) {
            ((AppendRequestAndResponse)localQueue.pollFirst()).appendResult.setException(finalStatus);
        }
    }

    private void requestCallback(AppendRowsResponse response) {
        AppendRequestAndResponse requestWrapper;
        this.lock.lock();
        try {
            requestWrapper = this.pollInflightRequestQueue();
        }
        finally {
            this.lock.unlock();
        }
        if (response.hasError()) {
            StatusRuntimeException exception = new StatusRuntimeException(Status.fromCodeValue((int)response.getError().getCode()).withDescription(response.getError().getMessage()));
            requestWrapper.appendResult.setException((Throwable)exception);
        } else {
            requestWrapper.appendResult.set((Object)response);
        }
    }

    private void doneCallback(Throwable finalStatus) {
        log.fine("Received done callback. Stream: " + this.streamName + " Final status: " + finalStatus.toString());
        this.lock.lock();
        try {
            this.connectionFinalStatus = finalStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private AppendRequestAndResponse pollInflightRequestQueue() {
        AppendRequestAndResponse requestWrapper = this.inflightRequestQueue.pollFirst();
        --this.inflightRequests;
        this.inflightBytes -= requestWrapper.messageSize;
        this.inflightReduced.signal();
        return requestWrapper;
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    private static final class AppendRequestAndResponse {
        final SettableApiFuture<AppendRowsResponse> appendResult = SettableApiFuture.create();
        final AppendRowsRequest message;
        final long messageSize;

        AppendRequestAndResponse(AppendRowsRequest message) {
            this.message = message;
            this.messageSize = message.getProtoRows().getSerializedSize();
        }
    }

    public static final class Builder {
        private static final long DEFAULT_MAX_INFLIGHT_REQUESTS = 1000L;
        private static final long DEFAULT_MAX_INFLIGHT_BYTES = 0x6400000L;
        private String streamName;
        private BigQueryWriteClient client;
        private ProtoSchema writerSchema = null;
        private long maxInflightRequest = 1000L;
        private long maxInflightBytes = 0x6400000L;
        private String endpoint = BigQueryWriteSettings.getDefaultEndpoint();
        private TransportChannelProvider channelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private CredentialsProvider credentialsProvider = BigQueryWriteSettings.defaultCredentialsProviderBuilder().build();
        private String traceId = null;

        private Builder(String streamName) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = null;
        }

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = (BigQueryWriteClient)Preconditions.checkNotNull((Object)client);
        }

        public Builder setWriterSchema(ProtoSchema writerSchema) {
            this.writerSchema = writerSchema;
            return this;
        }

        public Builder setMaxInflightRequests(long value) {
            this.maxInflightRequest = value;
            return this;
        }

        public Builder setMaxInflightBytes(long value) {
            this.maxInflightBytes = value;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setTraceId(String traceId) {
            int colonIndex = traceId.indexOf(58);
            if (colonIndex == -1 || colonIndex == 0 || colonIndex == traceId.length() - 1) {
                throw new IllegalArgumentException("TraceId must follow the format of A:B. Actual:" + traceId);
            }
            this.traceId = traceId;
            return this;
        }

        public StreamWriter build() throws IOException {
            return new StreamWriter(this);
        }
    }
}

