/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.pathtemplate.ValidationException;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.UninitializedMessageException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;

public class JsonToProtoMessage {
    private static final Logger LOG = Logger.getLogger(JsonToProtoMessage.class.getName());
    private static int NUMERIC_SCALE = 9;
    private static ImmutableMap<Descriptors.FieldDescriptor.Type, String> FieldTypeToDebugMessage = new ImmutableMap.Builder().put((Object)Descriptors.FieldDescriptor.Type.BOOL, (Object)"boolean").put((Object)Descriptors.FieldDescriptor.Type.BYTES, (Object)"bytes").put((Object)Descriptors.FieldDescriptor.Type.INT32, (Object)"int32").put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, (Object)"double").put((Object)Descriptors.FieldDescriptor.Type.INT64, (Object)"int64").put((Object)Descriptors.FieldDescriptor.Type.STRING, (Object)"string").put((Object)Descriptors.FieldDescriptor.Type.MESSAGE, (Object)"object").build();
    private static final DateTimeFormatter timestampFormatter = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ofPattern((String)"yyyy[/][-]MM[/][-]dd")).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendValue((TemporalField)ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue((TemporalField)ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue((TemporalField)ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendValue((TemporalField)ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendFraction((TemporalField)ChronoField.MICRO_OF_SECOND, 3, 6, true).optionalEnd().optionalStart().appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 6, 9, true).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd().optionalStart().appendZoneText(TextStyle.SHORT).optionalEnd().optionalStart().appendLiteral('Z').optionalEnd().toFormatter().withZone((ZoneId)ZoneOffset.UTC);

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return JsonToProtoMessage.convertJsonToProtoMessageImpl(protoSchema, null, json, "root", true, false);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return JsonToProtoMessage.convertJsonToProtoMessageImpl(protoSchema, tableSchema.getFieldsList(), json, "root", true, false);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return JsonToProtoMessage.convertJsonToProtoMessageImpl(protoSchema, tableSchema.getFieldsList(), json, "root", true, ignoreUnknownFields);
    }

    private static DynamicMessage convertJsonToProtoMessageImpl(Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableSchema, JSONObject json, String jsonScope, boolean topLevel, boolean ignoreUnknownFields) throws IllegalArgumentException {
        DynamicMessage msg;
        DynamicMessage.Builder protoMsg = DynamicMessage.newBuilder((Descriptors.Descriptor)protoSchema);
        String[] jsonNames = JSONObject.getNames((JSONObject)json);
        if (jsonNames == null) {
            return protoMsg.build();
        }
        for (int i = 0; i < jsonNames.length; ++i) {
            String jsonName = jsonNames[i];
            String jsonFieldLocator = jsonName.toLowerCase();
            if (!BigQuerySchemaUtil.isProtoCompatible(jsonFieldLocator)) {
                jsonFieldLocator = BigQuerySchemaUtil.generatePlaceholderFieldName(jsonFieldLocator);
            }
            String currentScope = jsonScope + "." + jsonName;
            Descriptors.FieldDescriptor field = protoSchema.findFieldByName(jsonFieldLocator);
            if (field == null && !ignoreUnknownFields) {
                throw new Exceptions.JsonDataHasUnknownFieldException(currentScope);
            }
            if (field == null) continue;
            TableFieldSchema fieldSchema = null;
            if (tableSchema != null && !(fieldSchema = tableSchema.get(field.getIndex())).getName().toLowerCase().equals(BigQuerySchemaUtil.getFieldName(field))) {
                throw new ValidationException("Field at index " + field.getIndex() + " has mismatch names (" + fieldSchema.getName() + ") (" + field.getName() + ")", new Object[0]);
            }
            try {
                if (!field.isRepeated()) {
                    JsonToProtoMessage.fillField(protoMsg, field, fieldSchema, json, jsonName, currentScope, ignoreUnknownFields);
                    continue;
                }
                JsonToProtoMessage.fillRepeatedField(protoMsg, field, fieldSchema, json, jsonName, currentScope, ignoreUnknownFields);
                continue;
            }
            catch (Exceptions.FieldParseError ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new Exceptions.FieldParseError(currentScope, fieldSchema != null ? fieldSchema.getType().name() : field.getType().name(), ex);
            }
        }
        try {
            msg = protoMsg.build();
        }
        catch (UninitializedMessageException e) {
            String errorMsg = e.getMessage();
            int idxOfColon = errorMsg.indexOf(":");
            String missingFieldName = errorMsg.substring(idxOfColon + 2);
            throw new IllegalArgumentException(String.format("JSONObject does not have the required field %s.%s.", jsonScope, missingFieldName));
        }
        return msg;
    }

    private static void fillField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Object val = json.get(exactJsonKeyName);
        if (val == JSONObject.NULL) {
            return;
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (val instanceof Boolean) {
                    protoMsg.setField(fieldDescriptor, (Object)((Boolean)val));
                    return;
                }
                if (!(val instanceof String) || !"true".equals(((String)val).toLowerCase()) && !"false".equals(((String)val).toLowerCase())) break;
                protoMsg.setField(fieldDescriptor, (Object)Boolean.parseBoolean((String)val));
                return;
            }
            case BYTES: {
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(NUMERIC_SCALE, RoundingMode.HALF_UP);
                            }
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            return;
                        }
                    }
                }
                if (val instanceof ByteString) {
                    protoMsg.setField(fieldDescriptor, (Object)((ByteString)val).toByteArray());
                    return;
                }
                if (!(val instanceof JSONArray)) break;
                byte[] bytes = new byte[((JSONArray)val).length()];
                for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                    bytes[j] = (byte)((JSONArray)val).getInt(j);
                    if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                    throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + j + "] could not be converted to byte[].", new Object[0]));
                }
                protoMsg.setField(fieldDescriptor, (Object)bytes);
                return;
            }
            case INT64: {
                Long parsed;
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((CharSequence)((String)val))));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)((Long)val));
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64TimeMicros(LocalTime.parse((CharSequence)((String)val))));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)((Long)val));
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        if (val instanceof String) {
                            Double parsed2 = Doubles.tryParse((String)((String)val));
                            if (parsed2 != null) {
                                protoMsg.setField(fieldDescriptor, (Object)(parsed2.longValue() * 10000000L));
                                return;
                            }
                            TemporalAccessor parsedTime = timestampFormatter.parse((CharSequence)((String)val));
                            protoMsg.setField(fieldDescriptor, (Object)(parsedTime.getLong((TemporalField)ChronoField.INSTANT_SECONDS) * 1000000L + parsedTime.getLong((TemporalField)ChronoField.MICRO_OF_SECOND)));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)((Long)val));
                            return;
                        }
                        if (val instanceof Integer) {
                            protoMsg.setField(fieldDescriptor, (Object)(new Long(((Integer)val).intValue()) * 10000000L));
                            return;
                        }
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, (Object)new Long(((Integer)val).intValue()));
                    return;
                }
                if (val instanceof Long) {
                    protoMsg.setField(fieldDescriptor, (Object)((Long)val));
                    return;
                }
                if (!(val instanceof String) || (parsed = Longs.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case INT32: {
                Integer parsed;
                if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                    if (val instanceof String) {
                        protoMsg.setField(fieldDescriptor, (Object)((int)LocalDate.parse((String)val).toEpochDay()));
                        return;
                    }
                    if (val instanceof Integer || val instanceof Long) {
                        protoMsg.setField(fieldDescriptor, (Object)((Number)val).intValue());
                        return;
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, (Object)((Integer)val));
                    return;
                }
                if (!(val instanceof String) || (parsed = Ints.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case STRING: {
                if (!(val instanceof String)) break;
                protoMsg.setField(fieldDescriptor, (Object)((String)val));
                return;
            }
            case DOUBLE: {
                Double parsed;
                if (val instanceof Number) {
                    protoMsg.setField(fieldDescriptor, (Object)((Number)val).doubleValue());
                    return;
                }
                if (!(val instanceof String) || (parsed = Doubles.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case MESSAGE: {
                if (!(val instanceof JSONObject)) break;
                DynamicMessage.Builder message = protoMsg.newBuilderForField(fieldDescriptor);
                protoMsg.setField(fieldDescriptor, (Object)JsonToProtoMessage.convertJsonToProtoMessageImpl(fieldDescriptor.getMessageType(), fieldSchema == null ? null : fieldSchema.getFieldsList(), json.getJSONObject(exactJsonKeyName), currentScope, false, ignoreUnknownFields));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s.", FieldTypeToDebugMessage.get((Object)fieldDescriptor.getType()), currentScope));
    }

    private static void fillRepeatedField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        JSONArray jsonArray;
        try {
            jsonArray = json.getJSONArray(exactJsonKeyName);
        }
        catch (JSONException e) {
            Object val = json.get(exactJsonKeyName);
            if (val == JSONObject.NULL) {
                return;
            }
            throw new IllegalArgumentException("JSONObject does not have a array field at " + currentScope + ".");
        }
        boolean fail = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object val = jsonArray.get(i);
            int index = i;
            switch (fieldDescriptor.getType()) {
                case BOOL: {
                    if (val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Boolean)val));
                        break;
                    }
                    if (val instanceof String && ("true".equals(((String)val).toLowerCase()) || "false".equals(((String)val).toLowerCase()))) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)Boolean.parseBoolean((String)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case BYTES: {
                    Boolean added = false;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(NUMERIC_SCALE, RoundingMode.HALF_UP);
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    } else if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    }
                    if (added.booleanValue()) break;
                    if (val instanceof ByteString) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((ByteString)val).toByteArray());
                        break;
                    }
                    if (val instanceof byte[]) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        break;
                    }
                    if (val instanceof JSONArray) {
                        try {
                            byte[] bytes = new byte[((JSONArray)val).length()];
                            for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                                bytes[j] = (byte)((JSONArray)val).getInt(j);
                                if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                                throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)bytes);
                            break;
                        }
                        catch (JSONException e) {
                            throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                        }
                    }
                    fail = true;
                    break;
                }
                case INT64: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((CharSequence)((String)val))));
                            break;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((Long)val));
                            break;
                        }
                        fail = true;
                        break;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64TimeMicros(LocalTime.parse((CharSequence)((String)val))));
                            break;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((Long)val));
                            break;
                        }
                        fail = true;
                        break;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        if (val instanceof String) {
                            parsed = Doubles.tryParse((String)((String)val));
                            if (parsed != null) {
                                protoMsg.addRepeatedField(fieldDescriptor, (Object)(((Double)parsed).longValue() * 10000000L));
                                break;
                            }
                            TemporalAccessor parsedTime = timestampFormatter.parse((CharSequence)((String)val));
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)(parsedTime.getLong((TemporalField)ChronoField.INSTANT_SECONDS) * 1000000L + parsedTime.getLong((TemporalField)ChronoField.MICRO_OF_SECOND)));
                            break;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((Long)val));
                            break;
                        }
                        if (val instanceof Integer) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)(new Long(((Integer)val).intValue()) * 10000000L));
                            break;
                        }
                        fail = true;
                        break;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)new Long(((Integer)val).intValue()));
                        break;
                    }
                    if (val instanceof Long) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Long)val));
                        break;
                    }
                    if (val instanceof String) {
                        parsed = Longs.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            break;
                        }
                        fail = true;
                        break;
                    }
                    fail = true;
                    break;
                }
                case INT32: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((int)LocalDate.parse((String)val).toEpochDay()));
                            break;
                        }
                        if (val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((Number)val).intValue());
                            break;
                        }
                        fail = true;
                        break;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Integer)val));
                        break;
                    }
                    if (val instanceof String) {
                        parsed = Ints.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            break;
                        }
                        fail = true;
                        break;
                    }
                    fail = true;
                    break;
                }
                case STRING: {
                    if (val instanceof String) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((String)val));
                        break;
                    }
                    fail = true;
                    break;
                }
                case DOUBLE: {
                    Number parsed;
                    if (val instanceof Number) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Number)val).doubleValue());
                        break;
                    }
                    if (val instanceof String) {
                        parsed = Doubles.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            break;
                        }
                        fail = true;
                        break;
                    }
                    fail = true;
                    break;
                }
                case MESSAGE: {
                    if (val instanceof JSONObject) {
                        DynamicMessage.Builder message = protoMsg.newBuilderForField(fieldDescriptor);
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)JsonToProtoMessage.convertJsonToProtoMessageImpl(fieldDescriptor.getMessageType(), fieldSchema == null ? null : fieldSchema.getFieldsList(), jsonArray.getJSONObject(i), currentScope, false, ignoreUnknownFields));
                        break;
                    }
                    fail = true;
                }
            }
            if (!fail) continue;
            throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s[%d].", FieldTypeToDebugMessage.get((Object)fieldDescriptor.getType()), currentScope, index));
        }
    }
}

