/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.AnnotationsProto;
import com.google.protobuf.Descriptors;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;

public class BigQuerySchemaUtil {
    private static final String PROTO_COMPATIBLE_NAME_REGEXP = "[A-Za-z_][A-Za-z0-9_]*";
    private static final String PLACEHOLDER_FILED_NAME_PREFIX = "col_";
    private static final Pattern PROTO_COMPATIBLE_NAME_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");

    public static boolean isProtoCompatible(String fieldName) {
        return PROTO_COMPATIBLE_NAME_PATTERN.matcher(fieldName).matches();
    }

    public static String generatePlaceholderFieldName(String fieldName) {
        return PLACEHOLDER_FILED_NAME_PREFIX + Base64.getUrlEncoder().withoutPadding().encodeToString(fieldName.getBytes(StandardCharsets.UTF_8)).replace('-', '_');
    }

    public static String getFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getOptions().hasExtension(AnnotationsProto.columnName) ? (String)fieldDescriptor.getOptions().getExtension(AnnotationsProto.columnName) : fieldDescriptor.getName();
    }
}

