/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.FlowController;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.util.Errors;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.AutoValue_ConnectionWorker_Load;
import com.google.cloud.bigquery.storage.v1.AutoValue_ConnectionWorker_TableSchemaAndTimestamp;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.RowError;
import com.google.cloud.bigquery.storage.v1.StreamConnection;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.Int64Value;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class ConnectionWorker
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriter.class.getName());
    private Lock lock;
    private Condition hasMessageInWaitingQueue;
    private Condition inflightReduced;
    private static Duration maxRetryDuration = Duration.ofMinutes(5L);
    private ExecutorService threadPool = Executors.newFixedThreadPool(1);
    private String streamName;
    private ProtoSchema writerSchema;
    private final long maxInflightRequests;
    private final long maxInflightBytes;
    private final FlowController.LimitExceededBehavior limitExceededBehavior;
    private final String traceId;
    @GuardedBy(value="lock")
    private long inflightRequests = 0L;
    @GuardedBy(value="lock")
    private long inflightBytes = 0L;
    @GuardedBy(value="lock")
    private long conectionRetryCountWithoutCallback = 0L;
    @GuardedBy(value="lock")
    private long connectionRetryStartTime = 0L;
    @GuardedBy(value="lock")
    private boolean streamConnectionIsConnected = false;
    @GuardedBy(value="lock")
    private boolean inflightCleanuped = false;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> waitingRequestQueue;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> inflightRequestQueue;
    private final Set<String> destinationSet = ConcurrentHashMap.newKeySet();
    @GuardedBy(value="lock")
    private TableSchemaAndTimestamp updatedSchema;
    private BigQueryWriteClient client;
    private StreamConnection streamConnection;
    private Thread appendThread;
    private final AtomicLong inflightWaitSec = new AtomicLong(0L);
    private final String writerId = UUID.randomUUID().toString();

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    public ConnectionWorker(String streamName, ProtoSchema writerSchema, long maxInflightRequests, long maxInflightBytes, Duration maxRetryDuration, FlowController.LimitExceededBehavior limitExceededBehavior, String traceId, BigQueryWriteSettings clientSettings) throws IOException {
        this.lock = new ReentrantLock();
        this.hasMessageInWaitingQueue = this.lock.newCondition();
        this.inflightReduced = this.lock.newCondition();
        this.streamName = streamName;
        ConnectionWorker.maxRetryDuration = maxRetryDuration;
        if (writerSchema == null) {
            throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("Writer schema must be provided when building this writer."));
        }
        this.writerSchema = writerSchema;
        this.maxInflightRequests = maxInflightRequests;
        this.maxInflightBytes = maxInflightBytes;
        this.limitExceededBehavior = limitExceededBehavior;
        this.traceId = traceId;
        this.waitingRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.inflightRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.client = BigQueryWriteClient.create(clientSettings);
        this.appendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionWorker.this.appendLoop();
            }
        });
        this.appendThread.start();
    }

    private void resetConnection() {
        log.info("Reconnecting for stream:" + this.streamName);
        this.streamConnection = new StreamConnection(this.client, new StreamConnection.RequestCallback(){

            @Override
            public void run(AppendRowsResponse response) {
                ConnectionWorker.this.requestCallback(response);
            }
        }, new StreamConnection.DoneCallback(){

            @Override
            public void run(Throwable finalStatus) {
                ConnectionWorker.this.doneCallback(finalStatus);
            }
        });
    }

    ApiFuture<AppendRowsResponse> append(String streamName, ProtoSchema writerSchema, ProtoRows rows, long offset) {
        AppendRowsRequest.Builder requestBuilder = AppendRowsRequest.newBuilder();
        requestBuilder.setProtoRows(AppendRowsRequest.ProtoData.newBuilder().setWriterSchema(writerSchema).setRows(rows).build());
        if (offset >= 0L) {
            requestBuilder.setOffset(Int64Value.of((long)offset));
        }
        requestBuilder.setWriteStream(streamName);
        return this.appendInternal(requestBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<AppendRowsResponse> appendInternal(AppendRowsRequest message) {
        AppendRequestAndResponse requestWrapper = new AppendRequestAndResponse(message);
        if (requestWrapper.messageSize > ConnectionWorker.getApiMaxRequestBytes()) {
            requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("MessageSize is too large. Max allow: " + ConnectionWorker.getApiMaxRequestBytes() + " Actual: " + requestWrapper.messageSize)));
            return requestWrapper.appendResult;
        }
        this.lock.lock();
        try {
            if (this.userClosed) {
                requestWrapper.appendResult.setException((Throwable)((Object)new Exceptions.StreamWriterClosedException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Connection is already closed during append"), this.streamName, this.writerId)));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            if (this.limitExceededBehavior == FlowController.LimitExceededBehavior.ThrowException) {
                if (this.inflightRequests + 1L >= this.maxInflightRequests) {
                    throw new Exceptions.InflightRequestsLimitExceededException(this.writerId, this.maxInflightRequests);
                }
                if (this.inflightBytes + requestWrapper.messageSize >= this.maxInflightBytes) {
                    throw new Exceptions.InflightBytesLimitExceededException(this.writerId, this.maxInflightBytes);
                }
            }
            if (this.connectionFinalStatus != null) {
                requestWrapper.appendResult.setException((Throwable)((Object)new Exceptions.StreamWriterClosedException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Connection is closed due to " + this.connectionFinalStatus.toString()), this.streamName, this.writerId)));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            ++this.inflightRequests;
            this.inflightBytes += requestWrapper.messageSize;
            this.waitingRequestQueue.addLast(requestWrapper);
            this.hasMessageInWaitingQueue.signal();
            this.maybeWaitForInflightQuota();
            SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
            return settableApiFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void maybeWaitForInflightQuota() {
        long start_time = System.currentTimeMillis();
        while (this.inflightRequests >= this.maxInflightRequests || this.inflightBytes >= this.maxInflightBytes) {
            try {
                this.inflightReduced.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for inflight quota. Stream: " + this.streamName + " Error: " + e.toString());
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.CANCELLED).withCause((Throwable)e).withDescription("Interrupted while waiting for quota."));
            }
        }
        this.inflightWaitSec.set((System.currentTimeMillis() - start_time) / 1000L);
    }

    public long getInflightWaitSeconds() {
        return this.inflightWaitSec.longValue();
    }

    public String getWriterId() {
        return this.writerId;
    }

    @Override
    public void close() {
        log.info("User closing stream: " + this.streamName);
        this.lock.lock();
        try {
            this.userClosed = true;
        }
        finally {
            this.lock.unlock();
        }
        log.fine("Waiting for append thread to finish. Stream: " + this.streamName);
        try {
            this.appendThread.join();
            log.info("User close complete. Stream: " + this.streamName);
        }
        catch (InterruptedException e) {
            log.warning("Append handler join is interrupted. Stream: " + this.streamName + " Error: " + e.toString());
        }
        this.client.close();
        try {
            this.client.awaitTermination(150L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(3L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            log.warning("Close on thread pool for " + this.streamName + " is interrupted with exception: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLoop() {
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        boolean streamNeedsConnecting = false;
        boolean firstRequestForDestinationSwitch = true;
        boolean isMultiplexing = false;
        while (!this.waitingQueueDrained()) {
            this.lock.lock();
            try {
                this.hasMessageInWaitingQueue.await(100L, TimeUnit.MILLISECONDS);
                boolean bl = streamNeedsConnecting = !this.streamConnectionIsConnected && this.connectionFinalStatus == null;
                if (streamNeedsConnecting) {
                    while (!this.inflightRequestQueue.isEmpty()) {
                        this.waitingRequestQueue.addFirst(this.inflightRequestQueue.pollLast());
                    }
                }
                while (!this.waitingRequestQueue.isEmpty()) {
                    AppendRequestAndResponse requestWrapper = this.waitingRequestQueue.pollFirst();
                    this.inflightRequestQueue.addLast(requestWrapper);
                    localQueue.addLast(requestWrapper);
                }
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for message. Stream: " + this.streamName + " Error: " + e.toString());
            }
            finally {
                this.lock.unlock();
            }
            if (localQueue.isEmpty()) continue;
            if (streamNeedsConnecting) {
                this.lock.lock();
                try {
                    this.streamConnectionIsConnected = true;
                }
                finally {
                    this.lock.unlock();
                }
                this.resetConnection();
                firstRequestForDestinationSwitch = true;
            }
            while (!localQueue.isEmpty()) {
                AppendRowsRequest originalRequest = ((AppendRequestAndResponse)localQueue.pollFirst()).message;
                AppendRowsRequest.Builder originalRequestBuilder = originalRequest.toBuilder();
                if (!(originalRequest.getWriteStream().isEmpty() || this.streamName.isEmpty() || originalRequest.getWriteStream().equals(this.streamName))) {
                    this.streamName = originalRequest.getWriteStream();
                    isMultiplexing = true;
                    firstRequestForDestinationSwitch = true;
                }
                if (firstRequestForDestinationSwitch) {
                    this.destinationSet.add(this.streamName);
                    if (this.traceId != null) {
                        originalRequestBuilder.setTraceId(this.traceId);
                    }
                } else if (!isMultiplexing) {
                    originalRequestBuilder.clearWriteStream();
                }
                if (firstRequestForDestinationSwitch || !originalRequest.getProtoRows().getWriterSchema().equals((Object)this.writerSchema)) {
                    this.writerSchema = originalRequest.getProtoRows().getWriterSchema();
                } else {
                    originalRequestBuilder.getProtoRowsBuilder().clearWriterSchema();
                }
                firstRequestForDestinationSwitch = false;
                log.fine("Sending " + originalRequestBuilder.getProtoRows().getRows().getSerializedRowsCount() + " rows to stream '" + originalRequestBuilder.getWriteStream() + "'");
                this.streamConnection.send(originalRequestBuilder.build());
            }
        }
        log.fine("Cleanup starts. Stream: " + this.streamName);
        if (this.streamConnection != null) {
            this.streamConnection.close();
            this.waitForDoneCallback(3L, TimeUnit.MINUTES);
        }
        log.fine("Stream connection is fully closed. Cleaning up inflight requests. Stream: " + this.streamName);
        this.cleanupInflightRequests();
        log.fine("Append thread is done. Stream: " + this.streamName);
    }

    private boolean waitingQueueDrained() {
        this.lock.lock();
        try {
            boolean bl = (this.userClosed || this.connectionFinalStatus != null) && this.waitingRequestQueue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDoneCallback(long duration, TimeUnit timeUnit) {
        log.fine("Waiting for done callback from stream connection. Stream: " + this.streamName);
        long deadline = System.nanoTime() + timeUnit.toNanos(duration);
        while (System.nanoTime() <= deadline) {
            this.lock.lock();
            try {
                if (!this.streamConnectionIsConnected) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.lock.lock();
        try {
            if (this.connectionFinalStatus == null) {
                this.connectionFinalStatus = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.CANCELLED).withDescription("Timeout waiting for DoneCallback."));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void cleanupInflightRequests() {
        Object finalStatus = new Exceptions.StreamWriterClosedException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Connection is already closed, cleanup inflight request"), this.streamName, this.writerId);
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        this.lock.lock();
        try {
            if (this.connectionFinalStatus != null) {
                finalStatus = this.connectionFinalStatus;
            }
            while (!this.inflightRequestQueue.isEmpty()) {
                localQueue.addLast(this.pollInflightRequestQueue());
            }
            this.inflightCleanuped = true;
        }
        finally {
            this.lock.unlock();
        }
        log.fine("Cleaning " + localQueue.size() + " inflight requests with error: " + (Object)finalStatus);
        while (!localQueue.isEmpty()) {
            ((AppendRequestAndResponse)localQueue.pollFirst()).appendResult.setException((Throwable)finalStatus);
        }
    }

    private void requestCallback(AppendRowsResponse response) {
        AppendRequestAndResponse requestWrapper;
        block11: {
            if (!response.hasUpdatedSchema()) {
                log.fine(String.format("Got response on stream %s", response.toString()));
            } else {
                AppendRowsResponse responseWithUpdatedSchemaRemoved = response.toBuilder().clearUpdatedSchema().build();
                log.fine(String.format("Got response with schema updated (omitting updated schema in response here): %s", responseWithUpdatedSchemaRemoved.toString()));
            }
            this.lock.lock();
            if (response.hasUpdatedSchema()) {
                this.updatedSchema = TableSchemaAndTimestamp.create(System.nanoTime(), response.getUpdatedSchema());
            }
            try {
                if (this.conectionRetryCountWithoutCallback != 0L) {
                    this.conectionRetryCountWithoutCallback = 0L;
                }
                if (this.connectionRetryStartTime != 0L) {
                    this.connectionRetryStartTime = 0L;
                }
                if (!this.inflightRequestQueue.isEmpty()) {
                    requestWrapper = this.pollInflightRequestQueue();
                    break block11;
                }
                if (this.inflightCleanuped) {
                    return;
                }
                log.log(Level.WARNING, "Unexpected: request callback called on an empty inflight queue.");
                this.connectionFinalStatus = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Request callback called on an empty inflight queue."));
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
        this.threadPool.submit(() -> {
            if (response.hasError()) {
                Exceptions.StorageException storageException = Exceptions.toStorageException(response.getError(), null);
                log.fine(String.format("Got error message: %s", response.toString()));
                if (storageException != null) {
                    requestWrapper.appendResult.setException((Throwable)((Object)storageException));
                } else if (response.getRowErrorsCount() > 0) {
                    HashMap<Integer, String> rowIndexToErrorMessage = new HashMap<Integer, String>();
                    for (int i = 0; i < response.getRowErrorsCount(); ++i) {
                        RowError rowError = response.getRowErrors(i);
                        rowIndexToErrorMessage.put(Math.toIntExact(rowError.getIndex()), rowError.getMessage());
                    }
                    Exceptions.AppendSerializtionError exception = new Exceptions.AppendSerializtionError(response.getError().getCode(), response.getError().getMessage(), this.streamName, rowIndexToErrorMessage);
                    requestWrapper.appendResult.setException((Throwable)((Object)exception));
                } else {
                    StatusRuntimeException exception = new StatusRuntimeException(Status.fromCodeValue((int)response.getError().getCode()).withDescription(response.getError().getMessage()));
                    requestWrapper.appendResult.setException((Throwable)exception);
                }
            } else {
                requestWrapper.appendResult.set((Object)response);
            }
        });
    }

    private boolean isRetriableError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (Errors.isRetryableInternalStatus(status)) {
            return true;
        }
        return status.getCode() == Status.Code.ABORTED || status.getCode() == Status.Code.UNAVAILABLE || status.getCode() == Status.Code.CANCELLED;
    }

    private void doneCallback(Throwable finalStatus) {
        log.fine("Received done callback. Stream: " + this.streamName + " Final status: " + finalStatus.toString());
        this.lock.lock();
        try {
            this.streamConnectionIsConnected = false;
            if (this.connectionFinalStatus == null) {
                if (this.connectionRetryStartTime == 0L) {
                    this.connectionRetryStartTime = System.currentTimeMillis();
                }
                if (this.isRetriableError(finalStatus) && !this.userClosed && ((float)maxRetryDuration.toMillis() == 0.0f || System.currentTimeMillis() - this.connectionRetryStartTime <= maxRetryDuration.toMillis())) {
                    ++this.conectionRetryCountWithoutCallback;
                    log.info("Retriable error " + finalStatus.toString() + " received, retry count " + this.conectionRetryCountWithoutCallback + ", millis left to retry " + (maxRetryDuration.toMillis() - (System.currentTimeMillis() - this.connectionRetryStartTime)) + ", for stream " + this.streamName);
                } else {
                    Exceptions.StorageException storageException = Exceptions.toStorageException(finalStatus);
                    this.connectionFinalStatus = storageException != null ? storageException : finalStatus;
                    log.info("Connection finished with error " + finalStatus.toString() + " for stream " + this.streamName);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private AppendRequestAndResponse pollInflightRequestQueue() {
        AppendRequestAndResponse requestWrapper = this.inflightRequestQueue.pollFirst();
        --this.inflightRequests;
        this.inflightBytes -= requestWrapper.messageSize;
        this.inflightReduced.signal();
        return requestWrapper;
    }

    synchronized TableSchemaAndTimestamp getUpdatedSchema() {
        return this.updatedSchema;
    }

    public Load getLoad() {
        return Load.create(this.inflightBytes, this.inflightRequests, this.destinationSet.size(), this.maxInflightBytes, this.maxInflightRequests);
    }

    @AutoValue
    static abstract class TableSchemaAndTimestamp {
        TableSchemaAndTimestamp() {
        }

        abstract long updateTimeStamp();

        abstract TableSchema updatedSchema();

        static TableSchemaAndTimestamp create(long updateTimeStamp, TableSchema updatedSchema) {
            return new AutoValue_ConnectionWorker_TableSchemaAndTimestamp(updateTimeStamp, updatedSchema);
        }
    }

    @AutoValue
    public static abstract class Load {
        private static double overwhelmedInflightCount = 0.2;
        private static double overwhelmedInflightBytes = 0.2;
        public static final Comparator<Load> LOAD_COMPARATOR = Comparator.comparing(key -> (int)(key.inFlightRequestsBytes() / 1024L)).thenComparing(key -> (int)(key.inFlightRequestsCount() / 100L)).thenComparing(Load::destinationCount);
        public static final Comparator<Load> TEST_LOAD_COMPARATOR = Comparator.comparing(key -> (int)key.inFlightRequestsBytes()).thenComparing(key -> (int)key.inFlightRequestsCount()).thenComparing(Load::destinationCount);

        abstract long inFlightRequestsBytes();

        abstract long inFlightRequestsCount();

        abstract long destinationCount();

        abstract long maxInflightBytes();

        abstract long maxInflightCount();

        static Load create(long inFlightRequestsBytes, long inFlightRequestsCount, long destinationCount, long maxInflightBytes, long maxInflightCount) {
            return new AutoValue_ConnectionWorker_Load(inFlightRequestsBytes, inFlightRequestsCount, destinationCount, maxInflightBytes, maxInflightCount);
        }

        boolean isOverwhelmed() {
            return (double)this.inFlightRequestsCount() > overwhelmedInflightCount * (double)this.maxInflightCount() || (double)this.inFlightRequestsBytes() > overwhelmedInflightBytes * (double)this.maxInflightBytes();
        }

        @VisibleForTesting
        public static void setOverwhelmedBytesThreshold(double newThreshold) {
            overwhelmedInflightBytes = newThreshold;
        }

        @VisibleForTesting
        public static void setOverwhelmedCountsThreshold(double newThreshold) {
            overwhelmedInflightCount = newThreshold;
        }
    }

    private static final class AppendRequestAndResponse {
        final SettableApiFuture<AppendRowsResponse> appendResult = SettableApiFuture.create();
        final AppendRowsRequest message;
        final long messageSize;

        AppendRequestAndResponse(AppendRowsRequest message) {
            this.message = message;
            this.messageSize = message.getProtoRows().getSerializedSize();
        }
    }
}

