/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Logger;

public class StreamWriter
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriter.class.getName());
    private final ConnectionWorker connectionWorker;
    private final String streamName;
    private final String writerId = UUID.randomUUID().toString();

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private StreamWriter(Builder builder) throws IOException {
        boolean ownsBigQueryWriteClient;
        BigQueryWriteClient client;
        this.streamName = builder.streamName;
        if (builder.client == null) {
            BigQueryWriteSettings stubSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(builder.channelProvider)).setEndpoint(builder.endpoint)).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"x-goog-request-params", "write_stream=" + this.streamName}))).build();
            client = BigQueryWriteClient.create(stubSettings);
            ownsBigQueryWriteClient = true;
        } else {
            client = builder.client;
            ownsBigQueryWriteClient = false;
        }
        this.connectionWorker = new ConnectionWorker(builder.streamName, builder.writerSchema, builder.maxInflightRequest, builder.maxInflightBytes, builder.limitExceededBehavior, builder.traceId, client, ownsBigQueryWriteClient);
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows) {
        return this.append(rows, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows, long offset) {
        return this.connectionWorker.append(rows, offset);
    }

    public long getInflightWaitSeconds() {
        return this.connectionWorker.getInflightWaitSeconds();
    }

    public String getWriterId() {
        return this.connectionWorker.getWriterId();
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public void close() {
        this.connectionWorker.close();
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    public synchronized TableSchema getUpdatedSchema() {
        return this.connectionWorker.getUpdatedSchema();
    }

    public static final class Builder {
        private static final long DEFAULT_MAX_INFLIGHT_REQUESTS = 1000L;
        private static final long DEFAULT_MAX_INFLIGHT_BYTES = 0x6400000L;
        private String streamName;
        private BigQueryWriteClient client;
        private ProtoSchema writerSchema = null;
        private long maxInflightRequest = 1000L;
        private long maxInflightBytes = 0x6400000L;
        private String endpoint = BigQueryWriteSettings.getDefaultEndpoint();
        private TransportChannelProvider channelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private CredentialsProvider credentialsProvider = BigQueryWriteSettings.defaultCredentialsProviderBuilder().build();
        private FlowController.LimitExceededBehavior limitExceededBehavior = FlowController.LimitExceededBehavior.Block;
        private String traceId = null;
        private TableSchema updatedTableSchema = null;

        private Builder(String streamName) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = null;
        }

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = (BigQueryWriteClient)Preconditions.checkNotNull((Object)client);
        }

        public Builder setWriterSchema(ProtoSchema writerSchema) {
            this.writerSchema = writerSchema;
            return this;
        }

        public Builder setMaxInflightRequests(long value) {
            this.maxInflightRequest = value;
            return this;
        }

        public Builder setMaxInflightBytes(long value) {
            this.maxInflightBytes = value;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setTraceId(String traceId) {
            int colonIndex = traceId.indexOf(58);
            if (colonIndex == -1 || colonIndex == 0 || colonIndex == traceId.length() - 1) {
                throw new IllegalArgumentException("TraceId must follow the format of A:B. Actual:" + traceId);
            }
            this.traceId = traceId;
            return this;
        }

        public Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) throws StatusRuntimeException {
            if (limitExceededBehavior == FlowController.LimitExceededBehavior.Ignore) {
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("LimitExceededBehavior.Ignore is not supported on StreamWriter."));
            }
            this.limitExceededBehavior = limitExceededBehavior;
            return this;
        }

        public StreamWriter build() throws IOException {
            return new StreamWriter(this);
        }
    }
}

